"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var sharp_1 = __importDefault(require("sharp"));
var CropFunction_1 = __importDefault(require("../lib/CropFunction"));
var Trigger = /** @class */ (function () {
    function Trigger(config) {
        /** An instance of CropFunction defining the rectangle subimage boundaries */
        this.cropFunction = new CropFunction_1["default"]();
        /** An array of filters to apply to the cropped section */
        this.filters = [];
        /** An array of attached effects */
        this.effects = [];
        /** Whether to generate debug output for this trigger **/
        this.debug = false;
        /** Whether this instance is active and listening for trigger events */
        this.enabled = true;
        /** Recursively re-runs the recognize step as fast as possible */
        this.runForever = true;
        /**
         * A parse function to execute on recognized text
         * @param {string} text recognized text (possibly an empty string)
         * @returns {any} context-dependent return value, or no return
         */
        this.parseFunction = function () { return false; };
        this.title = config.title;
        this.id = config.id;
        this.manager = config.manager;
        this.cropFunction = config.cropFunction || this.cropFunction;
        this.parseFunction = config.parseFunction || this.parseFunction;
        this.filters = config.filters || this.filters;
        this.effects = config.effects || this.effects;
        this.enabled = (config.enabled === true || config.enabled === false) ? config.enabled : this.enabled;
        this.runForever = (config.runForever === true || config.runForever === false) ? config.runForever : this.runForever;
        this.debug = (config.debug === true || config.debug === false) ? config.debug : this.debug;
    }
    /**
     * Takes a snapshot of pixels from the <video> element and draws it to the <canvas>,
     * cropping according to the region defined by #this.cropFunction(this.hypetrigger.videoElem)
     */
    Trigger.prototype.filter = function (input) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, data, info, pixelArray, i, width, height, channels, output;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, input.clone().raw().toBuffer({ resolveWithObject: true })];
                    case 1:
                        _a = _b.sent(), data = _a.data, info = _a.info;
                        pixelArray = new Uint8ClampedArray(data.buffer);
                        for (i = 0; i < this.filters.length; i++) {
                            pixelArray = this.filters[i]["function"](pixelArray);
                        }
                        width = info.width, height = info.height, channels = info.channels;
                        return [4 /*yield*/, sharp_1["default"](pixelArray, { raw: { width: width, height: height, channels: channels } })];
                    case 2:
                        output = _b.sent();
                        return [2 /*return*/, Promise.resolve(output)];
                }
            });
        });
    };
    /**
     * Recognizes text in the cropped & filtered image
     * @param {Scheduler} scheduler Tesseract Scheduler used for this job
     */
    Trigger.prototype.recognize = function (scheduler, buffer) {
        return scheduler.addJob('recognize', buffer);
    };
    Trigger.prototype.run = function (inputBuffer) {
        return __awaiter(this, void 0, void 0, function () {
            var img, cropped, filtered, buffer, result, parse;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (this.debug)
                            console.time(this.title);
                        return [4 /*yield*/, sharp_1["default"](inputBuffer)
                            // Crop
                        ];
                    case 1:
                        img = _a.sent();
                        return [4 /*yield*/, this.cropFunction.cropImage(img)];
                    case 2:
                        cropped = _a.sent();
                        if (this.debug)
                            cropped.clone().withMetadata({ density: 70 }).png()
                                .toFile("debug/" + this.id + "-cropped.png")
                                .then(function () { return console.log("[" + _this.id + "] CROP => Wrote debug/" + _this.id + "-cropped.png"); });
                        return [4 /*yield*/, this.filter(cropped.clone())];
                    case 3:
                        filtered = _a.sent();
                        if (this.debug)
                            filtered.clone().withMetadata({ density: 70 }).png()
                                .toFile("debug/" + this.id + "-filtered.png")
                                .then(function () { return console.log("[" + _this.id + "] FILTER => Wrote debug/" + _this.id + "-filtered.png"); });
                        return [4 /*yield*/, filtered.withMetadata({ density: 70 }).png().toBuffer()];
                    case 4:
                        buffer = _a.sent();
                        return [4 /*yield*/, this.recognize(this.manager.scheduler, buffer)];
                    case 5:
                        result = _a.sent();
                        if (this.debug)
                            console.log("[" + this.id + "] OCR => \"" + result.data.text.trim() + "\"");
                        parse = this.parseFunction(result.data.text);
                        if (this.debug)
                            console.log("[" + this.id + "] PARSE => " + parse);
                        if (this.debug)
                            console.timeEnd(this.title);
                        return [2 /*return*/];
                }
            });
        });
    };
    return Trigger;
}());
exports["default"] = Trigger;
//# sourceMappingURL=trigger.js.map