"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var CropFunction_1 = __importDefault(require("../lib/CropFunction"));
var ThresholdFilter_1 = __importDefault(require("../filters/ThresholdFilter"));
var trigger_1 = __importDefault(require("./trigger"));
/**
 * Targets just the word 'VICTORY' on the win screen,
 * in its position after the animation has completed.
 */
var WarzoneVictoryTrigger = /** @class */ (function (_super) {
    __extends(WarzoneVictoryTrigger, _super);
    function WarzoneVictoryTrigger() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.cropFunction = new CropFunction_1["default"]({
            y: (1130 / 1440) * 100,
            yUnit: '%',
            yAnchor: 'top',
            x: (1435 / 2560) * 100,
            xUnit: '%',
            xAnchor: 'left',
            width: (580 / 2560) * 100,
            widthUnit: '%',
            height: (137 / 1440) * 100,
            heightUnit: '%'
        });
        _this.filters = [new ThresholdFilter_1["default"]({
                title: 'Threshold',
                r: 85,
                g: 200,
                b: 255,
                threshold: 42
            })];
        _this.parseFunction = function (text) {
            if (!text.includes('VICTORY'))
                return false;
            _this.manager.logEvent({
                type: 'warzone-victory',
                rawText: text,
                parsed: 'VICTORY',
                msg: '[WarzoneVictoryTrigger] WARZONE VICTORY',
                timestamp: new Date()
            });
            console.log('DUB CITY!!!!!!!');
            return true;
        };
        _this.effects = ['notification', 'music', 'confetti'];
        return _this;
    }
    return WarzoneVictoryTrigger;
}(trigger_1["default"]));
exports["default"] = WarzoneVictoryTrigger;
//# sourceMappingURL=warzone-victory.js.map