"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var CropFunction_1 = __importDefault(require("../lib/CropFunction"));
var ThresholdFilter_1 = __importDefault(require("../filters/ThresholdFilter"));
var trigger_1 = __importDefault(require("./trigger"));
/**
 * Targets the yellow text in the middle of the screen,
 * near the crosshair, after kills and other events.
 * These are internally referred to as 'Medals'
 *
 * https://callofduty.fandom.com/wiki/Medal#Call_of_Duty:_Modern_Warfare_Remastered
 */
var YellowTextTrigger = /** @class */ (function (_super) {
    __extends(YellowTextTrigger, _super);
    function YellowTextTrigger() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * This section can be up to five lines high.
         * The cropped region captures all of it
         * (Note: the XP number to the left of the medals
         * is not captured)
         */
        _this.cropFunction = new CropFunction_1["default"]({
            y: (627 / 1440) * 100,
            yUnit: '%',
            yAnchor: 'top',
            x: (1529 / 2560) * 100,
            xUnit: '%',
            xAnchor: 'left',
            width: (318 / 2560) * 100,
            widthUnit: '%',
            height: (171 / 1440) * 100,
            heightUnit: '%'
        });
        _this.filters = [new ThresholdFilter_1["default"]({
                title: 'Threshold',
                r: 255,
                g: 255,
                b: 0,
                threshold: 42
            })];
        /**
         * The parser mainly looks for strings in all caps
         */
        _this.parseFunction = function (text) {
            var lines = text.split('\n');
            var retVal = false;
            lines.forEach(function (line) {
                if (line.length <= 4)
                    return;
                if (!line.match(/^[A-Z\d\s]+$/))
                    return;
                _this.manager.parseHistory.push({
                    type: 'medal',
                    rawText: line,
                    parsed: line,
                    timestamp: new Date()
                });
                _this.manager.logEvent({
                    type: 'medal',
                    rawText: line,
                    parsed: line,
                    msg: "[YellowTextTrigger] " + line,
                    timestamp: new Date()
                });
                retVal = true;
            });
            return retVal;
        };
        _this.effects = ['notification'];
        return _this;
    }
    return YellowTextTrigger;
}(trigger_1["default"]));
exports["default"] = YellowTextTrigger;
//# sourceMappingURL=yellow-text.js.map