// https://github.com/electron/electron/issues/9920#issuecomment-575839738

import { contextBridge, ipcRenderer } from 'electron'

// Expose protected methods that allow the renderer process to use
// the ipcRenderer without exposing the entire object
contextBridge.exposeInMainWorld(
  'electron', {
    ipcRenderer: {
      send: (channel: any, data: any) => ipcRenderer.send(channel, data),
      on: (channel: any, func: (...args: any) => any) => ipcRenderer.on(channel, (event: any, ...args: any) => func(...args)),
      once: (channel: any, func: (...args: any) => any) => ipcRenderer.once(channel, (event: any, ...args: any) => func(...args)),
      invoke: (channel: any, ...args: any) => ipcRenderer.invoke(channel, ...args),
    }
  }
)
