import Effect from './Effect';

export default class ShowText extends Effect {
  /** Amount of time in seconds to show the text */
  public duration: number = 5

  /** Text to show */
  public text: string = ''

  private timeout: any
  private div?: HTMLDivElement

  init(root?: HTMLElement | Document) {
    if (!root) root = document
    let div = root.querySelector('.show-text-notification')
    if (!div) {
      div = document.createElement('div')
      div.className = 'show-text-notification'
      root.appendChild(div)
    }
    this.div = div as HTMLDivElement
  }

  show() {
    if (!this.div) {
      console.warn('Called show() before initializing ShowText effect')
      return
    }

    this.div.classList.add('show-text-visible')
    if (this.timeout) clearTimeout(this.timeout)
    this.timeout = setTimeout(() => this.hide(), this.duration * 1000)
  }

  hide() {
    if (!this.div) {
      console.warn('Called hide() before initializing ShowText effect')
      return
    }

    this.div.classList.remove('show-text-visible')
    this.timeout = setTimeout(() => this.hide(), this.duration * 1000)
  }
}