import FilterFunction from './FilterFunction'
import { threshold } from './filters'

export default class ThresholdFilter extends FilterFunction {
  r: number = 0
  g: number = 0
  b: number = 0
  threshold: number = 0

  constructor(config: any) {
    super(config)
    this.type = 'threshold'
    this.r = config.r || this.r
    this.g = config.g || this.g
    this.b = config.b || this.b
    this.threshold = config.threshold || this.threshold
    this.function = (pixels: Uint8ClampedArray) => threshold(pixels, [this.r, this.g, this.b], this.threshold)
  }
}
