import { exec } from 'child_process'

export default class GameAutoDetect {
  games: string[] = []
  callback: Function
  period: number
  private timeout: NodeJS.Timeout

  start() {
    setTimeout(async () => {
      const game = await this.getRunningGame()
      if (this.callback) this.callback(game)
      this.start()
    }, this.period)
  }

  stop() {
    if (!this.timeout) return
    clearTimeout(this.timeout)
  }

  getRunningGame(): Promise<string> {
    return new Promise((resolve, reject) => {
      exec('tasklist', (err, stdout, stderr) => {
        for (let i = 0; i < this.games.length; i++) {
          const game = this.games[i]
          const running = stdout.toLowerCase().indexOf(game.toLowerCase()) > -1
          if (running) resolve(game)
        }
        resolve('')
      })
    })
  }
}