/** @source https://stackoverflow.com/questions/38033127/node-js-how-to-check-a-process-is-running-by-the-process-name */

import { exec } from 'child_process'

/**
 * Returns a promise that resolves to true if the current process is running
 */
export default function isRunning(win: string, mac: string, linux: string): Promise<boolean> {
  return new Promise((resolve, reject) => {
    const plat = process.platform
    const cmd = plat === 'win32' ? 'tasklist' : (plat === 'darwin' ? 'ps -ax | grep ' + mac : (plat === 'linux' ? 'ps -A' : ''))
    const proc = plat === 'win32' ? win : (plat === 'darwin' ? mac : (plat === 'linux' ? linux : ''))
    if (cmd === '' || proc === '')
      return resolve(false)
    exec(cmd, (err, stdout, stderr) => {
      resolve(stdout.toLowerCase().indexOf(proc.toLowerCase()) > -1)
    })
  })
}