/**
 * The "mode" is the number that is repeated most often.
 *
 * For example, the "mode" of [3, 5, 4, 4, 1, 1, 2, 3] is [1, 3, 4].
 *
 * @param {Array} numbers An array of numbers.
 * @return {Array} The mode of the specified numbers.
 */
 export function mode(numbers: number[]) {
  // as result can be bimodal or multi-modal,
  // the returned result is provided as an array
  // mode of [3, 5, 4, 4, 1, 1, 2, 3] = [1, 3, 4]
  var modes = [], count: number[] = [], i, number, maxIndex = 0

  for (i = 0; i < numbers.length; i += 1) {
    number = numbers[i]
    count[number] = (count[number] || 0) + 1
    if (count[number] > maxIndex) {
      maxIndex = count[number]
    }
  }

  for (i in count)
    if (count.hasOwnProperty(i)) {
      if (count[i] === maxIndex) {
        modes.push(Number(i))
      }
    }

  return modes;
}