import CropFunction from '../lib/CropFunction'
import ThresholdFilter from '../filters/ThresholdFilter'
import Trigger from './trigger'
import FuzzySet from 'fuzzyset'

const double_kill_fuzzyset = FuzzySet(['DOUBLE KILL'])

/**
 * Targets a "Badge" text which sometimes appears along with a large
 * icon in the top middle.
 */
export default class BadgeTrigger extends Trigger {
  cropFunction = new CropFunction({
    y: (427/1440) * 100,
    yUnit: '%',
    yAnchor: 'top',
    x: (1122/2560) * 100,
    xUnit: '%',
    xAnchor: 'left',
    width: (342/2560) * 100,
    widthUnit: '%',
    height: (45/1440) * 100,
    heightUnit: '%',
  })

  filters = [new ThresholdFilter({
    title: 'Threshold',
    r: 255,
    g: 255,
    b: 255,
    threshold: 15,
  })]

  parseFunction = (text: string) => {
    if (text.length <= 4) return false
    if (!text.match(/^[A-Z\d\s]+$/)) return false

    this.manager.logEvent({
      type: 'badge',
      rawText: text,
      parsed: text,
      msg: `[BadgeTrigger] ${text.trim()}`,
      timestamp: new Date(),
    })

    return true
  }

  effects = ['notification']
}