import CropFunction from '../lib/CropFunction';
import ThresholdFilter from '../filters/ThresholdFilter';
import Trigger from './trigger';

/**
 * Targets just the word 'VICTORY' on the win screen,
 * in its position after the animation has completed.
 */
export default class WarzoneVictoryTrigger extends Trigger {
  cropFunction = new CropFunction({
    y: (1130/1440) * 100,
    yUnit: '%',
    yAnchor: 'top',
    x: (1435/2560) * 100,
    xUnit: '%',
    xAnchor: 'left',
    width: (580/2560) * 100,
    widthUnit: '%',
    height: (137/1440) * 100,
    heightUnit: '%',
  })

  filters = [new ThresholdFilter({
    title: 'Threshold',
    r: 85,
    g: 200,
    b: 255,
    threshold: 42,
  })]

  parseFunction = (text: string) => {
    if (!text.includes('VICTORY')) return false

    this.manager.logEvent({
      type: 'warzone-victory',
      rawText: text,
      parsed: 'VICTORY',
      msg: '[WarzoneVictoryTrigger] WARZONE VICTORY',
      timestamp: new Date(),
    })

    console.log('DUB CITY!!!!!!!')

    return true
  }

  effects = ['notification', 'music', 'confetti']
}