import CropFunction from '../lib/CropFunction'
import ThresholdFilter from '../filters/ThresholdFilter'
import Trigger from './trigger'

/**
 * Targets the yellow text in the middle of the screen,
 * near the crosshair, after kills and other events.
 * These are internally referred to as 'Medals'
 * 
 * https://callofduty.fandom.com/wiki/Medal#Call_of_Duty:_Modern_Warfare_Remastered
 */
export default class YellowTextTrigger extends Trigger {
  /**
   * This section can be up to five lines high.
   * The cropped region captures all of it
   * (Note: the XP number to the left of the medals
   * is not captured)
   */
  cropFunction = new CropFunction({
    y: (627/1440) * 100,
    yUnit: '%',
    yAnchor: 'top',
    x: (1529/2560) * 100,
    xUnit: '%',
    xAnchor: 'left',
    width: (318/2560) * 100,
    widthUnit: '%',
    height: (171/1440) * 100,
    heightUnit: '%',
  })

  filters = [new ThresholdFilter({
    title: 'Threshold',
    r: 255,
    g: 255,
    b: 0,
    threshold: 42,
  })]

  /**
   * The parser mainly looks for strings in all caps
   */
   parseFunction = (text: string) => {
    const lines = text.split('\n')
    let retVal = false
    lines.forEach(line => {
      if (line.length <= 4) return
      if (!line.match(/^[A-Z\d\s]+$/)) return

      this.manager.parseHistory.push({
        type: 'medal',
        rawText: line,
        parsed: line,
        timestamp: new Date(),
      })

      this.manager.logEvent({
        type: 'medal',
        rawText: line,
        parsed: line,
        msg: `[YellowTextTrigger] ${line}`,
        timestamp: new Date(),
      })

      retVal = true
    })

    return retVal
  }

  effects = ['notification']
}

