import type { OBSStats } from 'obs-websocket-js'
import type CropFunction from './lib/CropFunction.js'

//// Clips
export type ClipData = {
  path: string
  date: Date
  new: boolean
  elem: HTMLElement
}

//// Filters
export type ThresholdFilterData = {
  type: 'threshold'
  r: number
  g: number
  b: number
  threshold: number
}

export type FilterData = ThresholdFilterData // A union of more types can be added here

//// Parsers
export type RegexParserData = {
  type: 'regex'
  regex: string
}

export type ParserData = RegexParserData // A union of more types can be added here

//// Triggers
export type TriggerData = {
  id: string
  title: string
  enabled: boolean
  debug: boolean
  crop: CropFunction
  filters: FilterData[]
  parser: ParserData
}

//// Configs
export type ConfigData = {
  id: string
  title: string
  exe?: string
  triggers: TriggerData[]
}

//// Misc
export type VideoCaptureStats = {
  pollingInterval: number
} & OBSStats

export type ClipSection = {
  date: Date
  elem: HTMLElement
}