function SearchIndex() {
	this.reset();
}

SearchIndex.prototype.reset = function() {
	this.index_field = [];
	this.index_source = {};
}

SearchIndex.prototype.TokenizerType = {
   TOKENZIER_TYPE_NAME:0,
   TOKENZIER_TYPE_PHONE:1,
   TOKENZIER_TYPE_TEXT:2,
   TOKENZIER_TYPE_NOTOKEN:3,
};

/**
 * @brief IndexField specify the create search index column and the type
 * @param field_name(string) specify the create search index column
 * @param tokenizer_type(TokenizerType) specify the create index column type
 */
SearchIndex.prototype.addIndexField = function(field_name, tokenizer_type) {
	var object = {};
	object['field_name'] = field_name;
	object['tokenizer_type'] = tokenizer_type;
	this.index_field.push(object);
}

SearchIndex.prototype.getIndexField = function() {
	return this.index_field;
}

/**
 * @brief Add the SQLite DB Source to Search Index
 * @param index_name(string) add to which index
 * @param db_name(string) the source db
 * @param table_name(string) the source table
 * @param key_field(string) the source table primary key
 * @param where_condition(string)  the condition for create index.
 * @param start_rowid(int64)  should be number
 */
SearchIndex.prototype.addIndexSource = function(index_name, db_name, table_name,
												key_field, where_condition, start_rowid) {
	this.index_source['index_name'] = index_name;
	this.index_source['db_name'] = db_name;
	this.index_source['table_name'] = table_name;
	this.index_source['key_field'] = key_field;
	this.index_source['where_condition'] = where_condition;
	this.index_source['start_rowid'] = start_rowid;
}

SearchIndex.prototype.getIndexSource = function() {
	return this.index_source;
}

/**
 * @brief get the IndexToSource Result for Search,This should be JSON Object.
 */
SearchIndex.prototype.stringify = function() {
	this.index_source['index_field'] = this.index_field;
	return JSON.stringify(this.index_source);
}

module.exports = SearchIndex;