//
//  Created by dingsu on 1/22/16.
//  Copyright © 2016 miechal. All rights reserved.
//
// var sqlite  = require("@ali/dingtalk-sqlite3");
// var sqlite3 = sqlite.verbose();
var sqlite3 = require('./sqlite3');

/**
 * @brief SearchProvider offer Native Search ability
 * @param index_path specify the directory storage that for search index.
 * @param callback specify the native async result callback function.
 */
function SearchProvider() {
	this.searchProvider = new sqlite3.SearchProvider();
}

/**
 * @brief async init native search module
 * @param index_path specify the directory storage that for search index.
 * @param callback specify the native async result callback function.
 */
SearchProvider.prototype.open = function(index_path, native_callback) {
	this.searchProvider.open(index_path, native_callback);
}

/**
 * @brief binding write db connection and read db connection for native search
 * @param db_name search database name
 * @param hook_conn the write Database Object
 * @param read_conn the read Database Object
 */
SearchProvider.prototype.setDBConnection = function(db_name, hook_conn, read_conn, scan_conn) {
	this.searchProvider.setDBConnection(db_name, hook_conn.sqliteHandler(""), read_conn.sqliteHandler(""), scan_conn.sqliteHandler(""));
}

SearchProvider.prototype.addSourceToIndex = function(index_source) {
	this.searchProvider.addSourceToIndex(index_source);
}

/**
 * @brief search for the input query source
 * @param index_name(string) the index name for search
 * @param use_syntax query should be use syntax
 * @param query(string)  input query source.
 * @param start(Number) where to start return record.
 * @param num(Number) the result record number.
 */
SearchProvider.prototype.search = function(index_name, use_syntax, query, start, num, callback) {
	this.searchProvider.search(index_name, use_syntax, query, start, num, function(search_result) {
		var SearchResult = require('./SearchResult');
		var searchResult = new SearchResult();
		searchResult.parseSearchResult(search_result);
		callback && callback(searchResult);
	});
}

SearchProvider.prototype.startScan = function() {
	this.searchProvider.startScan();
}

SearchProvider.prototype.startHook = function() {
	this.searchProvider.startHook();
}

SearchProvider.prototype.deleteAllIndexAndData = function(callback) {
	this.searchProvider.deleteAllIndexAndData(function() {
		callback && callback();
	});
}

SearchProvider.prototype.close = function() {
    this.searchProvider.close();
}

SearchProvider.prototype.stop = function() {
    this.searchProvider.stop();
}

module.exports = SearchProvider;
