/*
 * Decompiled with CFR 0.152.
 */
package com.bjpowernode.exam.manager;

import com.bjpowernode.exam.model.Classes;
import com.bjpowernode.exam.util.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ClassesManager {
    private static ClassesManager instance = new ClassesManager();

    private ClassesManager() {
    }

    public static ClassesManager getInstance() {
        return instance;
    }

    public void outClassesList() {
        Connection conn = null;
        try {
            try {
                conn = DbUtil.getConnection();
                this.outClassesList(conn, 0, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                DbUtil.close(conn);
            }
        }
        finally {
            DbUtil.close(conn);
        }
    }

    private void outClassesList(Connection conn, int classesId, int level) throws SQLException {
        String sql = "select * from t_classes where pid=?";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String s = "";
            int i = 0;
            while (i < level) {
                s = String.valueOf(s) + "  ";
                ++i;
            }
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, classesId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                System.out.println(String.valueOf(s) + rs.getInt("classes_id") + "\u3010" + rs.getString("classes_name") + "\u3011");
                if (rs.getInt("leaf") != 0) continue;
                this.outClassesList(conn, rs.getInt("classes_id"), level + 1);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
    }

    public void addClasses(int pid, String classesName) {
        block6: {
            String sql = "insert into t_classes(pid, classes_name) values(?, ?)";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    DbUtil.setAutoCommit(conn, false);
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, pid);
                    pstmt.setString(2, classesName);
                    pstmt.executeUpdate();
                    Classes parentClasses = this.findClassesById(pid);
                    if (parentClasses.getLeaf() == 1) {
                        this.modifyLeaf(conn, parentClasses.getClassesId(), 0);
                    }
                    DbUtil.commit(conn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DbUtil.rollback(conn);
                    DbUtil.close(pstmt);
                    DbUtil.setAutoCommit(conn, true);
                    DbUtil.close(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.setAutoCommit(conn, true);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.setAutoCommit(conn, true);
            DbUtil.close(conn);
        }
    }

    private void modifyLeaf(Connection conn, int classesId, int leaf) throws SQLException {
        String sql = "update t_classes set leaf=? where classes_id=?";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, leaf);
            pstmt.setInt(2, classesId);
            pstmt.executeUpdate();
        }
        finally {
            DbUtil.close(pstmt);
        }
    }

    public Classes findClassesById(int classesId) {
        Classes classes;
        block6: {
            String sql = "select * from t_classes where classes_id=?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            classes = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, classesId);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        classes = new Classes();
                        classes.setClassesId(classesId);
                        classes.setClassesName(rs.getString("classes_name"));
                        classes.setPid(rs.getInt("pid"));
                        classes.setLeaf(rs.getInt("leaf"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DbUtil.close(rs);
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
        return classes;
    }

    public void modifyClasses(int classesId, String classesName) {
        block5: {
            String sql = "update t_classes set classes_name=? where classes_id=?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, classesName);
                    pstmt.setInt(2, classesId);
                    pstmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }

    public void delClasses(int classesId) {
        Connection conn = null;
        try {
            try {
                conn = DbUtil.getConnection();
                DbUtil.setAutoCommit(conn, false);
                Classes classes = this.findClassesById(classesId);
                this.delClasses(conn, classesId);
                int count = this.getChildren(conn, classes.getPid());
                if (count == 0) {
                    this.modifyLeaf(conn, classes.getPid(), 1);
                }
                DbUtil.commit(conn);
            }
            catch (Exception e) {
                e.printStackTrace();
                DbUtil.rollback(conn);
                DbUtil.close(conn);
            }
        }
        finally {
            DbUtil.close(conn);
        }
    }

    private void delClasses(Connection conn, int classesId) throws Exception {
        String sql = "select * from t_classes where pid=?";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, classesId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (rs.getInt("leaf") == 0) {
                        this.delClasses(conn, rs.getInt("classes_id"));
                    }
                    this.delClassesById(conn, rs.getInt("classes_id"));
                }
                this.delClassesById(conn, classesId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
    }

    private void delClassesById(Connection conn, int classesId) throws Exception {
        String sql = "delete from t_classes where classes_id=?";
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, classesId);
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(pstmt);
            throw throwable;
        }
        DbUtil.close(pstmt);
    }

    private int getChildren(Connection conn, int classsesId) throws SQLException {
        String sql = "select count(*) from t_classes where pid=?";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int count = 0;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, classsesId);
            rs = pstmt.executeQuery();
            rs.next();
            count = rs.getInt(1);
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
        return count;
    }

    public static void main(String[] args) {
        ClassesManager.getInstance().outClassesList();
    }
}

