/*
 * Decompiled with CFR 0.152.
 */
package com.bjpowernode.exam.util;

import com.bjpowernode.exam.util.ExamConfigReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DbUtil {
    public static Connection getConnection() {
        Connection conn = null;
        try {
            String driverName = ExamConfigReader.getInstance().getPropertyValue("dirver-name");
            String dbUrl = ExamConfigReader.getInstance().getPropertyValue("url");
            String username = ExamConfigReader.getInstance().getPropertyValue("username");
            String password = ExamConfigReader.getInstance().getPropertyValue("password");
            Class.forName(driverName);
            conn = DriverManager.getConnection(dbUrl, username, password);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    public static void close(PreparedStatement pstmt) {
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setAutoCommit(Connection conn, boolean autoCommit) {
        try {
            if (conn != null && conn.getAutoCommit() != autoCommit) {
                conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void commit(Connection conn) {
        try {
            if (conn != null && !conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void rollback(Connection conn) {
        try {
            if (conn != null && !conn.getAutoCommit()) {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Connection conn = DbUtil.getConnection();
        System.out.println(conn);
    }
}

