/*
 * Decompiled with CFR 0.152.
 */
package com.bjpowernode.exam.controller;

import com.bjpowernode.exam.manager.GradeManager;
import com.bjpowernode.exam.model.Grade;
import com.bjpowernode.exam.util.ExamConfigReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class GradeController {
    private static final String ADD = "1";
    private static final String DEL = "2";
    private static final String MODIFY = "3";
    private static final String QUERY_STUDENT_ID = "4";
    private static final String QUERY_HIGHER_GRADE = "5";
    private static final String QUERY_TOP3 = "6";
    private static final String QUERY = "7";
    private static final String QUIT = "q";
    private static String state = "";
    private static GradeManager gradeManager;

    static {
        String className = ExamConfigReader.getInstance().getPropertyValue("grade-manager-impl");
        try {
            Class<?> c = Class.forName(className);
            gradeManager = (GradeManager)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        block26: {
            System.out.println("1-\u6dfb\u52a0\u6210\u7ee9");
            System.out.println("2-\u5220\u9664\u6210\u7ee9");
            System.out.println("3-\u4fee\u6539\u6210\u7ee9");
            System.out.println("4-\u6839\u636e\u5b66\u751f\u4ee3\u7801\u67e5\u8be2\u6210\u7ee9");
            System.out.println("5-\u67e5\u8be2\u6bcf\u79d1\u6700\u9ad8\u5206");
            System.out.println("6-\u67e5\u8be2\u603b\u5206\u524d\u4e09\u540d");
            System.out.println("7-\u5206\u9875\u67e5\u8be2");
            System.out.println("q-\u9000\u51fa");
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(System.in));
                    String s = null;
                    while ((s = br.readLine()) != null) {
                        if (ADD.equals(s)) {
                            System.out.println("\u8bf7\u8f93\u5165\u6dfb\u52a0\u7684\u6210\u7ee9(student_id=#,course_id=#,grade=#):");
                            state = ADD;
                            continue;
                        }
                        if (DEL.equals(s)) {
                            System.out.println("\u8bf7\u8f93\u5165\u5220\u9664\u7684\u5b66\u751f\u4ee3\u7801\u548c\u8bfe\u7a0b\u4ee3\u7801(student_id=#,course_id=#):");
                            state = DEL;
                            continue;
                        }
                        if (MODIFY.equals(s)) {
                            System.out.println("\u8bf7\u8f93\u5165\u4fee\u6539\u7684\u6210\u7ee9(student_id=#,course_id=#,grade=#):");
                            state = MODIFY;
                            continue;
                        }
                        if (QUERY_STUDENT_ID.equals(s)) {
                            System.out.println("\u6839\u636e\u5b66\u751f\u4ee3\u7801\u67e5\u8be2\u6210\u7ee9(student_id=#):");
                            state = QUERY_STUDENT_ID;
                            continue;
                        }
                        if (QUERY_HIGHER_GRADE.equals(s)) {
                            System.out.println("\u56de\u8f66\u67e5\u8be2\u6bcf\u79d1\u6700\u9ad8\u5206");
                            state = QUERY_HIGHER_GRADE;
                            continue;
                        }
                        if (QUERY_TOP3.equals(s)) {
                            System.out.println("\u56de\u8f66\u67e5\u8be2\u603b\u5206\u524d\u4e09\u540d");
                            state = QUERY_TOP3;
                            continue;
                        }
                        if (QUERY.equals(s)) {
                            System.out.println("\u5206\u9875\u67e5\u8be2\u5b66\u751f\u6210\u7ee9(pageNo=#,pageSize=#):");
                            state = QUERY;
                            continue;
                        }
                        if (QUIT.equalsIgnoreCase(s)) break;
                        if (ADD.equals(state)) {
                            GradeController.addGrade(s);
                            continue;
                        }
                        if (DEL.equals(state)) {
                            GradeController.delGrade(s);
                            continue;
                        }
                        if (MODIFY.equals(state)) {
                            GradeController.modifyGrade(s);
                            continue;
                        }
                        if (QUERY_STUDENT_ID.equals(state)) {
                            GradeController.findGradeByStudentById(s);
                            continue;
                        }
                        if (QUERY_HIGHER_GRADE.equals(state)) {
                            GradeController.findHigherGradeListOfPerCourse();
                            continue;
                        }
                        if (QUERY_TOP3.equals(state)) {
                            GradeController.findGradeListTop3();
                            continue;
                        }
                        if (!QUERY.equals(state)) continue;
                        GradeController.findGradeList(s);
                    }
                    System.err.println("\u6b63\u5e38\u9000\u51fa");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br == null) break block26;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void findHigherGradeListOfPerCourse() {
        List<Grade> gradeList = gradeManager.findHigherGradeListOfPerCourse();
        GradeController.printGradeList(gradeList);
    }

    private static void findGradeListTop3() {
        List<Grade> gradeList = gradeManager.findGradeListTop3();
        for (Grade grade : gradeList) {
            System.out.print("\u5b66\u751f\u4ee3\u7801:" + grade.getStudent().getStudentId());
            System.out.print(" \u5b66\u751f\u59d3\u540d:" + grade.getStudent().getStudentName());
            System.out.print(" \u6240\u5c5e\u73ed\u7ea7:" + grade.getStudent().getClasses().getClassesName());
            System.out.println(" \u6210\u7ee9:" + new DecimalFormat("####.00").format(grade.getGrade()));
        }
    }

    private static void addGrade(String s) {
        Map paramMap = GradeController.parseParam(s);
        int studentId = (Integer)paramMap.get("student_id");
        int courseId = (Integer)paramMap.get("course_id");
        float grade = ((Float)paramMap.get("grade")).floatValue();
        gradeManager.addGrade(studentId, courseId, grade);
        System.out.println("\u6dfb\u52a0\u6210\u7ee9\u6210\u529f\uff01\uff01\uff01");
    }

    private static void modifyGrade(String s) {
        Map paramMap = GradeController.parseParam(s);
        int studentId = (Integer)paramMap.get("student_id");
        int courseId = (Integer)paramMap.get("course_id");
        float grade = ((Float)paramMap.get("grade")).floatValue();
        gradeManager.modifyGrade(studentId, courseId, grade);
        System.out.println("\u4fee\u6539\u6210\u7ee9\u6210\u529f\uff01\uff01\uff01");
    }

    private static void delGrade(String s) {
        Map paramMap = GradeController.parseParam(s);
        int studentId = (Integer)paramMap.get("student_id");
        int courseId = (Integer)paramMap.get("course_id");
        gradeManager.delGrade(studentId, courseId);
        System.out.println("\u5220\u9664\u6210\u7ee9\u6210\u529f\uff01\uff01\uff01");
    }

    private static void findGradeByStudentById(String s) {
        Map paramMap = GradeController.parseParam(s);
        int studentId = (Integer)paramMap.get("student_id");
        List<Grade> gradeList = gradeManager.findGradeList(studentId);
        GradeController.printGradeList(gradeList);
    }

    private static void printGradeList(List gradeList) {
        for (Grade grade : gradeList) {
            System.out.print("\u5b66\u751f\u4ee3\u7801:" + grade.getStudent().getStudentId());
            System.out.print(" \u5b66\u751f\u59d3\u540d:" + grade.getStudent().getStudentName());
            System.out.print(" \u6240\u5c5e\u73ed\u7ea7:" + grade.getStudent().getClasses().getClassesName());
            System.out.print(" \u8bfe\u7a0b\u540d\u79f0:" + grade.getCourse().getCourseName());
            System.out.println(" \u6210\u7ee9:" + new DecimalFormat("####.00").format(grade.getGrade()));
        }
    }

    private static void findGradeList(String s) {
        Map paramMap = GradeController.parseParam(s);
        int pageNo = (Integer)paramMap.get("pageNo");
        int pageSize = (Integer)paramMap.get("pageSize");
        List<Grade> gradeList = gradeManager.findGradeList(pageNo, pageSize);
        GradeController.printGradeList(gradeList);
    }

    private static Map parseParam(String s) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        StringTokenizer st1 = new StringTokenizer(s, ",");
        while (st1.hasMoreTokens()) {
            String t1 = st1.nextToken();
            StringTokenizer st2 = new StringTokenizer(t1, "=");
            if (!st2.hasMoreTokens()) continue;
            String leftStr = st2.nextToken();
            if ("student_id".equals(leftStr)) {
                if (!st2.hasMoreTokens()) continue;
                paramMap.put("student_id", Integer.parseInt(st2.nextToken()));
                continue;
            }
            if ("course_id".equals(leftStr)) {
                if (!st2.hasMoreTokens()) continue;
                paramMap.put("course_id", Integer.parseInt(st2.nextToken()));
                continue;
            }
            if ("grade".equals(leftStr)) {
                if (!st2.hasMoreTokens()) continue;
                paramMap.put("grade", Float.valueOf(Float.parseFloat(st2.nextToken())));
                continue;
            }
            if ("pageNo".equals(leftStr)) {
                if (!st2.hasMoreTokens()) continue;
                paramMap.put("pageNo", Integer.parseInt(st2.nextToken()));
                continue;
            }
            if (!"pageSize".equals(leftStr) || !st2.hasMoreTokens()) continue;
            paramMap.put("pageSize", Integer.parseInt(st2.nextToken()));
        }
        return paramMap;
    }
}

