/*
 * Decompiled with CFR 0.152.
 */
package com.bjpowernode.exam.controller;

import com.bjpowernode.exam.manager.StudentManager;
import com.bjpowernode.exam.model.Classes;
import com.bjpowernode.exam.model.Student;
import com.bjpowernode.exam.util.DateUtil;
import com.bjpowernode.exam.util.ExamConfigReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class StudentController {
    private static final String ADD = "1";
    private static final String DEL = "2";
    private static final String MODIFY = "3";
    private static final String QUERY = "4";
    private static final String EXPORT = "5";
    private static final String QUIT = "q";
    private static String state = "";
    private static StudentManager studentManager = null;

    static {
        String className = ExamConfigReader.getInstance().getPropertyValue("student-manager-impl");
        try {
            studentManager = (StudentManager)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        block22: {
            System.out.println("1-\u6dfb\u52a0\u5b66\u751f");
            System.out.println("2-\u5220\u9664\u5b66\u751f");
            System.out.println("3-\u4fee\u6539\u5b66\u751f");
            System.out.println("4-\u67e5\u8be2\u5b66\u751f");
            System.out.println("5-\u5bfc\u51fa\u5b66\u751f\u4fe1\u606f");
            System.out.println("q-\u9000\u51fa");
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(System.in));
                    String s = null;
                    while ((s = br.readLine()) != null) {
                        if (ADD.equals(s)) {
                            System.out.println("\u8bf7\u8f93\u5165\u6dfb\u52a0\u7684\u5b66\u751f(student_name=#,sex=#,birthday=#,contac_tel=#,address=#,classes_id=#):");
                            state = ADD;
                            continue;
                        }
                        if (DEL.equals(s)) {
                            System.out.println("\u8bf7\u8f93\u5165\u5220\u9664\u7684\u5b66\u751f\u4ee3\u7801(student_id=#):");
                            state = DEL;
                            continue;
                        }
                        if (MODIFY.equals(s)) {
                            System.out.println("\u8bf7\u8f93\u5165\u4fee\u6539\u7684\u5b66\u751f(student_id=#,student_name=#,sex=#,birthday=#,contac_tel=#,address=#,classes_id=#):");
                            state = MODIFY;
                            continue;
                        }
                        if (QUERY.equals(s)) {
                            System.out.println("\u5206\u9875\u67e5\u8be2\u5b66\u751f\uff0c\u8bf7\u8f93\u5165(pageNo=#,pageSize=#):");
                            state = QUERY;
                            continue;
                        }
                        if (EXPORT.equals(s)) {
                            System.out.println("\u8f93\u5165\u56de\u8f66\u5c06\u5b66\u751f\u4fe1\u606f\u5bfc\u51fa\u5230\u6587\u4ef6");
                            state = EXPORT;
                            continue;
                        }
                        if (QUIT.equalsIgnoreCase(s)) break;
                        if (ADD.equals(state)) {
                            StudentController.addStudent(s);
                            continue;
                        }
                        if (DEL.equals(state)) {
                            StudentController.delStudent(s);
                            continue;
                        }
                        if (MODIFY.equals(state)) {
                            StudentController.modifyStudent(s);
                            continue;
                        }
                        if (QUERY.equals(state)) {
                            StudentController.outStudent(s);
                            continue;
                        }
                        if (!EXPORT.equals(state)) continue;
                        StudentController.export();
                    }
                    System.err.println("\u6b63\u5e38\u9000\u51fa");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br == null) break block22;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static Student makeStudent(String s) {
        String[] studentArray = s.split(",");
        Student student = new Student();
        int i = 0;
        while (i < studentArray.length) {
            String[] values = studentArray[i].split("=");
            if ("student_id".equals(values[0])) {
                student.setStudentId(Integer.parseInt(values[1]));
            } else if ("student_name".equals(values[0])) {
                student.setStudentName(values[1]);
            } else if ("sex".equals(values[0])) {
                student.setSex(values[1]);
            } else if ("birthday".equals(values[0])) {
                try {
                    student.setBirthday(new SimpleDateFormat("yyyy-MM-dd").parse(values[1]));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else if ("contac_tel".equals(values[0])) {
                student.setContactTel(values[1]);
            } else if ("address".equals(values[0])) {
                student.setAddress(values[1]);
            } else if ("classes_id".equals(values[0])) {
                Classes classes = new Classes();
                classes.setClassesId(Integer.parseInt(values[1]));
                student.setClasses(classes);
            }
            ++i;
        }
        return student;
    }

    private static void addStudent(String s) {
        Student student = StudentController.makeStudent(s);
        studentManager.addStudent(student);
        System.out.println("\u6dfb\u52a0\u5b66\u751f\u6210\u529f\uff01\uff01");
    }

    private static void modifyStudent(String s) {
        Student student = StudentController.makeStudent(s);
        studentManager.modifyStudent(student);
        System.out.println("\u4fee\u6539\u5b66\u751f\u6210\u529f\uff01\uff01");
    }

    private static void outStudent(String s) {
        String[] studentArray = s.split(",");
        int pageNo = Integer.parseInt(studentArray[0].split("=")[1]);
        int pageSize = Integer.parseInt(studentArray[1].split("=")[1]);
        List<Student> studentList = studentManager.findStudentList(pageNo, pageSize);
        int i = 0;
        while (i < studentList.size()) {
            Student student = studentList.get(i);
            System.out.print("\u5b66\u751f\u4ee3\u7801:" + student.getStudentId());
            System.out.print(", \u5b66\u751f\u59d3\u540d:" + student.getStudentName());
            System.out.print(", \u6027\u522b:" + student.getSex());
            System.out.print(", \u51fa\u751f\u65e5\u671f:" + new SimpleDateFormat("yyyy/MM/dd").format(student.getBirthday()));
            System.out.print(", \u8054\u7cfb\u7535\u8bdd:" + student.getContactTel());
            System.out.print(", \u5730\u5740:" + student.getAddress());
            System.out.print(", \u73ed\u7ea7\u540d\u79f0:" + student.getClasses().getClassesName());
            long b = 31536000000L;
            long a = System.currentTimeMillis() - student.getBirthday().getTime();
            System.out.print(", \u5e74\u9f84:" + a / b);
            System.out.println("");
            ++i;
        }
    }

    private static void delStudent(String s) {
        int studentId = Integer.parseInt(s.split("=")[1]);
        studentManager.delStudent(studentId);
        System.out.println("\u5220\u9664\u5b66\u751f\u6210\u529f\uff01\uff01");
    }

    private static void export() {
        block14: {
            File file = new File("c:\\student");
            if (!file.exists()) {
                file.mkdir();
            }
            StringBuffer sbString = new StringBuffer();
            List<Student> studentList = studentManager.findStudentList();
            for (Student student : studentList) {
                sbString.append("\u5b66\u751f\u4ee3\u7801:").append(student.getStudentId()).append("\u5b66\u751f\u59d3\u540d:").append(student.getStudentName()).append("\u6027\u522b:").append(student.getSex()).append("\u51fa\u751f\u65e5\u671f:").append(DateUtil.formatDate(student.getBirthday())).append("\u8054\u7cfb\u7535\u8bdd:").append(student.getContactTel()).append("\u5730\u5740:").append(student.getAddress()).append("\u73ed\u7ea7\u540d\u79f0:").append(student.getClasses().getClassesName()).append("\u5e74\u9f84:").append(student.getAge()).append("\n");
            }
            String fileName = String.valueOf(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2").format(new Date())) + ".dat";
            BufferedWriter bw = null;
            try {
                try {
                    bw = new BufferedWriter(new FileWriter(new File(file, fileName)));
                    bw.write(sbString.toString());
                    System.out.println("\u5bfc\u51fa\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u4f4d\u7f6e\uff1a" + file.getPath() + "\\" + fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (bw == null) break block14;
                    try {
                        bw.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

