/*
 * Decompiled with CFR 0.152.
 */
package com.bjpowernode.exam.manager;

import com.bjpowernode.exam.model.Course;
import com.bjpowernode.exam.util.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseManager {
    private static CourseManager instance = new CourseManager();

    private CourseManager() {
    }

    public static CourseManager getInstance() {
        return instance;
    }

    public void addCourse(String courseName) {
        block5: {
            String sql = "insert into t_course(course_name) values(?)";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, courseName);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }

    public List<Course> findCourseList() {
        ArrayList<Course> courseList;
        block6: {
            String sql = "select * from t_course order by course_id";
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            courseList = new ArrayList<Course>();
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int courseId = rs.getInt("course_id");
                        String courseName = rs.getString("course_name");
                        Course course = new Course();
                        course.setCourseId(courseId);
                        course.setCourseName(courseName);
                        courseList.add(course);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
        return courseList;
    }

    public void delCourse(int courseId) {
        block5: {
            String sql = "delete from t_course where course_id=?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, courseId);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }

    public void modifyCourse(int courseId, String courseName) {
        block5: {
            String sql = "update t_course set course_name=? where course_id=?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, courseName);
                    pstmt.setInt(2, courseId);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }
}

