/*
 * Decompiled with CFR 0.152.
 */
package com.bjpowernode.exam.manager;

import com.bjpowernode.exam.manager.GradeManager;
import com.bjpowernode.exam.model.Classes;
import com.bjpowernode.exam.model.Course;
import com.bjpowernode.exam.model.Grade;
import com.bjpowernode.exam.model.Student;
import com.bjpowernode.exam.util.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradeManagerImpl
implements GradeManager {
    @Override
    public void addGrade(int studentId, int courseId, float grade) {
        block5: {
            String sql = "insert into t_grade(student_id, course_id, grade) values(?, ?, ?)";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, studentId);
                    pstmt.setInt(2, courseId);
                    pstmt.setFloat(3, grade);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }

    @Override
    public void delGrade(int studentId, int courseId) {
        block5: {
            String sql = "delete from t_grade where student_id=? and course_id=?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, studentId);
                    pstmt.setInt(2, courseId);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }

    @Override
    public List<Grade> findGradeList(int pageNo, int pageSize) {
        List<Grade> gradeList;
        block5: {
            StringBuffer sbSql = new StringBuffer();
            sbSql.append("select student_id, student_name, classes_name, course_name, grade from ").append("(").append("select rownum as rn, student_id, student_name, classes_name, course_name, grade from ").append("(").append("select g.student_id, s.student_name, cls.classes_name, c.course_name, g.grade ").append("from t_grade g join t_student s on g.student_id=s.student_id ").append("join t_classes cls on s.classes_id=cls.classes_id ").append("join t_course c on g.course_id=c.course_id order by g.student_id,g.course_id ").append(") where rownum <=? ").append(") where rn>? ");
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            gradeList = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sbSql.toString());
                    pstmt.setInt(1, pageNo * pageSize);
                    pstmt.setInt(2, (pageNo - 1) * pageSize);
                    rs = pstmt.executeQuery();
                    gradeList = this.makeGradeList(rs);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(rs);
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
        return gradeList;
    }

    @Override
    public List<Grade> findGradeList(int studentId) {
        List<Grade> gradeList;
        block5: {
            StringBuffer sbSql = new StringBuffer();
            sbSql.append("select g.student_id, s.student_name, cls.classes_name, c.course_name, g.grade ").append("from t_grade g join t_student s on g.student_id=s.student_id ").append("join t_classes cls on s.classes_id=cls.classes_id ").append("join t_course c on g.course_id=c.course_id ").append("where g.student_id=?");
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            gradeList = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sbSql.toString());
                    pstmt.setInt(1, studentId);
                    rs = pstmt.executeQuery();
                    gradeList = this.makeGradeList(rs);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(rs);
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
        return gradeList;
    }

    private List<Grade> makeGradeList(ResultSet rs) throws SQLException {
        ArrayList<Grade> gradeList = new ArrayList<Grade>();
        while (rs.next()) {
            Grade grade = new Grade();
            Student student = new Student();
            student.setStudentId(rs.getInt("student_id"));
            student.setStudentName(rs.getString("student_name"));
            Classes classes = new Classes();
            classes.setClassesName(rs.getString("classes_name"));
            student.setClasses(classes);
            grade.setStudent(student);
            Course course = new Course();
            course.setCourseName(rs.getString("course_name"));
            grade.setCourse(course);
            grade.setGrade(rs.getFloat("grade"));
            gradeList.add(grade);
        }
        return gradeList;
    }

    @Override
    public List<Grade> findGradeListTop3() {
        ArrayList<Grade> gradeList;
        block6: {
            StringBuilder sbSql = new StringBuilder();
            sbSql.append("select * from ");
            sbSql.append("(");
            sbSql.append("select g.student_id, s.student_name, cls.classes_name, sum(g.grade) total_grade ");
            sbSql.append("from t_grade g join t_student s on g.student_id=s.student_id ");
            sbSql.append("join t_classes cls on s.classes_id=cls.classes_id ");
            sbSql.append("group by g.student_id, s.student_name, cls.classes_name ");
            sbSql.append("order by total_grade desc ");
            sbSql.append(") where rownum <=3 ");
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            gradeList = new ArrayList<Grade>();
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sbSql.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Grade grade = new Grade();
                        Student student = new Student();
                        student.setStudentId(rs.getInt("student_id"));
                        student.setStudentName(rs.getString("student_name"));
                        Classes classes = new Classes();
                        classes.setClassesName(rs.getString("classes_name"));
                        student.setClasses(classes);
                        grade.setStudent(student);
                        grade.setGrade(rs.getFloat("total_grade"));
                        gradeList.add(grade);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(rs);
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
        return gradeList;
    }

    @Override
    public List<Grade> findHigherGradeListOfPerCourse() {
        List<Grade> gradeList;
        block5: {
            StringBuffer sbSql = new StringBuffer();
            sbSql.append("select s.student_id, s.student_name, cls.classes_name, c.course_name, g.grade ");
            sbSql.append("from t_grade g join t_student s on g.student_id=s.student_id ");
            sbSql.append("join t_classes cls on s.classes_id=cls.classes_id ");
            sbSql.append("join t_course c on g.course_id=c.course_id ");
            sbSql.append("where g.grade in (select max(gg.grade) from t_grade gg where gg.course_id=c.course_id) ");
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            gradeList = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sbSql.toString());
                    rs = pstmt.executeQuery();
                    gradeList = this.makeGradeList(rs);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(rs);
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
        return gradeList;
    }

    @Override
    public void modifyGrade(int studentId, int courseId, float grade) {
        block5: {
            String sql = "update t_grade set grade=? where student_id=? and course_id=?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setFloat(1, grade);
                    pstmt.setInt(2, studentId);
                    pstmt.setInt(3, courseId);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }
}

