/*
 * Decompiled with CFR 0.152.
 */
package com.bjpowernode.exam.manager;

import com.bjpowernode.exam.manager.StudentManager;
import com.bjpowernode.exam.model.Classes;
import com.bjpowernode.exam.model.Student;
import com.bjpowernode.exam.util.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentManagerImpl
implements StudentManager {
    @Override
    public void addStudent(Student student) {
        block5: {
            String sql = "insert into t_student(classes_id, student_name, sex, birthday, contact_tel, address) values(?, ?, ?, ?, ?, ?)";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, student.getClasses().getClassesId());
                    pstmt.setString(2, student.getStudentName());
                    pstmt.setString(3, student.getSex());
                    pstmt.setDate(4, new java.sql.Date(student.getBirthday().getTime()));
                    pstmt.setString(5, student.getContactTel());
                    pstmt.setString(6, student.getAddress());
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }

    @Override
    public void delStudent(int studentId) {
        block5: {
            String sql = "delete from t_student where student_id=?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, studentId);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }

    @Override
    public List<Student> findStudentList(int pageNo, int pageSize) {
        ArrayList<Student> studentList;
        block6: {
            StringBuffer sbSql = new StringBuffer();
            sbSql.append("select * from ").append("(").append("select rownum as rn, t.* ").append("from ").append("(").append("select s.*, c.classes_name from t_student s join t_classes c on s.classes_id=c.classes_id order by s.student_id ").append(") t where rownum <=? ").append(") ").append("where rn > ?");
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            studentList = new ArrayList<Student>();
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sbSql.toString());
                    pstmt.setInt(1, pageNo * pageSize);
                    pstmt.setInt(2, (pageNo - 1) * pageSize);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Student student = new Student();
                        student.setStudentId(rs.getInt("student_id"));
                        student.setStudentName(rs.getString("student_name"));
                        student.setSex(rs.getString("sex"));
                        student.setBirthday(rs.getDate("birthday"));
                        student.setContactTel(rs.getString("contact_tel"));
                        student.setAddress(rs.getString("address"));
                        Classes classes = new Classes();
                        classes.setClassesName(rs.getString("classes_name"));
                        student.setClasses(classes);
                        studentList.add(student);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(rs);
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
        return studentList;
    }

    @Override
    public void modifyStudent(Student student) {
        block5: {
            String sql = "update t_student set classes_id=?, student_name=?, sex=?, birthday=?, contact_tel=?, address=? where student_id=?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, student.getClasses().getClassesId());
                    pstmt.setString(2, student.getStudentName());
                    pstmt.setString(3, student.getSex());
                    pstmt.setDate(4, new java.sql.Date(student.getBirthday().getTime()));
                    pstmt.setString(5, student.getContactTel());
                    pstmt.setString(6, student.getAddress());
                    pstmt.setInt(7, student.getStudentId());
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }

    @Override
    public List<Student> findStudentList() {
        return this.findStudentList(1, Integer.MAX_VALUE);
    }

    @Override
    public List<Student> findStudentList(Date beginDate, Date endDate) {
        ArrayList<Student> studentList;
        block6: {
            String sql = "select s.*, c.classes_name from t_student s join t_classes c on s.classes_id=c.classes_id where s.birthday between ? and ? order by s.student_id ";
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            studentList = new ArrayList<Student>();
            try {
                try {
                    conn = DbUtil.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setDate(1, new java.sql.Date(beginDate.getTime()));
                    pstmt.setDate(2, new java.sql.Date(endDate.getTime()));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Student student = new Student();
                        student.setStudentId(rs.getInt("student_id"));
                        student.setStudentName(rs.getString("student_name"));
                        student.setSex(rs.getString("sex"));
                        student.setBirthday(rs.getDate("birthday"));
                        student.setContactTel(rs.getString("contact_tel"));
                        student.setAddress(rs.getString("address"));
                        Classes classes = new Classes();
                        classes.setClassesName(rs.getString("classes_name"));
                        student.setClasses(classes);
                        studentList.add(student);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DbUtil.close(rs);
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
        return studentList;
    }
}

