package com.bjpowernode.exam.manager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.bjpowernode.exam.model.Classes;
import com.bjpowernode.exam.util.DbUtil;

/**
 * ༶
 * @author Administrator
 *
 */
public class ClassesManager {

	private static ClassesManager instance = new ClassesManager();
	
	private ClassesManager() {}
	
	public static ClassesManager getInstance() {
		return instance;
	}
	
	/**
	 * ༶б
	 */
	public void outClassesList() {
		Connection conn = null;
		try {
			conn = DbUtil.getConnection();
			outClassesList(conn, 0, 0);
		}catch(Exception e) {
			e.printStackTrace();
		}finally {
			DbUtil.close(conn);
		}
	}
	
	/**
	 * ݹȡ༶νṹ
	 * @param conn
	 * @param classesId
	 * @param level
	 * @throws SQLException 
	 */
	private void outClassesList(Connection conn, int classesId, int level) throws SQLException {
		String sql = "select * from t_classes where pid=?";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try {
			String s = "";
			for (int i=0; i<level; i++) {
				s+="  ";
			}
			pstmt = conn.prepareStatement(sql);
			pstmt.setInt(1, classesId);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				System.out.println(s + rs.getInt("classes_id") + "" + rs.getString("classes_name") + "" );
				//ǷҶ
				if (rs.getInt("leaf") == 0) {
					//ݹ
					outClassesList(conn, rs.getInt("classes_id"), level+1);
				}
			}
		}finally {
			DbUtil.close(rs);
			DbUtil.close(pstmt);
			//ҪرConnection
			//ԴѭĴ򿪣Ĺرյԭ
			//DbUtil.close(conn);
		}
	}
	
	/**
	 * Ӱ༶
	 * @param pid id
	 * @param classesName ༶
	 */
	public void addClasses(int pid, String classesName) {
		String sql = "insert into t_classes(pid, classes_name) values(?, ?)";
		Connection conn = null;
		PreparedStatement pstmt = null;
		try {
			conn = DbUtil.getConnection();
			
			//Զύֶ
			DbUtil.setAutoCommit(conn, false);
			pstmt = conn.prepareStatement(sql);
			pstmt.setInt(1, pid);
			pstmt.setString(2, classesName);
			pstmt.executeUpdate();
			
			//ȡõǰڵĸڵ
			Classes parentClasses = findClassesById(pid);
			
			//ΪҶ
			if (parentClasses.getLeaf() == 1) {
				//޸ΪҶ
				modifyLeaf(conn, parentClasses.getClassesId(), 0);	
			}
			//ύ
			DbUtil.commit(conn);
		}catch(Exception e) {
			e.printStackTrace();
			//ع
			DbUtil.rollback(conn);
		}finally {
			DbUtil.close(pstmt);
			//ָӵ״̬ΪԶύ
			DbUtil.setAutoCommit(conn, true);
			DbUtil.close(conn);
		}
	}
	
	/**
	 * ޸leafֶ
	 * @param conn
	 * @param classesId
	 * @param leaf 1/0
	 */
	private void modifyLeaf(Connection conn, int classesId, int leaf) //{
	throws SQLException {
		String sql = "update t_classes set leaf=? where classes_id=?";
		PreparedStatement pstmt = null;
		try {
			pstmt = conn.prepareStatement(sql);
			pstmt.setInt(1, leaf);
			pstmt.setInt(2, classesId);
			pstmt.executeUpdate();
		//}catch(SQLException e) { //д޷عΪ쳣Եˣϱߵķ֪˴
		//	e.printStackTrace();
		}finally {
			DbUtil.close(pstmt);
		}
	}
	
	/**
	 * idѯ༶
	 * @param classesId
	 * @return ڷClasses󣬷򷵻null
	 */
	public Classes findClassesById(int classesId) {
		String sql = "select * from t_classes where classes_id=?";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Classes classes = null;
		try {
			conn = DbUtil.getConnection();
			pstmt = conn.prepareStatement(sql);	
			pstmt.setInt(1, classesId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				classes = new Classes();
				classes.setClassesId(classesId);
				classes.setClassesName(rs.getString("classes_name"));
				classes.setPid(rs.getInt("pid"));
				classes.setLeaf(rs.getInt("leaf"));
			}
		}catch(Exception e) {
			e.printStackTrace();
		}finally {
			DbUtil.close(rs);
			DbUtil.close(pstmt);
			DbUtil.close(conn);
		}
		return classes;
	}
	
	/**
	 * ޸İ༶
	 * @param classesId
	 * @param classesName
	 */
	public void modifyClasses(int classesId, String classesName) {
		String sql = "update t_classes set classes_name=? where classes_id=?";
		Connection conn = null;
		PreparedStatement pstmt = null;
		try {
			conn = DbUtil.getConnection();
			pstmt = conn.prepareStatement(sql);	
			pstmt.setString(1, classesName);
			pstmt.setInt(2, classesId);
			pstmt.executeUpdate();
		}catch(Exception e) {
			e.printStackTrace();
		}finally {
			DbUtil.close(pstmt);
			DbUtil.close(conn);
		}
		
	}
	
	/**
	 * ݰ༶ɾ༶
	 * @param classesId
	 */
	public void delClasses(int classesId) {
		// TODO ɾ༶
	}
	
	public static void main(String[] args) {
		ClassesManager.getInstance().outClassesList();
	}
}
