package com.bjpowernode.exam.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import com.bjpowernode.exam.manager.CourseManager;
import com.bjpowernode.exam.manager.GradeManager;
import com.bjpowernode.exam.model.Course;
import com.bjpowernode.exam.model.Grade;
import com.bjpowernode.exam.util.ExamConfigReader;

/**
 * ɼ
 * 
 * @author Administrator
 * 
 */
public class GradeController {

	private static final String ADD = "1";

	private static final String DEL = "2";

	private static final String MODIFY = "3";

	private static final String QUERY_STUDENT_ID = "4";

	private static final String QUERY = "7";

	private static final String QUIT = "q";

	private static String state = "";

	private static GradeManager gradeManager;

	static {
		String className = ExamConfigReader.getInstance().getPropertyValue(
				"grade-manager-impl");
		try {
			Class c = Class.forName(className);
			gradeManager = (GradeManager) c.newInstance();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
		System.out.println("1-ӳɼ");
		System.out.println("2-ɾɼ");
		System.out.println("3-޸ĳɼ");
		System.out.println("4-ѧѯɼ");
		System.out.println("5-ѯÿ߷");
		System.out.println("6-ѯܷǰ");
		System.out.println("7-ҳѯ");
		System.out.println("q-˳");
		BufferedReader br = null;
		try {
			br = new BufferedReader(new InputStreamReader(System.in));
			String s = null;
			while ((s = br.readLine()) != null) {
				if (ADD.equals(s)) {
					System.out
							.println("ӵĳɼ(student_id=#,course_id=#,grade=#):");
					state = ADD;
				} else if (DEL.equals(s)) {
					System.out
							.println("ɾѧͿγ̴(student_id=#,course_id=#):");
					state = DEL;
				} else if (MODIFY.equals(s)) {
					System.out
							.println("޸ĵĳɼ(student_id=#,course_id=#,grade=#):");
					state = MODIFY;
				} else if (QUERY_STUDENT_ID.equals(s)) {
					System.out.println("ѧѯɼ(student_id=#):");
					state = QUERY_STUDENT_ID;
				} else if (QUERY.equals(s)) {
					System.out.println("ҳѯѧɼ(pageNo=#,pageSize=#):");
					state = QUERY;
				} else if (QUIT.equalsIgnoreCase(s)) {
					break;
				} else if (ADD.equals(state)) {
					addGrade(s);
				} else if (DEL.equals(state)) {
					delGrade(s);
				} else if (MODIFY.equals(state)) {
					modifyGrade(s);
				} else if (QUERY_STUDENT_ID.equals(state)) {
					findGradeByStudentById(s);
				} else if (QUERY.equals(state)) {
					findGradeList(s);
				}
			}
			System.err.println("˳");
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (br != null) {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	private static void addGrade(String s) {
		// int studentId = 0;
		// int courseId = 0;
		// float grade = 0f;
		// //student_id=#,course_id=#,grade=#
		// StringTokenizer st1 = new StringTokenizer(s, ",");
		// while (st1.hasMoreTokens()) {
		// //student_id=#
		// String t1 = st1.nextToken();
		// StringTokenizer st2 = new StringTokenizer(t1, "=");
		// if(st2.hasMoreTokens()) {
		// String leftStr = st2.nextToken();
		// if ("student_id".equals(leftStr)) {
		// if (st2.hasMoreTokens()) {
		// studentId = Integer.parseInt(st2.nextToken());
		// }
		// }else if ("course_id".equals(leftStr)) {
		// if (st2.hasMoreTokens()) {
		// courseId = Integer.parseInt(st2.nextToken());
		// }
		// }else if ("grade".equals(leftStr)) {
		// if (st2.hasMoreTokens()) {
		// grade = Float.parseFloat(st2.nextToken());
		// }
		// }
		// }
		// }
		// System.out.println(studentId + ", " + courseId + ", " + grade);
		Map paramMap = parseParam(s);
		int studentId = (Integer) paramMap.get("student_id");
		int courseId = (Integer) paramMap.get("course_id");
		float grade = (Float) paramMap.get("grade");
		gradeManager.addGrade(studentId, courseId, grade);
		System.out.println("ӳɼɹ");
	}

	private static void modifyGrade(String s) {
		Map paramMap = parseParam(s);
		int studentId = (Integer) paramMap.get("student_id");
		int courseId = (Integer) paramMap.get("course_id");
		float grade = (Float) paramMap.get("grade");
		gradeManager.modifyGrade(studentId, courseId, grade);
		System.out.println("޸ĳɼɹ");
	}

	private static void delGrade(String s) {
		Map paramMap = parseParam(s);
		int studentId = (Integer) paramMap.get("student_id");
		int courseId = (Integer) paramMap.get("course_id");
		gradeManager.delGrade(studentId, courseId);
		System.out.println("ɾɼɹ");
	}

	private static void findGradeByStudentById(String s) {
		Map paramMap = parseParam(s);
		int studentId = (Integer) paramMap.get("student_id");
		List gradeList = gradeManager.findGradeList(studentId);
		printGradeList(gradeList);
	}

	private static void printGradeList(List gradeList) {
		for (Iterator iter = gradeList.iterator(); iter.hasNext();) {
			Grade grade = (Grade) iter.next();
			System.out.print("ѧ:" + grade.getStudent().getStudentId());
			System.out.print(" ѧ:" + grade.getStudent().getStudentName());
			System.out.print(" ༶:"
					+ grade.getStudent().getClasses().getClassesName());
			System.out.print(" γ:" + grade.getCourse().getCourseName());
			System.out.println(" ɼ:"
					+ new DecimalFormat("####.00").format(grade.getGrade()));
		}
	}

	private static void findGradeList(String s) {
		Map paramMap = parseParam(s);
		int pageNo = (Integer)paramMap.get("pageNo");
		int pageSize = (Integer)paramMap.get("pageSize");
		List gradeList = gradeManager.findGradeList(pageNo, pageSize);
		printGradeList(gradeList);
	}

	private static Map parseParam(String s) {
		Map paramMap = new HashMap();
		// student_id=#,course_id=#,grade=#
		StringTokenizer st1 = new StringTokenizer(s, ",");
		while (st1.hasMoreTokens()) {
			// student_id=#
			String t1 = st1.nextToken();
			StringTokenizer st2 = new StringTokenizer(t1, "=");
			if (st2.hasMoreTokens()) {
				String leftStr = st2.nextToken();
				if ("student_id".equals(leftStr)) {
					if (st2.hasMoreTokens()) {
						paramMap.put("student_id", Integer.parseInt(st2
								.nextToken()));
					}
				} else if ("course_id".equals(leftStr)) {
					if (st2.hasMoreTokens()) {
						paramMap.put("course_id", Integer.parseInt(st2
								.nextToken()));
					}
				} else if ("grade".equals(leftStr)) {
					if (st2.hasMoreTokens()) {
						paramMap
								.put("grade", Float.parseFloat(st2.nextToken()));
					}
				} else if ("pageNo".equals(leftStr)) {
					if (st2.hasMoreTokens()) {
						paramMap.put("pageNo", Integer
								.parseInt(st2.nextToken()));
					}
				} else if ("pageSize".equals(leftStr)) {
					if (st2.hasMoreTokens()) {
						paramMap.put("pageSize", Integer.parseInt(st2
								.nextToken()));
					}
				}
			}
		}
		// return studentId + "," + courseId + "," + grade
		return paramMap;
	}
}
