#define _CRT_SECURE_NO_WARNINGS

#ifdef UNICODE
#undef UNICODE
#endif
#ifdef _UNICODE
#undef _UNICODE
#endif

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <tlhelp32.h>

#define MAX_CODE_LENGTH_OF_LINE 1024

typedef struct {
	DWORD Address;
	DWORD ReferenceLevel;
	char  SSGCode[MAX_CODE_LENGTH_OF_LINE];
	char  Name[48];
} LIST_INFO;

typedef struct {
	union {
		char  String[16];
		DWORD Address;
	};
	DWORD Length;
} TENCO_STRING;

HANDLE    hHeap;
HANDLE    hProcess;
LIST_INFO *Array = NULL;
DWORD     ArrayCount = 0;
DWORD     RelativeNameAddress = 0;

BOOL ParseDwordArgument(IN const char *p, OUT DWORD *num)
{
	if (*p == '\0')
	{
		return FALSE;
	}
	*num = 0;
	if (*p == '0' && (*(p + 1) == 'x' || *(p + 1) == 'X'))
	{
		p += 2;
		do
		{
			*num *= 0x10;
			if (*p >= '0' && *p <= '9')
			{
				*num += *p - '0';
			}
			else if (*p >= 'A' && *p <= 'F')
			{
				*num += *p - 'A' + 0x0A;
			}
			else if (*p >= 'a' && *p <= 'f')
			{
				*num += *p - 'a' + 0x0A;
			}
			else
			{
				return FALSE;
			}
		} while (*(++p) != '\0');
	}
	else
	{
		do
		{
			*num *= 10;
			if (*p >= '0' && *p <= '9')
			{
				*num += *p - '0';
			}
			else
			{
				return FALSE;
			}
		} while (*(++p) != '\0');
	}
	return TRUE;
}

BOOL ParseBooleanArgument(IN const char *p, OUT BOOL *flag)
{
	if (*p == '\0')
	{
		return FALSE;
	}
	if (_stricmp(p, "TRUE") == 0)
	{
		*flag = TRUE;
	}
	else if (_stricmp(p, "FALSE") == 0)
	{
		*flag = FALSE;
	}
	else
	{
		return ParseDwordArgument(p, (DWORD *)flag);
	}
	return TRUE;
}

DWORD FindProccess(IN LPCSTR lpExeFile)
{
	DWORD  dwProcessId;
	HANDLE hSnapProcess;

	dwProcessId = 0;
	hSnapProcess = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
	if (hSnapProcess != INVALID_HANDLE_VALUE)
	{
		PROCESSENTRY32 pe;

		pe.dwSize = sizeof(pe);
		if (Process32First(hSnapProcess, &pe) != FALSE)
		{
			do
			{
				if (pe.th32ProcessID != 0 && _stricmp(pe.szExeFile, lpExeFile) == 0)
				{
					dwProcessId = pe.th32ProcessID;
					break;
				}
			} while (Process32Next(hSnapProcess, &pe) != FALSE);
		}
		CloseHandle(hSnapProcess);
	}
	return dwProcessId;
}

DWORD FindAddressFromArray(IN DWORD Address)
{
	DWORD Index;

	for (Index = 0; Index < ArrayCount; Index++)
	{
		if (Address == Array[Index].Address)
		{
			return Index;
		}
	}
	return 0xFFFFFFFF;
}

BOOL IsPrintString(IN const char *p)
{
	do
	{
		if ((unsigned char)*p >= 0x20 && (unsigned char)*p <= 0x7E)
		{
			continue;
		}
		if (((unsigned char)*p >= 0x81 && (unsigned char)*p <= 0x9F) || ((unsigned char)*p >= 0xE0 && (unsigned char)*p <= 0xFC))
		{
			p++;
			if (((unsigned char)*p >= 0x40 && (unsigned char)*p <= 0x7E) || ((unsigned char)*p >= 0x80 && (unsigned char)*p <= 0xFC))
			{
				continue;
			}
		}
		return FALSE;
	} while (*(++p) != '\0');
	return TRUE;
}

void EnumAddress(IN DWORD Address, IN const char *SSGCode, IN DWORD ReferenceLevel)
{
	DWORD Header[3];
	char  CodeBuffer[1024];
	DWORD Index;

	if (Address == 0)
	{
		return;
	}
	Index = FindAddressFromArray(Address);
	do
	{
		TENCO_STRING Name;

		if (Index != 0xFFFFFFFF)
		{
			if (Array[Index].ReferenceLevel < ReferenceLevel || strlen(Array[Index].SSGCode) <= strlen(SSGCode))
			{
				return;
			}
			strcpy(Array[Index].SSGCode, SSGCode);
			break;
		}
		if (Array == NULL)
		{
			Array = (LIST_INFO *)HeapAlloc(hHeap, 0, sizeof(LIST_INFO));
			if (Array == NULL)
			{
				return;
			}
		}
		else
		{
			LPVOID MemBlock;

			MemBlock = HeapReAlloc(hHeap, 0, Array, (ArrayCount + 1) * sizeof(LIST_INFO));
			if (MemBlock == NULL)
			{
				return;
			}
			Array = (LIST_INFO *)MemBlock;
		}
		Array[ArrayCount].Address = Address;
		strcpy(Array[ArrayCount].SSGCode, SSGCode);
		*Array[ArrayCount].Name = '\0';
		Array[ArrayCount].ReferenceLevel = ReferenceLevel;
		if (ReadProcessMemory(hProcess, (LPCVOID)(Address + RelativeNameAddress), (LPVOID)&Name, sizeof(Name), NULL) != FALSE
		 && Name.Length != 0 && Name.Length < 48 && (Name.Length >= 16  || * Name.String != '\0'))
		{
			if (Name.Length < 16)
			{
				strncpy(Array[ArrayCount].Name, Name.String, 16);
			}
			else
			{
				ReadProcessMemory(hProcess, (LPCVOID)Name.Address, Array[ArrayCount].Name, 48, NULL);
			}
			if (IsPrintString(Array[ArrayCount].Name) == FALSE)
			{
				*Array[ArrayCount].Name = '\0';
			}
		}
		ArrayCount++;
	} while (0);
	if (ReadProcessMemory(hProcess, (LPCVOID)Address, Header, sizeof(Header), NULL) == FALSE)
	{
		return;
	}
	_snprintf(CodeBuffer, _countof(CodeBuffer), "[:%s:]", SSGCode);
	EnumAddress(Header[0], CodeBuffer, ReferenceLevel + 1);
	_snprintf(CodeBuffer, _countof(CodeBuffer), "[:%s+4:]", SSGCode);
	EnumAddress(Header[1], CodeBuffer, ReferenceLevel + 1);
	_snprintf(CodeBuffer, _countof(CodeBuffer), "[:%s+8:]", SSGCode);
	EnumAddress(Header[2], CodeBuffer, ReferenceLevel + 1);
}

DWORD __cdecl CompareArrayByName(IN LIST_INFO *elem1, IN LIST_INFO *elem2)
{
	return strcmp(elem1->Name, elem2->Name);
}

void OutputAddressList()
{
	DWORD Index;

	for (Index = 1; Index < ArrayCount; Index++)
	{
		if (*Array[Index].Name == '\0')
		{
			continue;
		}
		printf("%8.8X ", Array[Index].Address);
		printf(Array[Index].Name);
		printf("\n");
	}
}

void OutputGroup(IN const char *SSLName, IN const char *GroupName)
{
	DWORD Index;

	printf("\n");
	printf("[group]%s\n", GroupName);
	for (Index = 1; Index < ArrayCount; Index++)
	{
		if (*Array[Index].Name == '\0')
		{
			continue;
		}
		printf(" // ");
		printf(Array[Index].Name);
		printf("\n [replace]_");
		printf(Array[Index].SSGCode);
		printf(strlen(Array[Index].Name) < 0x10 ? ",%s->SHORTNAME_%s\n" : ",%s->LONGNAME_%s\n", SSLName, GroupName);
	}
	printf("[/group]\n");
}

void OutputShortNameGroup(IN const char *GroupName)
{
	DWORD  Index1, Index2;
	size_t Length;

	printf("\n");
	printf("[group]SHORTNAME_%s_A\n", GroupName);
	printf("()\n");
	for (Index1 = 1; Index1 < ArrayCount; Index1++)
	{
		Length = strlen(Array[Index1].Name);
		if (Length == 0 || Length >= 16)
		{
			continue;
		}
		printf(Array[Index1].Name);
		printf("\n");
	}
	printf("[/group]\n");
	printf("\n");
	printf("[group]SHORTNAME_%s_B\n", GroupName);
	printf(",=00??????????????????????????????00\n");
	for (Index1 = 1; Index1 < ArrayCount; Index1++)
	{
		Length = strlen(Array[Index1].Name);
		if (Length == 0 || Length >= 16)
		{
			continue;
		}
		printf(",=");
		for (Index2 = 0; Index2 < 16; Index2++)
		{
			printf("%2.2X", (unsigned char)Array[Index1].Name[Index2]);
			if (Array[Index1].Name[Index2] == '\0')
			{
				Index2++;
				break;
			}
		}
		for (; Index2 < 16; Index2++)
		{
			printf("??");
		}
		printf("%2.2X\n", Length);
	}
	printf("[/group]\n");
}

void OutputLongNameGroup(IN const char *GroupName)
{
	DWORD  Index1, Index2;
	size_t Length;

	printf("\n");
	printf("[group]LONGNAME_%s_A\n", GroupName);
	for (Index1 = 1; Index1 < ArrayCount; Index1++)
	{
		Length = strlen(Array[Index1].Name);
		if (Length < 16)
		{
			continue;
		}
		printf("[0x%2.2X]%s", Length, Array[Index1].Name);
		printf("\n");
	}
	printf("[/group]\n");
	printf("\n");
	printf("[group]LONGNAME_%s_B\n", GroupName);
	for (Index1 = 1; Index1 < ArrayCount; Index1++)
	{
		Length = strlen(Array[Index1].Name);
		if (Length < 16)
		{
			continue;
		}
		printf(",=");
		for (Index2 = 0; Index2 < 48; Index2++)
		{
			printf("%2.2X", (unsigned char)Array[Index1].Name[Index2]);
			if (Array[Index1].Name[Index2] == '\0')
			{
				Index2++;
				break;
			}
		}
		printf("\n");
	}
	printf("[/group]\n");
}

int __cdecl main(int argc, char **argv, char **envp)
{
	DWORD      dwProcessId;
	BOOL       IsPointer;
	DWORD      Address;
	const char *ProccessExeFile;
	const char *SSLName;
	const char *IsPointerParameter;
	const char *AddressParameter;
	const char *RelativeNameAddressParameter;
	const char *GroupName;

	if (argc < 7)
	{
		return;
	}
	ProccessExeFile              = argv[1];
	SSLName                      = argv[2];
	IsPointerParameter           = argv[3];
	AddressParameter             = argv[4];
	RelativeNameAddressParameter = argv[5];
	GroupName                    = argv[6];
	if (ParseBooleanArgument(IsPointerParameter, &IsPointer) == FALSE)
	{
		return;
	}
	if (ParseDwordArgument(AddressParameter, &Address) == FALSE)
	{
		return;
	}
	if (ParseDwordArgument(RelativeNameAddressParameter, &RelativeNameAddress) == FALSE)
	{
		return;
	}
	if (RelativeNameAddress < 0x0C)
	{
		return;
	}
	dwProcessId = FindProccess(ProccessExeFile);
	if (dwProcessId == 0)
	{
		return;
	}
	hProcess = OpenProcess(PROCESS_VM_READ, FALSE, dwProcessId);
	if (hProcess == NULL)
	{
		return;
	}
	do
	{
		char SSGCode[MAX_CODE_LENGTH_OF_LINE];

		hHeap = GetProcessHeap();
		if (hHeap == NULL)
		{
			break;
		}
		if (IsPointer != FALSE)
		{
			_snprintf(SSGCode, _countof(SSGCode), "[:0x%X:]", Address);
			if (ReadProcessMemory(hProcess, (LPCVOID)Address, (LPVOID)&Address, sizeof(DWORD), NULL) == FALSE)
			{
				break;
			}
			EnumAddress(Address, SSGCode, 0);
		}
		else
		{
			DWORD Header[3];

			if (ReadProcessMemory(hProcess, (LPCVOID)Address, Header, sizeof(Header), NULL) != FALSE)
			{
				Array = (LIST_INFO *)HeapAlloc(hHeap, 0, sizeof(LIST_INFO));
				if (Array == NULL)
				{
					return;
				}
				Array->Address = Address;
				Array->ReferenceLevel = 0;
				*Array->SSGCode = '\0';
				*Array->Name = '\0';
				ArrayCount = 1;
				_snprintf(SSGCode, _countof(SSGCode), "[:0x%X:]", Address);
				EnumAddress(Header[0], SSGCode, 1);
				_snprintf(SSGCode, _countof(SSGCode), "[:0x%X+4:]", Address);
				EnumAddress(Header[1], SSGCode, 1);
				_snprintf(SSGCode, _countof(SSGCode), "[:0x%X+8:]", Address);
				EnumAddress(Header[2], SSGCode, 1);
			}
		}
		if (Array != NULL)
		{
			if (ArrayCount > 1)
			{
				qsort(Array + 1, ArrayCount - 1, sizeof(*Array), (int(__cdecl *)(const void *, const void *))CompareArrayByName);
				OutputAddressList();
				OutputGroup(SSLName, GroupName);
				OutputShortNameGroup(GroupName);
				OutputLongNameGroup(GroupName);
			}
			HeapFree(hHeap, 0, Array);
		}
	} while (0);
	CloseHandle(hProcess);
}
