# 说明
本文描述了从树莓派开箱到部署袋鼠网盘的全过程

**设备清单**

- 树莓派
- 树莓派电源
- TF 卡
- TF 卡读卡器
- USB HDMI 线
- 显示器
- 键盘

**环境说明**

烧写系统等步骤的操作平台为 windows, 只有在树莓派开机之后的几步才是把键盘和显示器连接到树莓派上直接操作的, 仅限于开启 ssh 服务和查看树莓派获取到的 IP. 接下来的其它操作也是切换回电脑操作的.


**硬件准备**

首先拆箱，淘宝买的无卡基础套装，包含了树莓派，盒子，HDMI 线，散热器和电源：

![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/open_box.jpg)

所有有用的装备基本都在这儿了:
![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/all_modules.jpg)

贴上散热片:
![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/pasted.jpg)

树莓派装进盒子:
![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/install_board.jpg)

把小风扇装到盒子的另一面之后, 连接风扇到树莓派的 GPIO 接口上, 连接方式如下:
![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/connect_fan.jpg)
风扇接在树莓派最外排的从右往左数第二和第三个针脚, 红色接第二根针脚, 黑色接第三根针脚.

**下载系统**

树莓派的系统直接选择官方的 Raspbian Buster Lite, 基于 debian, 不带图形化界面, 如果要用其它的系统也行, 反正安装方式基本一样.

可以去官网下载, 或者点击下面的链接下载:

[官网系统下载页面](https://www.raspberrypi.org/downloads/raspbian/)

[点击下载](https://downloads.raspberrypi.org/raspbian_lite_latest)


**下载烧录工具**

balenaEtcher 是图形化的烧写镜像工具, 可以直接上官网下载并安装:
https://www.balena.io/etcher/

下载 windows 版本, 然后直接安装.

**烧录系统到 TF 卡**

首先将 TF 卡连接到电脑, 然后打开上一步安装好的烧录工具, 也就是 etcher:
![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/open_etcher.png)

打开之后选择下载好的系统镜像, 也就是 Raspbian Buster Lite, 是个 zip 压缩包, 不要解压, 直接在 etcher 内选择即可.

![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/choose_img.png)

接下里选择设备, 请务必确保所选择的设备是刚刚连接电脑的 TF 卡, 因为烧录会格式化整个 TF 卡, 如果选择了其它外接设备的话, 会格式化外界设备.

![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/choose_tf_card.png)

确认所选的设备是否正确:
![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/confirm_tf_card.png)

点击 Flash 按钮开始烧录:
![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/flash.png)

正在烧录:
![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/flashing.png)

烧录完成后系统可能会检测到不兼容的 TF 卡, 会提示是否需要格式化, 这个时候千万不要选择格式化, 关掉弹出来的窗口就好了.

烧录完成之后会自动校验烧录结果是否完整:
![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/validate.png)


校验完成后, 如果没有问题会提示 Flash Complete, 下面显示一个红点 1 Failed device 是正常的, 因为烧录之后的 TF 卡, 分区格式是 linux 的分区格式, windows 系统无法识别的.
![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/flash_finish_all.png)

<br>

**树莓派开机**

TF 卡烧录完成之后, 插到树莓派的 TF 卡槽中,然后 HDMI 连接显示器, 再接上一个鼠标和一根网线, 网线连接的路由器设置为自动获取 IP.

上面这些线全部接好之后, 再接电源线, 电源连接到 type C 接口.

全部连接之后的状态:

![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/connect_all.jpg)

通电之后会自动开机, 开机之后可以看到显示器上有开机日志, 启动完成之后, 使用默认账号(pi/raspberry)登陆


**启动 ssh server**
为了通过电脑远程连接到树莓派, 需要登陆之后执行下面的命令, 启用 ssh server:

```
sudo systemctl enable ssh
sudo systemctl start ssh
sudo systemctl status ssh
```

![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/enable_sshd.png)

最后看到 ssh 服务状态为 Active 表示启用

**查看IP**

执行下面命令查看当前的 IP:
```
ifconfig eth0
```

![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/get_ip.png)

可以看到这里自动获取到的 IP 是 192.168.0.106


**远程连接树莓派**

上面启动了 ssh server 服务之后, 我们可以通过 xshell/putty 等工具来远程连接树莓派, 这样操作更方便一些.

下面以 xshell 为例, 在 windows 上通过 xshell 连接树莓派:

```
ssh pi@192.168.0.106
```

这里的 IP 就是上一步看到的树莓派的 eth0 接口上的 IP

![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/connect_pi.png)

<br>

**安装袋鼠网盘**

在树莓派上执行下面的命令即可安装袋鼠网盘:
```
cd /opt
sudo wget -O kstore_v1.3.0_linux_arm.tar.gz https://roostore.cn/api/version/download?zipFileName=kstore_v1.3.0_linux_arm.tar.gz
sudo tar zxvf kstore_v1.3.0_linux_arm.tar.gz
sudo mv kstore_v1.3.0_linux_arm kstore
cd kstore/
sudo chmod a+x kstore
sudo nohup ./kstore &
```

<br>

注意:

- 确保每一步执行成功之后再执行下一步
- 树莓派的这个系统是 arm 32 位的版本, 所以选择 对应的 arm 32 位的版本即可.

**访问袋鼠网盘**

在 windows 上打开浏览器, 然后访问 http://192.168.0.106:12048 接口访问树莓派上的袋鼠网盘服务.

![](docimgs/deploy_tutorial/deploy_on_raspberrypi_4B/access_kstore.png)