## 内容寻址

上传到 kstore 的文件是以内容寻址的方式统一管理，即以文件内容作为访问地址进行访问。这种方式可以有效地防止重复存储相同文件，以提高存储空间的利用率。

当文件上传完成后，kstore 会计算文件内容的哈希值：

```
hash(file) = sha1(sha1(chunk_data1) + sha1(chunk_data2) + ... + sha1(chunk_dataN))
```

由上面的计算方式可看出，文件的哈希值以计算各个数据块的哈希值后拼接起来再计算哈希值得出；而不是直接计算整个文件内容的哈希值。

选择这种计算方式的原因是为了在多个设备上同步文件时，在传输过程中可验证每个数据块的正确性。若中途传输某个数据块出错可以安排重传，避免在传输完整个文件后才发现最后的哈希值校验失败导致需要整个文件重传。

计算得到的文件哈希值用以重命名文件，用户可在存储目录（默认：`./var/upload`，可通过[后台设备管理更改](/admin_expansion)）查看设备已经存储的文件，所有文件都是以sha1值命名。文件的实际名称由元数据模块存储。

?> 目前，kstore 存储文件是以原文件的内容直接存储，后续提供选项由用户选择是否以加密的方式存储

## 数据隔离

由于袋鼠存储是一个分布式服务，有些用户因此担心自己部署运行了 kstore 后，是否也会存储了其他用户的数据，或者说其他用户是否也会备份了自己上传的数据！

我们非常注重用户的个人隐私，实际上：

!> 设备运行的 kstore 服务仅存储其**感兴趣的用户的数据**

这里所谓的**感兴趣的用户**是指在该设备中登录成功了的用户。因此可确保自己的设备不会出现其他用户的数据，在其他用户的设备上也不会出现自己的数据，达到用户数据隔离。

?> 具体地，用户可在存储目录（默认：`./var/upload`）查看设备已经存储的文件

?> 更多关于存储方面的内容，见[自主扩容](/admin_expansion)，[同步/备份](/admin_sync_backup)等章节