## 说明
kstore 支持安装为 linux 上的本地化服务, 以使用系统的服务管理功能来管理 kstore.

## 安装

linux 终端执行下面命令即可自动从官网下载并安装最新版本的 kstore(从两条中选择一条运行即可):
```
curl -s https://roostore.cn/api/version/download?zipFileName=auto_installer | sh

或:
wget -O - https://roostore.cn/api/version/download?zipFileName=auto_installer | sh
```

上面命令支持在 ubuntu，redhat，centos，deepin 等系统上运行

说明:

1. 所有的文件都安装在 `/opt/kstore` 目录（包括配置和数据）

2. 使用的配置文件在 /opt/kstore/conf 目录下(默认为空, 如需配置, 参考[配置](/configs))

3. 日志和用户产生的数据保存在 /opt/kstore/var 目录下

4. 安装后会自动启动 kstore, 并将 kstore 设置为自动开机启动

## 访问服务
安装完 kstore 服务端之后, 用户可以在浏览器上访问 `<IP>:12048` 来打开服务端的 web 界面(IP 为服务 linux 服务器的 IP).

例如服务器 IP 为 192.168.0.100, 则可以在浏览器访问 192.168.0.100:12048.

默认地，kstore 在 `:12048` 端口提供服务。如需要切换到其他端口，参考[配置](/configs)中的说明，修改 `HTTPPort` 配置项

另外，也支持 IPv6 的形式进行访问。例如，查询到部署设备的 IPv6 地址为 `fe80::fa8b:1f4e:3d6a:a04e`，那么在浏览器中就可以通过 [http://[fe80::fa8b:1f4e:3d6a:a04e]:12048/](http://[fe80::fa8b:1f4e:3d6a:a04e]:12048/) 访问

![](docimgs/login.png)

## 管理 kstore 服务
可以通过系统 service 命令启动，停止，重启 kstore 服务, 也可以设置为开机启动或取消开机启动.

### 启动 kstore 服务
```
service kstore start
```

### 停止 kstore 服务
```
service kstore stop
```

### 查看 kstore 服务状态
```
service kstore status
```

### 重启 kstore 服务
```
service kstore restart
```

### 取消开机启动
```
systemctl disable kstore
```

<br>
ubuntu 14.04(特殊情况, 上面的命令不适用):

```
rm /etc/init/kstore.conf
```


### 设置开机启动
```
systemctl enable kstore
```

<br>
ubuntu 14.04(特殊情况, 上面的命令不适用):

```
echo 'description "kstore - Kangaroo Store"

start on runlevel [2345]
stop on runlevel [!2345]

respawn
respawn limit 10 5

script
	exec /bin/sh -c "cd /opt/kstore && ./kstore"
end script
' > /etc/init/kstore.conf
```
!> 上面的命令一次性复制粘贴运行, 不要逐条复制运行