/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadersmod.client.IShaderPack;
import shadersmod.client.ShaderOption;
import shadersmod.client.ShaderOptionProfile;
import shadersmod.client.ShaderOptionRest;
import shadersmod.client.ShaderOptionScreen;
import shadersmod.client.ShaderOptionSwitch;
import shadersmod.client.ShaderOptionSwitchConst;
import shadersmod.client.ShaderOptionVariable;
import shadersmod.client.ShaderOptionVariableConst;
import shadersmod.client.ShaderProfile;
import shadersmod.client.ShaderUtils;
import shadersmod.client.Shaders;

public class ShaderPackParser {
    private static final Pattern PATTERN_INCLUDE = Pattern.compile("^\\s*#include\\s+\"([A-Za-z0-9_/\\.]+)\".*$");
    private static final Set<String> setConstNames = ShaderPackParser.makeSetConstNames();

    public static ShaderOption[] parseShaderPackOptions(IShaderPack shaderPack, String[] programNames, List<Integer> listDimensions) {
        if (shaderPack == null) {
            return new ShaderOption[0];
        }
        HashMap<String, ShaderOption> mapOptions = new HashMap<String, ShaderOption>();
        ShaderPackParser.collectShaderOptions(shaderPack, "/shaders", programNames, mapOptions);
        for (int dimId : listDimensions) {
            String dirWorld = "/shaders/world" + dimId;
            ShaderPackParser.collectShaderOptions(shaderPack, dirWorld, programNames, mapOptions);
        }
        Collection options = mapOptions.values();
        ShaderOption[] sos = options.toArray(new ShaderOption[options.size()]);
        Comparator<ShaderOption> comp = new Comparator<ShaderOption>(){

            @Override
            public int compare(ShaderOption o1, ShaderOption o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Arrays.sort(sos, comp);
        return sos;
    }

    private static void collectShaderOptions(IShaderPack shaderPack, String dir, String[] programNames, Map<String, ShaderOption> mapOptions) {
        for (int i = 0; i < programNames.length; ++i) {
            String programName = programNames[i];
            if (programName.equals("")) continue;
            String vsh = dir + "/" + programName + ".vsh";
            String fsh = dir + "/" + programName + ".fsh";
            ShaderPackParser.collectShaderOptions(shaderPack, vsh, mapOptions);
            ShaderPackParser.collectShaderOptions(shaderPack, fsh, mapOptions);
        }
    }

    private static void collectShaderOptions(IShaderPack sp, String path, Map<String, ShaderOption> mapOptions) {
        String[] lines = ShaderPackParser.getLines(sp, path);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            ShaderOption so2 = ShaderPackParser.getShaderOption(line, path);
            if (so2 == null || so2.checkUsed() && !ShaderPackParser.isOptionUsed(so2, lines)) continue;
            String key = so2.getName();
            ShaderOption so22 = mapOptions.get(key);
            if (so22 != null) {
                if (!Config.equals(so22.getValueDefault(), so2.getValueDefault())) {
                    Config.warn("Ambiguous shader option: " + so2.getName());
                    Config.warn(" - in " + Config.arrayToString(so22.getPaths()) + ": " + so22.getValueDefault());
                    Config.warn(" - in " + Config.arrayToString(so2.getPaths()) + ": " + so2.getValueDefault());
                    so22.setEnabled(false);
                }
                if (so22.getDescription() == null || so22.getDescription().length() <= 0) {
                    so22.setDescription(so2.getDescription());
                }
                so22.addPaths(so2.getPaths());
                continue;
            }
            mapOptions.put(key, so2);
        }
    }

    private static boolean isOptionUsed(ShaderOption so2, String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!so2.isUsedInLine(line)) continue;
            return true;
        }
        return false;
    }

    private static String[] getLines(IShaderPack sp, String path) {
        try {
            ArrayList<String> listFiles = new ArrayList<String>();
            String str = ShaderPackParser.loadFile(path, sp, 0, listFiles, 0);
            if (str == null) {
                return new String[0];
            }
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            String[] lines = Config.readLines(is);
            return lines;
        }
        catch (IOException e) {
            Config.dbg(e.getClass().getName() + ": " + e.getMessage());
            return new String[0];
        }
    }

    private static ShaderOption getShaderOption(String line, String path) {
        ShaderOption so2 = null;
        if (so2 == null) {
            so2 = ShaderOptionSwitch.parseOption(line, path);
        }
        if (so2 == null) {
            so2 = ShaderOptionVariable.parseOption(line, path);
        }
        if (so2 != null) {
            return so2;
        }
        if (so2 == null) {
            so2 = ShaderOptionSwitchConst.parseOption(line, path);
        }
        if (so2 == null) {
            so2 = ShaderOptionVariableConst.parseOption(line, path);
        }
        if (so2 != null && setConstNames.contains(so2.getName())) {
            return so2;
        }
        return null;
    }

    private static Set<String> makeSetConstNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("shadowMapResolution");
        set.add("shadowDistance");
        set.add("shadowIntervalSize");
        set.add("generateShadowMipmap");
        set.add("generateShadowColorMipmap");
        set.add("shadowHardwareFiltering");
        set.add("shadowHardwareFiltering0");
        set.add("shadowHardwareFiltering1");
        set.add("shadowtex0Mipmap");
        set.add("shadowtexMipmap");
        set.add("shadowtex1Mipmap");
        set.add("shadowcolor0Mipmap");
        set.add("shadowColor0Mipmap");
        set.add("shadowcolor1Mipmap");
        set.add("shadowColor1Mipmap");
        set.add("shadowtex0Nearest");
        set.add("shadowtexNearest");
        set.add("shadow0MinMagNearest");
        set.add("shadowtex1Nearest");
        set.add("shadow1MinMagNearest");
        set.add("shadowcolor0Nearest");
        set.add("shadowColor0Nearest");
        set.add("shadowColor0MinMagNearest");
        set.add("shadowcolor1Nearest");
        set.add("shadowColor1Nearest");
        set.add("shadowColor1MinMagNearest");
        set.add("wetnessHalflife");
        set.add("drynessHalflife");
        set.add("eyeBrightnessHalflife");
        set.add("centerDepthHalflife");
        set.add("sunPathRotation");
        set.add("ambientOcclusionLevel");
        set.add("superSamplingLevel");
        set.add("noiseTextureResolution");
        return set;
    }

    public static ShaderProfile[] parseProfiles(Properties props, ShaderOption[] shaderOptions) {
        String PREFIX_PROFILE = "profile.";
        ArrayList<ShaderProfile> list = new ArrayList<ShaderProfile>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(PREFIX_PROFILE)) continue;
            String name = string.substring(PREFIX_PROFILE.length());
            String val = props.getProperty(string);
            HashSet<String> parsedProfiles = new HashSet<String>();
            ShaderProfile p = ShaderPackParser.parseProfile(name, props, parsedProfiles, shaderOptions);
            if (p == null) continue;
            list.add(p);
        }
        if (list.size() <= 0) {
            return null;
        }
        ShaderProfile[] profs = list.toArray(new ShaderProfile[list.size()]);
        return profs;
    }

    private static ShaderProfile parseProfile(String name, Properties props, Set<String> parsedProfiles, ShaderOption[] shaderOptions) {
        String PREFIX_PROFILE = "profile.";
        String key = PREFIX_PROFILE + name;
        if (parsedProfiles.contains(key)) {
            Config.warn("[Shaders] Profile already parsed: " + name);
            return null;
        }
        parsedProfiles.add(name);
        ShaderProfile prof = new ShaderProfile(name);
        String val = props.getProperty(key);
        String[] parts = Config.tokenize(val, " ");
        for (int i = 0; i < parts.length; ++i) {
            String option;
            String part = parts[i];
            if (part.startsWith(PREFIX_PROFILE)) {
                String nameParent = part.substring(PREFIX_PROFILE.length());
                ShaderProfile profParent = ShaderPackParser.parseProfile(nameParent, props, parsedProfiles, shaderOptions);
                if (prof == null) continue;
                prof.addOptionValues(profParent);
                prof.addDisabledPrograms(profParent.getDisabledPrograms());
                continue;
            }
            String[] tokens = Config.tokenize(part, ":=");
            if (tokens.length == 1) {
                option = tokens[0];
                boolean on2 = true;
                if (option.startsWith("!")) {
                    on2 = false;
                    option = option.substring(1);
                }
                String PREFIX_PROGRAM = "program.";
                if (!on2 && option.startsWith("program.")) {
                    String program = option.substring(PREFIX_PROGRAM.length());
                    if (!Shaders.isProgramPath(program)) {
                        Config.warn("Invalid program: " + program + " in profile: " + prof.getName());
                        continue;
                    }
                    prof.addDisabledProgram(program);
                    continue;
                }
                ShaderOption so2 = ShaderUtils.getShaderOption(option, shaderOptions);
                if (!(so2 instanceof ShaderOptionSwitch)) {
                    Config.warn("[Shaders] Invalid option: " + option);
                    continue;
                }
                prof.addOptionValue(option, String.valueOf(on2));
                so2.setVisible(true);
                continue;
            }
            if (tokens.length != 2) {
                Config.warn("[Shaders] Invalid option value: " + part);
                continue;
            }
            option = tokens[0];
            String value = tokens[1];
            ShaderOption so3 = ShaderUtils.getShaderOption(option, shaderOptions);
            if (so3 == null) {
                Config.warn("[Shaders] Invalid option: " + part);
                continue;
            }
            if (!so3.isValidValue(value)) {
                Config.warn("[Shaders] Invalid value: " + part);
                continue;
            }
            so3.setVisible(true);
            prof.addOptionValue(option, value);
        }
        return prof;
    }

    public static Map<String, ShaderOption[]> parseGuiScreens(Properties props, ShaderProfile[] shaderProfiles, ShaderOption[] shaderOptions) {
        HashMap<String, ShaderOption[]> map = new HashMap<String, ShaderOption[]>();
        ShaderPackParser.parseGuiScreen("screen", props, map, shaderProfiles, shaderOptions);
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    private static boolean parseGuiScreen(String key, Properties props, Map<String, ShaderOption[]> map, ShaderProfile[] shaderProfiles, ShaderOption[] shaderOptions) {
        String val = props.getProperty(key);
        if (val == null) {
            return false;
        }
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        HashSet<String> setNames = new HashSet<String>();
        String[] opNames = Config.tokenize(val, " ");
        for (int i = 0; i < opNames.length; ++i) {
            String opName = opNames[i];
            if (opName.equals("<empty>")) {
                list.add(null);
                continue;
            }
            if (setNames.contains(opName)) {
                Config.warn("[Shaders] Duplicate option: " + opName + ", key: " + key);
                continue;
            }
            setNames.add(opName);
            if (opName.equals("<profile>")) {
                if (shaderProfiles == null) {
                    Config.warn("[Shaders] Option profile can not be used, no profiles defined: " + opName + ", key: " + key);
                    continue;
                }
                ShaderOptionProfile optionProfile = new ShaderOptionProfile(shaderProfiles, shaderOptions);
                list.add(optionProfile);
                continue;
            }
            if (opName.equals("*")) {
                ShaderOptionRest soRest = new ShaderOptionRest("<rest>");
                list.add(soRest);
                continue;
            }
            if (opName.startsWith("[") && opName.endsWith("]")) {
                String screen = StrUtils.removePrefixSuffix(opName, "[", "]");
                if (!screen.matches("^[a-zA-Z0-9_]+$")) {
                    Config.warn("[Shaders] Invalid screen: " + opName + ", key: " + key);
                    continue;
                }
                if (!ShaderPackParser.parseGuiScreen("screen." + screen, props, map, shaderProfiles, shaderOptions)) {
                    Config.warn("[Shaders] Invalid screen: " + opName + ", key: " + key);
                    continue;
                }
                ShaderOptionScreen optionScreen = new ShaderOptionScreen(screen);
                list.add(optionScreen);
                continue;
            }
            ShaderOption so2 = ShaderUtils.getShaderOption(opName, shaderOptions);
            if (so2 == null) {
                Config.warn("[Shaders] Invalid option: " + opName + ", key: " + key);
                list.add(null);
                continue;
            }
            so2.setVisible(true);
            list.add(so2);
        }
        ShaderOption[] scrOps = list.toArray(new ShaderOption[list.size()]);
        map.put(key, scrOps);
        return true;
    }

    public static BufferedReader resolveIncludes(BufferedReader reader, String filePath, IShaderPack shaderPack, int fileIndex, List<String> listFiles, int includeLevel) throws IOException {
        String line;
        String fileDir = "/";
        int pos = filePath.lastIndexOf("/");
        if (pos >= 0) {
            fileDir = filePath.substring(0, pos);
        }
        CharArrayWriter caw = new CharArrayWriter();
        int lineNumber = 1;
        while ((line = reader.readLine()) != null) {
            Matcher m2 = PATTERN_INCLUDE.matcher(line);
            if (m2.matches()) {
                int includeFileIndex;
                String filePathInc;
                String fileInc = m2.group(1);
                boolean absolute = fileInc.startsWith("/");
                String string = filePathInc = absolute ? "/shaders" + fileInc : fileDir + "/" + fileInc;
                if (!listFiles.contains(filePathInc)) {
                    listFiles.add(filePathInc);
                }
                if ((line = ShaderPackParser.loadFile(filePathInc, shaderPack, includeFileIndex = listFiles.indexOf(filePathInc) + 1, listFiles, includeLevel)) == null) {
                    throw new IOException("Included file not found: " + filePath);
                }
                if (line.endsWith("\n")) {
                    line = line.substring(0, line.length() - 1);
                }
                line = "#line 1 " + includeFileIndex + "\n" + line + "\n" + "#line " + (lineNumber + 1) + " " + fileIndex;
            }
            caw.write(line);
            caw.write("\n");
            ++lineNumber;
        }
        CharArrayReader car = new CharArrayReader(caw.toCharArray());
        return new BufferedReader(car);
    }

    private static String loadFile(String filePath, IShaderPack shaderPack, int fileIndex, List<String> listFiles, int includeLevel) throws IOException {
        String line;
        if (includeLevel >= 10) {
            throw new IOException("#include depth exceeded: " + includeLevel + ", file: " + filePath);
        }
        ++includeLevel;
        InputStream in = shaderPack.getResourceAsStream(filePath);
        if (in == null) {
            return null;
        }
        InputStreamReader isr = new InputStreamReader(in, "ASCII");
        BufferedReader br = new BufferedReader(isr);
        br = ShaderPackParser.resolveIncludes(br, filePath, shaderPack, fileIndex, listFiles, includeLevel);
        CharArrayWriter caw = new CharArrayWriter();
        while ((line = br.readLine()) != null) {
            caw.write(line);
            caw.write("\n");
        }
        return caw.toString();
    }
}

