/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import shadersmod.client.ShaderOption;
import shadersmod.client.ShaderProfile;

public class ShaderUtils {
    public static ShaderOption getShaderOption(String name, ShaderOption[] opts) {
        if (opts == null) {
            return null;
        }
        for (int i = 0; i < opts.length; ++i) {
            ShaderOption so2 = opts[i];
            if (!so2.getName().equals(name)) continue;
            return so2;
        }
        return null;
    }

    public static ShaderProfile detectProfile(ShaderProfile[] profs, ShaderOption[] opts, boolean def) {
        if (profs == null) {
            return null;
        }
        for (int i = 0; i < profs.length; ++i) {
            ShaderProfile prof = profs[i];
            if (!ShaderUtils.matchProfile(prof, opts, def)) continue;
            return prof;
        }
        return null;
    }

    public static boolean matchProfile(ShaderProfile prof, ShaderOption[] opts, boolean def) {
        if (prof == null) {
            return false;
        }
        if (opts == null) {
            return false;
        }
        String[] optsProf = prof.getOptions();
        for (int p = 0; p < optsProf.length; ++p) {
            String profVal;
            String optVal;
            String opt = optsProf[p];
            ShaderOption so2 = ShaderUtils.getShaderOption(opt, opts);
            if (so2 == null || Config.equals(optVal = def ? so2.getValueDefault() : so2.getValue(), profVal = prof.getValue(opt))) continue;
            return false;
        }
        return true;
    }
}

