/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import shadersmod.client.Shaders;
import shadersmod.client.ShadersRender;

public class CustomItems {
    private static CustomItemProperties[][] itemProperties = null;
    private static CustomItemProperties[][] enchantmentProperties = null;
    private static Map mapPotionIds = null;
    private static cmr itemModelGenerator = new cmr();
    private static boolean useGlint = true;
    public static final int MASK_POTION_SPLASH = 16384;
    public static final int MASK_POTION_NAME = 63;
    public static final String KEY_TEXTURE_OVERLAY = "texture.potion_overlay";
    public static final String KEY_TEXTURE_SPLASH = "texture.potion_bottle_splash";
    public static final String KEY_TEXTURE_DRINKABLE = "texture.potion_bottle_drinkable";
    public static final String DEFAULT_TEXTURE_OVERLAY = "items/potion_overlay";
    public static final String DEFAULT_TEXTURE_SPLASH = "items/potion_bottle_splash";
    public static final String DEFAULT_TEXTURE_DRINKABLE = "items/potion_bottle_drinkable";
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int[][] EMPTY_INT2_ARRAY = new int[0][];

    public static void updateIcons(cua textureMap) {
        itemProperties = null;
        enchantmentProperties = null;
        useGlint = true;
        if (!Config.isCustomItems()) {
            return;
        }
        CustomItems.readCitProperties("mcpatcher/cit.properties");
        cvm[] rps = Config.getResourcePacks();
        for (int i = rps.length - 1; i >= 0; --i) {
            cvm rp = rps[i];
            CustomItems.updateIcons(textureMap, rp);
        }
        CustomItems.updateIcons(textureMap, (cvm)Config.getDefaultResourcePack());
        if (itemProperties.length <= 0) {
            itemProperties = null;
        }
        if (enchantmentProperties.length <= 0) {
            enchantmentProperties = null;
        }
    }

    private static void readCitProperties(String fileName) {
        try {
            oa loc = new oa(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            Config.dbg("CustomItems: Loading " + fileName);
            Properties props = new Properties();
            props.load(in);
            in.close();
            useGlint = Config.parseBoolean(props.getProperty("useGlint"), true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void updateIcons(cua textureMap, cvm rp) {
        CustomItemProperties[] cips;
        int i;
        Object[] names = ResUtils.collectFiles(rp, "mcpatcher/cit/", ".properties", null);
        Map mapAutoProperties = CustomItems.makeAutoImageProperties(rp);
        if (mapAutoProperties.size() > 0) {
            Set keySetAuto = mapAutoProperties.keySet();
            Object[] keysAuto = keySetAuto.toArray(new String[keySetAuto.size()]);
            names = (String[])Config.addObjectsToArray(names, keysAuto);
        }
        Arrays.sort(names);
        List itemList = CustomItems.makePropertyList(itemProperties);
        List enchantmentList = CustomItems.makePropertyList(enchantmentProperties);
        for (int i2 = 0; i2 < names.length; ++i2) {
            Object name = names[i2];
            Config.dbg("CustomItems: " + (String)name);
            try {
                CustomItemProperties cip = null;
                if (mapAutoProperties.containsKey(name)) {
                    cip = (CustomItemProperties)mapAutoProperties.get(name);
                }
                if (cip == null) {
                    oa locFile = new oa((String)name);
                    InputStream in = rp.a(locFile);
                    if (in == null) {
                        Config.warn("CustomItems file not found: " + (String)name);
                        continue;
                    }
                    Properties props = new Properties();
                    props.load(in);
                    cip = new CustomItemProperties(props, (String)name);
                }
                if (!cip.isValid((String)name)) continue;
                cip.updateIcons(textureMap);
                CustomItems.addToItemList(cip, itemList);
                CustomItems.addToEnchantmentList(cip, enchantmentList);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn("CustomItems file not found: " + (String)name);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        itemProperties = CustomItems.propertyListToArray(itemList);
        enchantmentProperties = CustomItems.propertyListToArray(enchantmentList);
        Comparator comp = CustomItems.getPropertiesComparator();
        for (i = 0; i < itemProperties.length; ++i) {
            cips = itemProperties[i];
            if (cips == null) continue;
            Arrays.sort(cips, comp);
        }
        for (i = 0; i < enchantmentProperties.length; ++i) {
            cips = enchantmentProperties[i];
            if (cips == null) continue;
            Arrays.sort(cips, comp);
        }
    }

    private static Comparator getPropertiesComparator() {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                CustomItemProperties cip1 = (CustomItemProperties)o1;
                CustomItemProperties cip2 = (CustomItemProperties)o2;
                if (cip1.layer != cip2.layer) {
                    return cip1.layer - cip2.layer;
                }
                if (cip1.weight != cip2.weight) {
                    return cip2.weight - cip1.weight;
                }
                if (!cip1.basePath.equals(cip2.basePath)) {
                    return cip1.basePath.compareTo(cip2.basePath);
                }
                return cip1.name.compareTo(cip2.name);
            }
        };
        return comp;
    }

    public static void updateModels() {
        if (itemProperties == null) {
            return;
        }
        for (int id = 0; id < itemProperties.length; ++id) {
            CustomItemProperties[] cips = itemProperties[id];
            if (cips == null) continue;
            for (int c = 0; c < cips.length; ++c) {
                CustomItemProperties cip = cips[c];
                if (cip == null || cip.type != 1) continue;
                cua textureMap = bsu.z().R();
                cip.updateModel(textureMap, itemModelGenerator);
            }
        }
    }

    private static Map makeAutoImageProperties(cvm rp) {
        HashMap map = new HashMap();
        map.putAll(CustomItems.makePotionImageProperties(rp, false));
        map.putAll(CustomItems.makePotionImageProperties(rp, true));
        return map;
    }

    private static Map makePotionImageProperties(cvm rp, boolean splash) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        String type = splash ? "splash/" : "normal/";
        String[] prefixes = new String[]{"mcpatcher/cit/potion/" + type, "mcpatcher/cit/Potion/" + type};
        String[] suffixes = new String[]{".png"};
        String[] names = ResUtils.collectFiles(rp, prefixes, suffixes);
        for (int i = 0; i < names.length; ++i) {
            String path;
            String name = path = names[i];
            Properties props = CustomItems.makePotionProperties(name = StrUtils.removePrefixSuffix(name, prefixes, suffixes), splash, path);
            if (props == null) continue;
            String pathProp = StrUtils.removeSuffix(path, suffixes) + ".properties";
            CustomItemProperties cip = new CustomItemProperties(props, pathProp);
            map.put(pathProp, cip);
        }
        return map;
    }

    private static Properties makePotionProperties(String name, boolean splash, String path) {
        if (StrUtils.endsWith(name, new String[]{"_n", "_s"})) {
            return null;
        }
        if (name.equals("empty") && !splash) {
            int itemId = alq.b((alq)amk.bA);
            Properties props = new Properties();
            props.put("type", "item");
            props.put("items", "" + itemId);
            return props;
        }
        int potionItemId = alq.b((alq)amk.bz);
        int[] damages = (int[])CustomItems.getMapPotionIds().get(name);
        if (damages == null) {
            Config.warn("Potion not found for image: " + path);
            return null;
        }
        StringBuffer bufDamage = new StringBuffer();
        for (int i = 0; i < damages.length; ++i) {
            int damage = damages[i];
            if (splash) {
                damage |= 0x4000;
            }
            if (i > 0) {
                bufDamage.append(" ");
            }
            bufDamage.append(damage);
        }
        int damageMask = 16447;
        Properties props = new Properties();
        props.put("type", "item");
        props.put("items", "" + potionItemId);
        props.put("damage", "" + bufDamage.toString());
        props.put("damageMask", "" + damageMask);
        if (splash) {
            props.put(KEY_TEXTURE_SPLASH, name);
        } else {
            props.put(KEY_TEXTURE_DRINKABLE, name);
        }
        return props;
    }

    private static Map getMapPotionIds() {
        if (mapPotionIds == null) {
            mapPotionIds = new LinkedHashMap();
            mapPotionIds.put("water", new int[]{0});
            mapPotionIds.put("awkward", new int[]{16});
            mapPotionIds.put("thick", new int[]{32});
            mapPotionIds.put("potent", new int[]{48});
            mapPotionIds.put("regeneration", CustomItems.getPotionIds(1));
            mapPotionIds.put("moveSpeed", CustomItems.getPotionIds(2));
            mapPotionIds.put("fireResistance", CustomItems.getPotionIds(3));
            mapPotionIds.put("poison", CustomItems.getPotionIds(4));
            mapPotionIds.put("heal", CustomItems.getPotionIds(5));
            mapPotionIds.put("nightVision", CustomItems.getPotionIds(6));
            mapPotionIds.put("clear", CustomItems.getPotionIds(7));
            mapPotionIds.put("bungling", CustomItems.getPotionIds(23));
            mapPotionIds.put("charming", CustomItems.getPotionIds(39));
            mapPotionIds.put("rank", CustomItems.getPotionIds(55));
            mapPotionIds.put("weakness", CustomItems.getPotionIds(8));
            mapPotionIds.put("damageBoost", CustomItems.getPotionIds(9));
            mapPotionIds.put("moveSlowdown", CustomItems.getPotionIds(10));
            mapPotionIds.put("diffuse", CustomItems.getPotionIds(11));
            mapPotionIds.put("smooth", CustomItems.getPotionIds(27));
            mapPotionIds.put("refined", CustomItems.getPotionIds(43));
            mapPotionIds.put("acrid", CustomItems.getPotionIds(59));
            mapPotionIds.put("harm", CustomItems.getPotionIds(12));
            mapPotionIds.put("waterBreathing", CustomItems.getPotionIds(13));
            mapPotionIds.put("invisibility", CustomItems.getPotionIds(14));
            mapPotionIds.put("thin", CustomItems.getPotionIds(15));
            mapPotionIds.put("debonair", CustomItems.getPotionIds(31));
            mapPotionIds.put("sparkling", CustomItems.getPotionIds(47));
            mapPotionIds.put("stinky", CustomItems.getPotionIds(63));
        }
        return mapPotionIds;
    }

    private static int[] getPotionIds(int baseId) {
        return new int[]{baseId, baseId + 16, baseId + 32, baseId + 48};
    }

    private static int getPotionNameDamage(String name) {
        String fullName = "potion." + name;
        wp[] effectPotions = wp.a;
        for (int i = 0; i < effectPotions.length; ++i) {
            String potionName;
            wp potion = effectPotions[i];
            if (potion == null || !fullName.equals(potionName = potion.a())) continue;
            return potion.d();
        }
        return -1;
    }

    private static List makePropertyList(CustomItemProperties[][] propsArr) {
        ArrayList<ArrayList<CustomItemProperties>> list = new ArrayList<ArrayList<CustomItemProperties>>();
        if (propsArr != null) {
            for (int i = 0; i < propsArr.length; ++i) {
                CustomItemProperties[] props = propsArr[i];
                ArrayList<CustomItemProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<CustomItemProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static CustomItemProperties[][] propertyListToArray(List list) {
        CustomItemProperties[][] propArr = new CustomItemProperties[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            CustomItemProperties[] subArr = subList.toArray(new CustomItemProperties[subList.size()]);
            Arrays.sort(subArr, new CustomItemsComparator());
            propArr[i] = subArr;
        }
        return propArr;
    }

    private static void addToItemList(CustomItemProperties cp, List itemList) {
        if (cp.items == null) {
            return;
        }
        for (int i = 0; i < cp.items.length; ++i) {
            int itemId = cp.items[i];
            if (itemId <= 0) {
                Config.warn("Invalid item ID: " + itemId);
                continue;
            }
            CustomItems.addToList(cp, itemList, itemId);
        }
    }

    private static void addToEnchantmentList(CustomItemProperties cp, List enchantmentList) {
        if (cp.type != 2) {
            return;
        }
        if (cp.enchantmentIds == null) {
            return;
        }
        for (int i = 0; i < 256; ++i) {
            int id = i;
            if (!cp.enchantmentIds.isInRange(id)) continue;
            CustomItems.addToList(cp, enchantmentList, id);
        }
    }

    private static void addToList(CustomItemProperties cp, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomItemProperties> subList = (ArrayList<CustomItemProperties>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomItemProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    public static cxe getCustomItemModel(amj itemStack, cxe model, cxl modelLocation) {
        if (model.c()) {
            return model;
        }
        if (itemProperties == null) {
            return model;
        }
        CustomItemProperties props = CustomItems.getCustomItemProperties(itemStack, 1);
        if (props == null) {
            return model;
        }
        return props.getModel(modelLocation);
    }

    public static boolean bindCustomArmorTexture(amj itemStack, int layer, String overlay) {
        if (itemProperties == null) {
            return false;
        }
        oa loc = CustomItems.getCustomArmorLocation(itemStack, layer, overlay);
        if (loc == null) {
            return false;
        }
        Config.getTextureManager().a(loc);
        return true;
    }

    private static oa getCustomArmorLocation(amj itemStack, int layer, String overlay) {
        CustomItemProperties props = CustomItems.getCustomItemProperties(itemStack, 3);
        if (props == null) {
            return null;
        }
        if (props.mapTextureLocations == null) {
            return null;
        }
        alq item = itemStack.b();
        if (!(item instanceof ajn)) {
            return null;
        }
        ajn itemArmor = (ajn)item;
        String material = itemArmor.w_().c();
        StringBuffer sb = new StringBuffer();
        sb.append("texture.");
        sb.append(material);
        sb.append("_layer_");
        sb.append(layer);
        if (overlay != null) {
            sb.append("_");
            sb.append(overlay);
        }
        String key = sb.toString();
        oa loc = (oa)props.mapTextureLocations.get(key);
        return loc;
    }

    private static CustomItemProperties getCustomItemProperties(amj itemStack, int type) {
        CustomItemProperties[] cips;
        if (itemProperties == null) {
            return null;
        }
        if (itemStack == null) {
            return null;
        }
        alq item = itemStack.b();
        int itemId = alq.b((alq)item);
        if (itemId >= 0 && itemId < itemProperties.length && (cips = itemProperties[itemId]) != null) {
            for (int i = 0; i < cips.length; ++i) {
                CustomItemProperties cip = cips[i];
                if (cip.type != type || !CustomItems.matchesProperties(cip, itemStack, null)) continue;
                return cip;
            }
        }
        return null;
    }

    private static boolean matchesProperties(CustomItemProperties cip, amj itemStack, int[][] enchantmentIdLevels) {
        int i;
        alq item = itemStack.b();
        if (cip.damage != null) {
            int damage = itemStack.h();
            if (cip.damageMask != 0) {
                damage &= cip.damageMask;
            }
            if (cip.damagePercent) {
                int damageMax = item.l();
                damage = (int)((double)(damage * 100) / (double)damageMax);
            }
            if (!cip.damage.isInRange(damage)) {
                return false;
            }
        }
        if (cip.stackSize != null && !cip.stackSize.isInRange(itemStack.b)) {
            return false;
        }
        int[][] idLevels = enchantmentIdLevels;
        if (cip.enchantmentIds != null) {
            if (idLevels == null) {
                idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
            }
            boolean idMatch = false;
            for (i = 0; i < idLevels.length; ++i) {
                int id = idLevels[i][0];
                if (!cip.enchantmentIds.isInRange(id)) continue;
                idMatch = true;
                break;
            }
            if (!idMatch) {
                return false;
            }
        }
        if (cip.enchantmentLevels != null) {
            if (idLevels == null) {
                idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
            }
            boolean levelMatch = false;
            for (i = 0; i < idLevels.length; ++i) {
                int level = idLevels[i][1];
                if (!cip.enchantmentLevels.isInRange(level)) continue;
                levelMatch = true;
                break;
            }
            if (!levelMatch) {
                return false;
            }
        }
        if (cip.nbtTagValues != null) {
            fn nbt = itemStack.o();
            for (i = 0; i < cip.nbtTagValues.length; ++i) {
                NbtTagValue ntv = cip.nbtTagValues[i];
                if (ntv.matches(nbt)) continue;
                return false;
            }
        }
        return true;
    }

    private static int[][] getEnchantmentIdLevels(amj itemStack) {
        fv nbt;
        alq item = itemStack.b();
        fv fv2 = nbt = item == amk.cd ? amk.cd.h(itemStack) : itemStack.p();
        if (nbt == null || nbt.c() <= 0) {
            return EMPTY_INT2_ARRAY;
        }
        int[][] arr = new int[nbt.c()][2];
        for (int i = 0; i < nbt.c(); ++i) {
            fn tag = nbt.b(i);
            short id = tag.e("id");
            short lvl = tag.e("lvl");
            arr[i][0] = id;
            arr[i][1] = lvl;
        }
        return arr;
    }

    public static boolean renderCustomEffect(cqh renderItem, amj itemStack, cxe model) {
        if (enchantmentProperties == null) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
        if (idLevels.length <= 0) {
            return false;
        }
        HashSet<Integer> layersRendered = null;
        boolean rendered = false;
        cug textureManager = Config.getTextureManager();
        for (int i = 0; i < idLevels.length; ++i) {
            CustomItemProperties[] cips;
            int id = idLevels[i][0];
            if (id < 0 || id >= enchantmentProperties.length || (cips = enchantmentProperties[id]) == null) continue;
            for (int p = 0; p < cips.length; ++p) {
                CustomItemProperties cip = cips[p];
                if (layersRendered == null) {
                    layersRendered = new HashSet<Integer>();
                }
                if (!layersRendered.add(id) || !CustomItems.matchesProperties(cip, itemStack, idLevels) || cip.textureLocation == null) continue;
                textureManager.a(cip.textureLocation);
                float width = cip.getTextureWidth(textureManager);
                if (!rendered) {
                    rendered = true;
                    cjm.a((boolean)false);
                    cjm.c((int)514);
                    cjm.f();
                    cjm.n((int)5890);
                }
                Blender.setupBlend(cip.blend, 1.0f);
                cjm.E();
                cjm.a((float)(width / 2.0f), (float)(width / 2.0f), (float)(width / 2.0f));
                float offset = cip.speed * (float)(bsu.I() % 3000L) / 3000.0f / 8.0f;
                cjm.b((float)offset, (float)0.0f, (float)0.0f);
                cjm.b((float)cip.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
                renderItem.a(model, -1);
                cjm.F();
            }
        }
        if (rendered) {
            cjm.d();
            cjm.l();
            cjm.b((int)770, (int)771);
            cjm.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            cjm.n((int)5888);
            cjm.e();
            cjm.c((int)515);
            cjm.a((boolean)true);
            textureManager.a(cua.g);
        }
        return rendered;
    }

    public static boolean renderCustomArmorEffect(xm entity, amj itemStack, ccq model, float limbSwing, float prevLimbSwing, float partialTicks, float timeLimbSwing, float yaw, float pitch, float scale) {
        if (enchantmentProperties == null) {
            return false;
        }
        if (Config.isShaders() && Shaders.isShadowPass) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
        if (idLevels.length <= 0) {
            return false;
        }
        HashSet<Integer> layersRendered = null;
        boolean rendered = false;
        cug textureManager = Config.getTextureManager();
        for (int i = 0; i < idLevels.length; ++i) {
            CustomItemProperties[] cips;
            int id = idLevels[i][0];
            if (id < 0 || id >= enchantmentProperties.length || (cips = enchantmentProperties[id]) == null) continue;
            for (int p = 0; p < cips.length; ++p) {
                CustomItemProperties cip = cips[p];
                if (layersRendered == null) {
                    layersRendered = new HashSet<Integer>();
                }
                if (!layersRendered.add(id) || !CustomItems.matchesProperties(cip, itemStack, idLevels) || cip.textureLocation == null) continue;
                textureManager.a(cip.textureLocation);
                float width = cip.getTextureWidth(textureManager);
                if (!rendered) {
                    rendered = true;
                    if (Config.isShaders()) {
                        ShadersRender.layerArmorBaseDrawEnchantedGlintBegin();
                    }
                    cjm.l();
                    cjm.c((int)514);
                    cjm.a((boolean)false);
                }
                Blender.setupBlend(cip.blend, 1.0f);
                cjm.f();
                cjm.n((int)5890);
                cjm.D();
                cjm.b((float)cip.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
                float texScale = width / 8.0f;
                cjm.a((float)texScale, (float)(texScale / 2.0f), (float)texScale);
                float offset = cip.speed * (float)(bsu.I() % 3000L) / 3000.0f / 8.0f;
                cjm.b((float)0.0f, (float)offset, (float)0.0f);
                cjm.n((int)5888);
                model.a((wv)entity, limbSwing, prevLimbSwing, timeLimbSwing, yaw, pitch, scale);
            }
        }
        if (rendered) {
            cjm.d();
            cjm.l();
            cjm.b((int)770, (int)771);
            cjm.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            cjm.n((int)5890);
            cjm.D();
            cjm.n((int)5888);
            cjm.e();
            cjm.a((boolean)true);
            cjm.c((int)515);
            cjm.k();
            if (Config.isShaders()) {
                ShadersRender.layerArmorBaseDrawEnchantedGlintEnd();
            }
        }
        return rendered;
    }

    public static boolean isUseGlint() {
        return useGlint;
    }
}

