/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.Set;

public class DynamicLight {
    private wv entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private boolean underwater = false;
    private long timeCheckMs = 0L;
    private Set<dt> setLitChunkPos = new HashSet<dt>();
    private BlockPosM blockPosMutable = new BlockPosM(0, 0, 0);

    public DynamicLight(wv entity) {
        this.entity = entity;
        this.offsetY = entity.aR();
    }

    public void update(ckn renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.s - 0.5;
        double posY = this.entity.t - 0.5 + this.offsetY;
        double posZ = this.entity.u - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        this.underwater = false;
        cen world = renderGlobal.getWorld();
        if (world != null) {
            this.blockPosMutable.setXyz(uv.c((double)posX), uv.c((double)posY), uv.c((double)posZ));
            bec state = world.p((dt)this.blockPosMutable);
            atr block = state.c();
            this.underwater = block == aty.j;
        }
        HashSet<dt> setNewPos = new HashSet<dt>();
        if (lightLevel > 0) {
            ej dirX = (uv.c((double)posX) & 0xF) >= 8 ? ej.f : ej.e;
            ej dirY = (uv.c((double)posY) & 0xF) >= 8 ? ej.b : ej.a;
            ej dirZ = (uv.c((double)posZ) & 0xF) >= 8 ? ej.d : ej.c;
            dt pos = new dt(posX, posY, posZ);
            cop chunkView = renderGlobal.getRenderChunk(pos);
            cop chunkX = renderGlobal.getRenderChunk(chunkView, dirX);
            cop chunkZ = renderGlobal.getRenderChunk(chunkView, dirZ);
            cop chunkXZ = renderGlobal.getRenderChunk(chunkX, dirZ);
            cop chunkY = renderGlobal.getRenderChunk(chunkView, dirY);
            cop chunkYX = renderGlobal.getRenderChunk(chunkY, dirX);
            cop chunkYZ = renderGlobal.getRenderChunk(chunkY, dirZ);
            cop chunkYXZ = renderGlobal.getRenderChunk(chunkYX, dirZ);
            this.updateChunkLight(chunkView, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private void updateChunkLight(cop renderChunk, Set<dt> setPrevPos, Set<dt> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        cok compiledChunk = renderChunk.g();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(true);
        }
        dt pos = renderChunk.j();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(ckn renderGlobal) {
        for (dt posOld : this.setLitChunkPos) {
            cop chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public wv getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public boolean isUnderwater() {
        return this.underwater;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

