/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import shadersmod.client.MultiTexID;
import shadersmod.client.Shaders;

public class TextureUtils {
    public static final String texGrassTop = "grass_top";
    public static final String texStone = "stone";
    public static final String texDirt = "dirt";
    public static final String texCoarseDirt = "coarse_dirt";
    public static final String texGrassSide = "grass_side";
    public static final String texStoneslabSide = "stone_slab_side";
    public static final String texStoneslabTop = "stone_slab_top";
    public static final String texBedrock = "bedrock";
    public static final String texSand = "sand";
    public static final String texGravel = "gravel";
    public static final String texLogOak = "log_oak";
    public static final String texLogBigOak = "log_big_oak";
    public static final String texLogAcacia = "log_acacia";
    public static final String texLogSpruce = "log_spruce";
    public static final String texLogBirch = "log_birch";
    public static final String texLogJungle = "log_jungle";
    public static final String texLogOakTop = "log_oak_top";
    public static final String texLogBigOakTop = "log_big_oak_top";
    public static final String texLogAcaciaTop = "log_acacia_top";
    public static final String texLogSpruceTop = "log_spruce_top";
    public static final String texLogBirchTop = "log_birch_top";
    public static final String texLogJungleTop = "log_jungle_top";
    public static final String texLeavesOak = "leaves_oak";
    public static final String texLeavesBigOak = "leaves_big_oak";
    public static final String texLeavesAcacia = "leaves_acacia";
    public static final String texLeavesBirch = "leaves_birch";
    public static final String texLeavesSpuce = "leaves_spruce";
    public static final String texLeavesJungle = "leaves_jungle";
    public static final String texGoldOre = "gold_ore";
    public static final String texIronOre = "iron_ore";
    public static final String texCoalOre = "coal_ore";
    public static final String texObsidian = "obsidian";
    public static final String texGrassSideOverlay = "grass_side_overlay";
    public static final String texSnow = "snow";
    public static final String texGrassSideSnowed = "grass_side_snowed";
    public static final String texMyceliumSide = "mycelium_side";
    public static final String texMyceliumTop = "mycelium_top";
    public static final String texDiamondOre = "diamond_ore";
    public static final String texRedstoneOre = "redstone_ore";
    public static final String texLapisOre = "lapis_ore";
    public static final String texCactusSide = "cactus_side";
    public static final String texClay = "clay";
    public static final String texFarmlandWet = "farmland_wet";
    public static final String texFarmlandDry = "farmland_dry";
    public static final String texNetherrack = "netherrack";
    public static final String texSoulSand = "soul_sand";
    public static final String texGlowstone = "glowstone";
    public static final String texLeavesSpruce = "leaves_spruce";
    public static final String texLeavesSpruceOpaque = "leaves_spruce_opaque";
    public static final String texEndStone = "end_stone";
    public static final String texSandstoneTop = "sandstone_top";
    public static final String texSandstoneBottom = "sandstone_bottom";
    public static final String texRedstoneLampOff = "redstone_lamp_off";
    public static final String texRedstoneLampOn = "redstone_lamp_on";
    public static final String texWaterStill = "water_still";
    public static final String texWaterFlow = "water_flow";
    public static final String texLavaStill = "lava_still";
    public static final String texLavaFlow = "lava_flow";
    public static final String texFireLayer0 = "fire_layer_0";
    public static final String texFireLayer1 = "fire_layer_1";
    public static final String texPortal = "portal";
    public static final String texGlass = "glass";
    public static final String texGlassPaneTop = "glass_pane_top";
    public static final String texCompass = "compass";
    public static final String texClock = "clock";
    public static cue iconGrassTop;
    public static cue iconGrassSide;
    public static cue iconGrassSideOverlay;
    public static cue iconSnow;
    public static cue iconGrassSideSnowed;
    public static cue iconMyceliumSide;
    public static cue iconMyceliumTop;
    public static cue iconWaterStill;
    public static cue iconWaterFlow;
    public static cue iconLavaStill;
    public static cue iconLavaFlow;
    public static cue iconPortal;
    public static cue iconFireLayer0;
    public static cue iconFireLayer1;
    public static cue iconGlass;
    public static cue iconGlassPaneTop;
    public static cue iconCompass;
    public static cue iconClock;
    public static final String SPRITE_PREFIX_BLOCKS = "minecraft:blocks/";
    public static final String SPRITE_PREFIX_ITEMS = "minecraft:items/";
    private static IntBuffer staticBuffer;

    public static void update() {
        cua mapBlocks = TextureUtils.getTextureMapBlocks();
        if (mapBlocks == null) {
            return;
        }
        String prefix = SPRITE_PREFIX_BLOCKS;
        iconGrassTop = mapBlocks.getSpriteSafe(prefix + texGrassTop);
        iconGrassSide = mapBlocks.getSpriteSafe(prefix + texGrassSide);
        iconGrassSideOverlay = mapBlocks.getSpriteSafe(prefix + texGrassSideOverlay);
        iconSnow = mapBlocks.getSpriteSafe(prefix + texSnow);
        iconGrassSideSnowed = mapBlocks.getSpriteSafe(prefix + texGrassSideSnowed);
        iconMyceliumSide = mapBlocks.getSpriteSafe(prefix + texMyceliumSide);
        iconMyceliumTop = mapBlocks.getSpriteSafe(prefix + texMyceliumTop);
        iconWaterStill = mapBlocks.getSpriteSafe(prefix + texWaterStill);
        iconWaterFlow = mapBlocks.getSpriteSafe(prefix + texWaterFlow);
        iconLavaStill = mapBlocks.getSpriteSafe(prefix + texLavaStill);
        iconLavaFlow = mapBlocks.getSpriteSafe(prefix + texLavaFlow);
        iconFireLayer0 = mapBlocks.getSpriteSafe(prefix + texFireLayer0);
        iconFireLayer1 = mapBlocks.getSpriteSafe(prefix + texFireLayer1);
        iconPortal = mapBlocks.getSpriteSafe(prefix + texPortal);
        iconGlass = mapBlocks.getSpriteSafe(prefix + texGlass);
        iconGlassPaneTop = mapBlocks.getSpriteSafe(prefix + texGlassPaneTop);
        String prefixItems = SPRITE_PREFIX_ITEMS;
        iconCompass = mapBlocks.getSpriteSafe(prefixItems + texCompass);
        iconClock = mapBlocks.getSpriteSafe(prefixItems + texClock);
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi.getWidth()) == (height = bi.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi;
    }

    public static int ceilPowerOfTwo(int val) {
        int i;
        for (i = 1; i < val; i *= 2) {
        }
        return i;
    }

    public static int getPowerOfTwo(int val) {
        int i = 1;
        int po2 = 0;
        while (i < val) {
            i *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        for (int i = 0; i < power; ++i) {
            val *= 2;
        }
        return val;
    }

    public static cui getTexture(oa loc) {
        cui tex = Config.getTextureManager().b(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource(loc)) {
            return null;
        }
        tex = new ctv(loc);
        Config.getTextureManager().a(loc, tex);
        return tex;
    }

    public static void resourcesReloaded(cvk rm) {
        if (TextureUtils.getTextureMapBlocks() == null) {
            return;
        }
        Config.dbg("*** Reloading custom textures ***");
        CustomSky.reset();
        TextureAnimations.reset();
        TextureUtils.update();
        NaturalTextures.update();
        BetterGrass.update();
        BetterSnow.update();
        TextureAnimations.update();
        CustomColors.update();
        CustomSky.update();
        RandomMobs.resetTextures();
        CustomItems.updateModels();
        Shaders.resourcesReloaded();
        Lang.resourcesReloaded();
        Config.updateTexturePackClouds();
        SmartLeaves.updateLeavesModels();
        Config.getTextureManager().e();
    }

    public static cua getTextureMapBlocks() {
        return bsu.z().R();
    }

    public static void registerResourceListener() {
        cvk rm = Config.getResourceManager();
        if (rm instanceof cvi) {
            cvi rrm = (cvi)rm;
            cvl rl = new cvl(){

                public void a(cvk var1) {
                    TextureUtils.resourcesReloaded(var1);
                }
            };
            rrm.a(rl);
        }
        cul tto = new cul(){

            public void e() {
                TextureAnimations.updateCustomAnimations();
            }

            public void a(cvk var1) throws IOException {
            }

            public int b() {
                return 0;
            }

            public void b(boolean p_174936_1, boolean p_174936_2) {
            }

            public void a() {
            }

            public MultiTexID getMultiTexID() {
                return null;
            }
        };
        oa ttol = new oa("optifine/TickableTextures");
        Config.getTextureManager().a(ttol, tto);
    }

    public static String fixResourcePath(String path, String basePath) {
        String strAssMc = "assets/minecraft/";
        if (path.startsWith(strAssMc)) {
            path = path.substring(strAssMc.length());
            return path;
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            path = basePath + path;
            return path;
        }
        if (path.startsWith("/~")) {
            path = path.substring(1);
        }
        String strMcpatcher = "mcpatcher/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            path = strMcpatcher + path;
            return path;
        }
        if (path.startsWith("/")) {
            path = strMcpatcher + path.substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public static void applyAnisotropicLevel() {
        if (GLContext.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxLevel = GL11.glGetFloat((int)34047);
            float level = Config.getAnisotropicFilterLevel();
            level = Math.min(level, maxLevel);
            GL11.glTexParameterf((int)3553, (int)34046, (float)level);
        }
    }

    public static void bindTexture(int glTexId) {
        cjm.i((int)glTexId);
    }

    public static boolean isPowerOfTwo(int x) {
        int x2 = uv.b((int)x);
        return x2 == x;
    }

    public static BufferedImage scaleToPowerOfTwo(BufferedImage bi, int minSize) {
        if (bi == null) {
            return bi;
        }
        int w = bi.getWidth();
        int h = bi.getHeight();
        int w2 = Math.max(w, minSize);
        if ((w2 = uv.b((int)w2)) == w) {
            return bi;
        }
        int h2 = h * w2 / w;
        BufferedImage bi2 = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = bi2.createGraphics();
        Object method = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (w2 % w != 0) {
            method = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, method);
        g2.drawImage(bi, 0, 0, w2, h2, null);
        return bi2;
    }

    public static BufferedImage scaleMinTo(BufferedImage bi, int minSize) {
        int w2;
        if (bi == null) {
            return bi;
        }
        int w = bi.getWidth();
        int h = bi.getHeight();
        if (w >= minSize) {
            return bi;
        }
        for (w2 = w; w2 < minSize; w2 *= 2) {
        }
        int h2 = h * w2 / w;
        BufferedImage bi2 = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = bi2.createGraphics();
        Object method = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, method);
        g2.drawImage(bi, 0, 0, w2, h2, null);
        return bi2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(InputStream in, String suffix) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(suffix);
        while (iter.hasNext()) {
            ImageReader reader = iter.next();
            try {
                ImageInputStream iis = ImageIO.createImageInputStream(in);
                reader.setInput(iis);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Dimension dimension = new Dimension(width, height);
                return dimension;
            }
            catch (IOException e) {}
            continue;
            finally {
                reader.dispose();
            }
        }
        return null;
    }

    static {
        staticBuffer = bst.f((int)256);
    }
}

