/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConnectedTextures {
    private static Map[] spriteQuadMaps = null;
    private static ConnectedProperties[][] blockProperties = null;
    private static ConnectedProperties[][] tileProperties = null;
    private static boolean multipass = false;
    private static final int Y_NEG_DOWN = 0;
    private static final int Y_POS_UP = 1;
    private static final int Z_NEG_NORTH = 2;
    private static final int Z_POS_SOUTH = 3;
    private static final int X_NEG_WEST = 4;
    private static final int X_POS_EAST = 5;
    private static final int Y_AXIS = 0;
    private static final int Z_AXIS = 1;
    private static final int X_AXIS = 2;
    private static final String[] propSuffixes = new String[]{"", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final int[] ctmIndexes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0, 0, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0, 0, 0, 0, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 0, 0, 0, 0, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 0, 0, 0, 0, 0};
    public static final ars AIR_DEFAULT_STATE = akg.a.u();
    private static bwe emptySprite = null;

    public static synchronized boy getConnectedTexture(aih blockAccess, ars blockState, cm blockPos, boy quad, RenderEnv renderEnv) {
        bwe spriteIn = quad.a();
        if (spriteIn == null) {
            return quad;
        }
        akf block = blockState.t();
        if (ConnectedTextures.skipConnectedTexture(blockAccess, blockState, blockPos, quad, renderEnv)) {
            return ConnectedTextures.getQuad(emptySprite, block, blockState, quad);
        }
        ct side = quad.e();
        bwe sprite = ConnectedTextures.getConnectedTextureMultiPass(blockAccess, blockState, blockPos, side, spriteIn, renderEnv);
        if (sprite == spriteIn) {
            return quad;
        }
        return ConnectedTextures.getQuad(sprite, block, blockState, quad);
    }

    private static boolean skipConnectedTexture(aih blockAccess, ars blockState, cm blockPos, boy quad, RenderEnv renderEnv) {
        akf block = blockState.t();
        if (block instanceof aps) {
            ct face = quad.e();
            if (face != ct.b && face != ct.a) {
                return false;
            }
            cm posNeighbour = blockPos.a(quad.e());
            ars stateNeighbour = blockAccess.o(posNeighbour);
            if (stateNeighbour.t() != block) {
                return false;
            }
            if (block == akg.cH && stateNeighbour.c((asi)apg.a) != blockState.c((asi)apg.a)) {
                return false;
            }
            stateNeighbour = stateNeighbour.b(blockAccess, posNeighbour);
            double midX = quad.getMidX();
            if (midX < 0.4) {
                if (((Boolean)stateNeighbour.c((asi)aps.e)).booleanValue()) {
                    return true;
                }
            } else if (midX > 0.6) {
                if (((Boolean)stateNeighbour.c((asi)aps.c)).booleanValue()) {
                    return true;
                }
            } else {
                double midZ = quad.getMidZ();
                if (midZ < 0.4) {
                    if (((Boolean)stateNeighbour.c((asi)aps.b)).booleanValue()) {
                        return true;
                    }
                } else if (midZ > 0.6) {
                    if (((Boolean)stateNeighbour.c((asi)aps.d)).booleanValue()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    private static boy getQuad(bwe sprite, akf block, ars blockState, boy quadIn) {
        boy quad;
        if (spriteQuadMaps == null) {
            return quadIn;
        }
        int spriteIndex = sprite.getIndexInMap();
        if (spriteIndex < 0 || spriteIndex >= spriteQuadMaps.length) {
            return quadIn;
        }
        IdentityHashMap<boy, boy> quadMap = spriteQuadMaps[spriteIndex];
        if (quadMap == null) {
            ConnectedTextures.spriteQuadMaps[spriteIndex] = quadMap = new IdentityHashMap<boy, boy>(1);
        }
        if ((quad = (boy)quadMap.get(quadIn)) == null) {
            quad = ConnectedTextures.makeSpriteQuad(quadIn, sprite);
            quadMap.put(quadIn, quad);
        }
        return quad;
    }

    private static boy makeSpriteQuad(boy quad, bwe sprite) {
        int[] data = (int[])quad.b().clone();
        bwe spriteFrom = quad.a();
        for (int i = 0; i < 4; ++i) {
            ConnectedTextures.fixVertex(data, i, spriteFrom, sprite);
        }
        boy bq = new boy(data, quad.d(), quad.e(), sprite);
        return bq;
    }

    private static void fixVertex(int[] data, int vertex, bwe spriteFrom, bwe spriteTo) {
        int mul = data.length / 4;
        int pos = mul * vertex;
        float u = Float.intBitsToFloat(data[pos + 4]);
        float v = Float.intBitsToFloat(data[pos + 4 + 1]);
        double su16 = spriteFrom.getSpriteU16(u);
        double sv16 = spriteFrom.getSpriteV16(v);
        data[pos + 4] = Float.floatToRawIntBits(spriteTo.a(su16));
        data[pos + 4 + 1] = Float.floatToRawIntBits(spriteTo.b(sv16));
    }

    private static bwe getConnectedTextureMultiPass(aih blockAccess, ars blockState, cm blockPos, ct side, bwe icon, RenderEnv renderEnv) {
        bwe newMpIcon;
        bwe newIcon = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, icon, true, renderEnv);
        if (!multipass) {
            return newIcon;
        }
        if (newIcon == icon) {
            return newIcon;
        }
        bwe mpIcon = newIcon;
        for (int i = 0; i < 3 && (newMpIcon = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, mpIcon, false, renderEnv)) != mpIcon; ++i) {
            mpIcon = newMpIcon;
        }
        return mpIcon;
    }

    public static bwe getConnectedTextureSingle(aih blockAccess, ars blockState, cm blockPos, ct facing, bwe icon, boolean checkBlocks, RenderEnv renderEnv) {
        int blockId;
        bwe newIcon;
        ConnectedProperties cp;
        int i;
        int side;
        ConnectedProperties[] cps;
        int iconId;
        akf block = blockState.t();
        if (!(blockState instanceof arp)) {
            return icon;
        }
        arp blockStateBase = (arp)blockState;
        if (tileProperties != null && (iconId = icon.getIndexInMap()) >= 0 && iconId < tileProperties.length && (cps = tileProperties[iconId]) != null) {
            side = ConnectedTextures.getSide(facing);
            for (i = 0; i < cps.length; ++i) {
                cp = cps[i];
                if (cp == null || !cp.matchesBlockId(blockStateBase.getBlockId()) || (newIcon = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockStateBase, blockPos, side, icon, renderEnv)) == null) continue;
                return newIcon;
            }
        }
        if (blockProperties != null && checkBlocks && (blockId = renderEnv.getBlockId()) >= 0 && blockId < blockProperties.length && (cps = blockProperties[blockId]) != null) {
            side = ConnectedTextures.getSide(facing);
            for (i = 0; i < cps.length; ++i) {
                cp = cps[i];
                if (cp == null || !cp.matchesIcon(icon) || (newIcon = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockStateBase, blockPos, side, icon, renderEnv)) == null) continue;
                return newIcon;
            }
        }
        return icon;
    }

    public static int getSide(ct facing) {
        if (facing == null) {
            return -1;
        }
        switch (facing) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case f: {
                return 5;
            }
            case e: {
                return 4;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        return -1;
    }

    private static ct getFacing(int side) {
        switch (side) {
            case 0: {
                return ct.a;
            }
            case 1: {
                return ct.b;
            }
            case 5: {
                return ct.f;
            }
            case 4: {
                return ct.e;
            }
            case 2: {
                return ct.c;
            }
            case 3: {
                return ct.d;
            }
        }
        return ct.b;
    }

    private static bwe getConnectedTexture(ConnectedProperties cp, aih blockAccess, arp blockState, cm blockPos, int side, bwe icon, RenderEnv renderEnv) {
        aiq blockBiome;
        int y;
        int metadata;
        int vertAxis = 0;
        int metadataCheck = metadata = blockState.getMetadata();
        akf block = blockState.t();
        if (block instanceof aor) {
            vertAxis = ConnectedTextures.getWoodAxis(side, metadata);
            if (cp.getMetadataMax() <= 3) {
                metadataCheck &= 3;
            }
        }
        if (block instanceof aog) {
            vertAxis = ConnectedTextures.getQuartzAxis(side, metadata);
            if (cp.getMetadataMax() <= 2 && metadataCheck > 2) {
                metadataCheck = 2;
            }
        }
        if (!cp.matchesBlock(blockState.getBlockId(), metadataCheck)) {
            return null;
        }
        if (side >= 0 && cp.faces != 63) {
            int sideCheck = side;
            if (vertAxis != 0) {
                sideCheck = ConnectedTextures.fixSideByAxis(side, vertAxis);
            }
            if ((1 << sideCheck & cp.faces) == 0) {
                return null;
            }
        }
        if ((y = blockPos.q()) < cp.minHeight || y > cp.maxHeight) {
            return null;
        }
        if (cp.biomes != null && !cp.matchesBiome(blockBiome = blockAccess.b(blockPos))) {
            return null;
        }
        switch (cp.method) {
            case 1: {
                return ConnectedTextures.getConnectedTextureCtm(cp, blockAccess, (ars)blockState, blockPos, vertAxis, side, icon, metadata, renderEnv);
            }
            case 2: {
                return ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, (ars)blockState, blockPos, vertAxis, side, icon, metadata);
            }
            case 6: {
                return ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, (ars)blockState, blockPos, vertAxis, side, icon, metadata);
            }
            case 3: {
                return ConnectedTextures.getConnectedTextureTop(cp, blockAccess, (ars)blockState, blockPos, vertAxis, side, icon, metadata);
            }
            case 4: {
                return ConnectedTextures.getConnectedTextureRandom(cp, blockPos, side);
            }
            case 5: {
                return ConnectedTextures.getConnectedTextureRepeat(cp, blockPos, side);
            }
            case 7: {
                return ConnectedTextures.getConnectedTextureFixed(cp);
            }
            case 8: {
                return ConnectedTextures.getConnectedTextureHorizontalVertical(cp, blockAccess, (ars)blockState, blockPos, vertAxis, side, icon, metadata);
            }
            case 9: {
                return ConnectedTextures.getConnectedTextureVerticalHorizontal(cp, blockAccess, (ars)blockState, blockPos, vertAxis, side, icon, metadata);
            }
        }
        return null;
    }

    private static int fixSideByAxis(int side, int vertAxis) {
        switch (vertAxis) {
            case 0: {
                return side;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return side;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 0;
                    }
                }
                return side;
            }
        }
        return side;
    }

    private static int getWoodAxis(int side, int metadata) {
        int orient = (metadata & 0xC) >> 2;
        switch (orient) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private static int getQuartzAxis(int side, int metadata) {
        switch (metadata) {
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    private static bwe getConnectedTextureRandom(ConnectedProperties cp, cm blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int face = side / cp.symmetry * cp.symmetry;
        int rand = Config.getRandom(blockPos, face) & Integer.MAX_VALUE;
        int index = 0;
        if (cp.weights == null) {
            index = rand % cp.tileIcons.length;
        } else {
            int randWeight = rand % cp.sumAllWeights;
            int[] sumWeights = cp.sumWeights;
            for (int i = 0; i < sumWeights.length; ++i) {
                if (randWeight >= sumWeights[i]) continue;
                index = i;
                break;
            }
        }
        return cp.tileIcons[index];
    }

    private static bwe getConnectedTextureFixed(ConnectedProperties cp) {
        return cp.tileIcons[0];
    }

    private static bwe getConnectedTextureRepeat(ConnectedProperties cp, cm blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int x = blockPos.p();
        int y = blockPos.q();
        int z = blockPos.r();
        int nx = 0;
        int ny = 0;
        switch (side) {
            case 0: {
                nx = x;
                ny = z;
                break;
            }
            case 1: {
                nx = x;
                ny = z;
                break;
            }
            case 2: {
                nx = -x - 1;
                ny = -y;
                break;
            }
            case 3: {
                nx = x;
                ny = -y;
                break;
            }
            case 4: {
                nx = z;
                ny = -y;
                break;
            }
            case 5: {
                nx = -z - 1;
                ny = -y;
            }
        }
        ny %= cp.height;
        if ((nx %= cp.width) < 0) {
            nx += cp.width;
        }
        if (ny < 0) {
            ny += cp.height;
        }
        int index = ny * cp.width + nx;
        return cp.tileIcons[index];
    }

    private static bwe getConnectedTextureCtm(ConnectedProperties cp, aih blockAccess, ars blockState, cm blockPos, int vertAxis, int side, bwe icon, int metadata, RenderEnv renderEnv) {
        boolean[] borders = renderEnv.getBorderFlags();
        switch (side) {
            case 0: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                break;
            }
            case 1: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                break;
            }
            case 2: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                if (vertAxis != 1) break;
                ConnectedTextures.switchValues(0, 1, borders);
                ConnectedTextures.switchValues(2, 3, borders);
                break;
            }
            case 3: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 4: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 5: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                if (vertAxis != 2) break;
                ConnectedTextures.switchValues(0, 1, borders);
                ConnectedTextures.switchValues(2, 3, borders);
            }
        }
        int index = 0;
        if (borders[0] & !borders[1] & !borders[2] & !borders[3]) {
            index = 3;
        } else if (!borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 1;
        } else if (!borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 12;
        } else if (!borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 36;
        } else if (borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 2;
        } else if (!borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 24;
        } else if (borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 15;
        } else if (borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 39;
        } else if (!borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 13;
        } else if (!borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 37;
        } else if (!borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 25;
        } else if (borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 27;
        } else if (borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 38;
        } else if (borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 14;
        } else if (borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 26;
        }
        if (index == 0) {
            return cp.tileIcons[index];
        }
        if (!Config.isConnectedTexturesFancy()) {
            return cp.tileIcons[index];
        }
        boolean[] edges = borders;
        switch (side) {
            case 0: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().c(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().c(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().d(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().d(), side, icon, metadata);
                break;
            }
            case 1: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().d(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().d(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().c(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().c(), side, icon, metadata);
                break;
            }
            case 2: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().b(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().b(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().a(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().a(), side, icon, metadata);
                if (vertAxis != 1) break;
                ConnectedTextures.switchValues(0, 3, borders);
                ConnectedTextures.switchValues(1, 2, borders);
                break;
            }
            case 3: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().b(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().b(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().a(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e().a(), side, icon, metadata);
                break;
            }
            case 4: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().d(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().c(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a().d(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a().c(), side, icon, metadata);
                break;
            }
            case 5: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().c(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().d(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a().c(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a().d(), side, icon, metadata);
                if (vertAxis != 2) break;
                ConnectedTextures.switchValues(0, 3, borders);
                ConnectedTextures.switchValues(1, 2, borders);
            }
        }
        if (index == 13 && edges[0]) {
            index = 4;
        } else if (index == 15 && edges[1]) {
            index = 5;
        } else if (index == 37 && edges[2]) {
            index = 16;
        } else if (index == 39 && edges[3]) {
            index = 17;
        } else if (index == 14 && edges[0] && edges[1]) {
            index = 7;
        } else if (index == 25 && edges[0] && edges[2]) {
            index = 6;
        } else if (index == 27 && edges[3] && edges[1]) {
            index = 19;
        } else if (index == 38 && edges[3] && edges[2]) {
            index = 18;
        } else if (index == 14 && !edges[0] && edges[1]) {
            index = 31;
        } else if (index == 25 && edges[0] && !edges[2]) {
            index = 30;
        } else if (index == 27 && !edges[3] && edges[1]) {
            index = 41;
        } else if (index == 38 && edges[3] && !edges[2]) {
            index = 40;
        } else if (index == 14 && edges[0] && !edges[1]) {
            index = 29;
        } else if (index == 25 && !edges[0] && edges[2]) {
            index = 28;
        } else if (index == 27 && edges[3] && !edges[1]) {
            index = 43;
        } else if (index == 38 && !edges[3] && edges[2]) {
            index = 42;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 46;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 9;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 21;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 8;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 20;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 11;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 22;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 23;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 10;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 34;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 35;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && !edges[3]) {
            index = 32;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 33;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 44;
        } else if (index == 26 && !edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 45;
        }
        return cp.tileIcons[index];
    }

    private static void switchValues(int ix1, int ix2, boolean[] arr) {
        boolean prev1 = arr[ix1];
        arr[ix1] = arr[ix2];
        arr[ix2] = prev1;
    }

    private static boolean isNeighbour(ConnectedProperties cp, aih iblockaccess, ars blockState, cm blockPos, int side, bwe icon, int metadata) {
        ars neighbourState = iblockaccess.o(blockPos);
        if (blockState == neighbourState) {
            return true;
        }
        if (cp.connect == 2) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            bwe neighbourIcon = ConnectedTextures.getNeighbourIcon(iblockaccess, blockState, blockPos, neighbourState, side);
            return neighbourIcon == icon;
        }
        if (cp.connect == 3) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            return neighbourState.a() == blockState.a();
        }
        if (neighbourState instanceof arp) {
            arp neighbourStateBase = (arp)neighbourState;
            akf neighbourBlock = neighbourStateBase.t();
            int neighbourMetadata = neighbourStateBase.getMetadata();
            return neighbourBlock == blockState.t() && neighbourMetadata == metadata;
        }
        return false;
    }

    private static bwe getNeighbourIcon(aih iblockaccess, ars blockState, cm blockPos, ars neighbourState, int side) {
        neighbourState = neighbourState.t().b(neighbourState, iblockaccess, blockPos);
        byl model = bcx.z().ab().a().b(neighbourState);
        if (model == null) {
            return null;
        }
        ct facing = ConnectedTextures.getFacing(side);
        List quads = model.a(neighbourState, facing, 0L);
        if (quads.size() > 0) {
            boy quad = (boy)quads.get(0);
            return quad.a();
        }
        List quadsGeneral = model.a(neighbourState, null, 0L);
        for (int i = 0; i < quadsGeneral.size(); ++i) {
            boy quad = (boy)quadsGeneral.get(i);
            if (quad.e() != facing) continue;
            return quad.a();
        }
        return null;
    }

    private static bwe getConnectedTextureHorizontal(ConnectedProperties cp, aih blockAccess, ars blockState, cm blockPos, int vertAxis, int side, bwe icon, int metadata) {
        boolean left = false;
        boolean right = false;
        block0 : switch (vertAxis) {
            case 0: {
                switch (side) {
                    case 0: 
                    case 1: {
                        return null;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    }
                }
                break;
            }
            case 1: {
                switch (side) {
                    case 2: 
                    case 3: {
                        return null;
                    }
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    }
                }
                break;
            }
            case 2: {
                switch (side) {
                    case 4: 
                    case 5: {
                        return null;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        break block0;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        break block0;
                    }
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        break block0;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    }
                }
            }
        }
        int index = 3;
        index = left ? (right ? 1 : 2) : (right ? 0 : 3);
        return cp.tileIcons[index];
    }

    private static bwe getConnectedTextureVertical(ConnectedProperties cp, aih blockAccess, ars blockState, cm blockPos, int vertAxis, int side, bwe icon, int metadata) {
        boolean bottom = false;
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1 || side == 0) {
                    return null;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3 || side == 2) {
                    return null;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5 || side == 4) {
                    return null;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
            }
        }
        int index = 3;
        index = bottom ? (top ? 1 : 2) : (top ? 0 : 3);
        return cp.tileIcons[index];
    }

    private static bwe getConnectedTextureHorizontalVertical(ConnectedProperties cp, aih blockAccess, ars blockState, cm blockPos, int vertAxis, int side, bwe icon, int metadata) {
        bwe[] tileIcons = cp.tileIcons;
        bwe iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH != null && iconH != icon && iconH != tileIcons[3]) {
            return iconH;
        }
        bwe iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconV == tileIcons[1]) {
            return tileIcons[5];
        }
        if (iconV == tileIcons[2]) {
            return tileIcons[6];
        }
        return iconV;
    }

    private static bwe getConnectedTextureVerticalHorizontal(ConnectedProperties cp, aih blockAccess, ars blockState, cm blockPos, int vertAxis, int side, bwe icon, int metadata) {
        bwe[] tileIcons = cp.tileIcons;
        bwe iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV != null && iconV != icon && iconV != tileIcons[3]) {
            return iconV;
        }
        bwe iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconH == tileIcons[1]) {
            return tileIcons[5];
        }
        if (iconH == tileIcons[2]) {
            return tileIcons[6];
        }
        return iconH;
    }

    private static bwe getConnectedTextureTop(ConnectedProperties cp, aih blockAccess, ars blockState, cm blockPos, int vertAxis, int side, bwe icon, int metadata) {
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1 || side == 0) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.a(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3 || side == 2) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5 || side == 4) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
            }
        }
        if (top) {
            return cp.tileIcons[0];
        }
        return null;
    }

    public static void updateIcons(bwd textureMap) {
        blockProperties = null;
        tileProperties = null;
        spriteQuadMaps = null;
        if (!Config.isConnectedTextures()) {
            return;
        }
        bxf[] rps = Config.getResourcePacks();
        for (int i = rps.length - 1; i >= 0; --i) {
            bxf rp = rps[i];
            ConnectedTextures.updateIcons(textureMap, rp);
        }
        ConnectedTextures.updateIcons(textureMap, (bxf)Config.getDefaultResourcePack());
        kn locEmpty = new kn("mcpatcher/ctm/default/empty");
        emptySprite = textureMap.a(locEmpty);
        spriteQuadMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
        if (blockProperties.length <= 0) {
            blockProperties = null;
        }
        if (tileProperties.length <= 0) {
            tileProperties = null;
        }
    }

    private static void updateIconEmpty(bwd textureMap) {
    }

    public static void updateIcons(bwd textureMap, bxf rp) {
        Object[] names = ResUtils.collectFiles(rp, "mcpatcher/ctm/", ".properties", ConnectedTextures.getDefaultCtmPaths());
        Arrays.sort(names);
        List tileList = ConnectedTextures.makePropertyList(tileProperties);
        List blockList = ConnectedTextures.makePropertyList(blockProperties);
        for (int i = 0; i < names.length; ++i) {
            Object name = names[i];
            Config.dbg("ConnectedTextures: " + (String)name);
            try {
                kn locFile = new kn((String)name);
                InputStream in = rp.a(locFile);
                if (in == null) {
                    Config.warn("ConnectedTextures file not found: " + (String)name);
                    continue;
                }
                Properties props = new Properties();
                props.load(in);
                ConnectedProperties cp = new ConnectedProperties(props, (String)name);
                if (!cp.isValid((String)name)) continue;
                cp.updateIcons(textureMap);
                ConnectedTextures.addToTileList(cp, tileList);
                ConnectedTextures.addToBlockList(cp, blockList);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn("ConnectedTextures file not found: " + (String)name);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        blockProperties = ConnectedTextures.propertyListToArray(blockList);
        tileProperties = ConnectedTextures.propertyListToArray(tileList);
        multipass = ConnectedTextures.detectMultipass();
        Config.dbg("Multipass connected textures: " + multipass);
    }

    private static List makePropertyList(ConnectedProperties[][] propsArr) {
        ArrayList<ArrayList<ConnectedProperties>> list = new ArrayList<ArrayList<ConnectedProperties>>();
        if (propsArr != null) {
            for (int i = 0; i < propsArr.length; ++i) {
                ConnectedProperties[] props = propsArr[i];
                ArrayList<ConnectedProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<ConnectedProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static boolean detectMultipass() {
        ConnectedProperties[] cps;
        int i;
        ArrayList<ConnectedProperties> propList = new ArrayList<ConnectedProperties>();
        for (i = 0; i < tileProperties.length; ++i) {
            cps = tileProperties[i];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        for (i = 0; i < blockProperties.length; ++i) {
            cps = blockProperties[i];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        ConnectedProperties[] props = propList.toArray(new ConnectedProperties[propList.size()]);
        HashSet<bwe> matchIconSet = new HashSet<bwe>();
        HashSet<bwe> tileIconSet = new HashSet<bwe>();
        for (int i2 = 0; i2 < props.length; ++i2) {
            ConnectedProperties cp = props[i2];
            if (cp.matchTileIcons != null) {
                matchIconSet.addAll(Arrays.asList(cp.matchTileIcons));
            }
            if (cp.tileIcons == null) continue;
            tileIconSet.addAll(Arrays.asList(cp.tileIcons));
        }
        matchIconSet.retainAll(tileIconSet);
        return !matchIconSet.isEmpty();
    }

    private static ConnectedProperties[][] propertyListToArray(List list) {
        ConnectedProperties[][] propArr = new ConnectedProperties[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            ConnectedProperties[] subArr = subList.toArray(new ConnectedProperties[subList.size()]);
            propArr[i] = subArr;
        }
        return propArr;
    }

    private static void addToTileList(ConnectedProperties cp, List tileList) {
        if (cp.matchTileIcons == null) {
            return;
        }
        for (int i = 0; i < cp.matchTileIcons.length; ++i) {
            bwe icon = cp.matchTileIcons[i];
            if (!(icon instanceof bwe)) {
                Config.warn("TextureAtlasSprite is not TextureAtlasSprite: " + icon + ", name: " + icon.i());
                continue;
            }
            bwe ts = icon;
            int tileId = ts.getIndexInMap();
            if (tileId < 0) {
                Config.warn("Invalid tile ID: " + tileId + ", icon: " + ts.i());
                continue;
            }
            ConnectedTextures.addToList(cp, tileList, tileId);
        }
    }

    private static void addToBlockList(ConnectedProperties cp, List blockList) {
        if (cp.matchBlocks == null) {
            return;
        }
        for (int i = 0; i < cp.matchBlocks.length; ++i) {
            int blockId = cp.matchBlocks[i].getBlockId();
            if (blockId < 0) {
                Config.warn("Invalid block ID: " + blockId);
                continue;
            }
            ConnectedTextures.addToList(cp, blockList, blockId);
        }
    }

    private static void addToList(ConnectedProperties cp, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<ConnectedProperties> subList = (ArrayList<ConnectedProperties>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<ConnectedProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    private static String[] getDefaultCtmPaths() {
        ArrayList<String> list = new ArrayList<String>();
        String defPath = "mcpatcher/ctm/default/";
        if (Config.isFromDefaultResourcePack(new kn("textures/blocks/glass.png"))) {
            list.add(defPath + "glass.properties");
            list.add(defPath + "glasspane.properties");
        }
        if (Config.isFromDefaultResourcePack(new kn("textures/blocks/bookshelf.png"))) {
            list.add(defPath + "bookshelf.properties");
        }
        if (Config.isFromDefaultResourcePack(new kn("textures/blocks/sandstone_normal.png"))) {
            list.add(defPath + "sandstone.properties");
        }
        String[] colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        for (int i = 0; i < colors.length; ++i) {
            String color = colors[i];
            if (!Config.isFromDefaultResourcePack(new kn("textures/blocks/glass_" + color + ".png"))) continue;
            list.add(defPath + i + "_glass_" + color + "/glass_" + color + ".properties");
            list.add(defPath + i + "_glass_" + color + "/glass_pane_" + color + ".properties");
        }
        String[] paths = list.toArray(new String[list.size()]);
        return paths;
    }

    public static int getPaneTextureIndex(boolean linkP, boolean linkN, boolean linkYp, boolean linkYn) {
        if (linkN && linkP) {
            if (linkYp) {
                if (linkYn) {
                    return 34;
                }
                return 50;
            }
            if (linkYn) {
                return 18;
            }
            return 2;
        }
        if (linkN && !linkP) {
            if (linkYp) {
                if (linkYn) {
                    return 35;
                }
                return 51;
            }
            if (linkYn) {
                return 19;
            }
            return 3;
        }
        if (!linkN && linkP) {
            if (linkYp) {
                if (linkYn) {
                    return 33;
                }
                return 49;
            }
            if (linkYn) {
                return 17;
            }
            return 1;
        }
        if (linkYp) {
            if (linkYn) {
                return 32;
            }
            return 48;
        }
        if (linkYn) {
            return 16;
        }
        return 0;
    }

    public static int getReversePaneTextureIndex(int texNum) {
        int col = texNum % 16;
        if (col == 1) {
            return texNum + 2;
        }
        if (col == 3) {
            return texNum - 2;
        }
        return texNum;
    }

    public static bwe getCtmTexture(ConnectedProperties cp, int ctmIndex, bwe icon) {
        if (cp.method != 1) {
            return icon;
        }
        if (ctmIndex < 0 || ctmIndex >= ctmIndexes.length) {
            return icon;
        }
        int index = ctmIndexes[ctmIndex];
        bwe[] ctmIcons = cp.tileIcons;
        if (index < 0 || index >= ctmIcons.length) {
            return icon;
        }
        return ctmIcons[index];
    }
}

