/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.asm;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fiskfille.heroes.SHReflection;
import fiskfille.heroes.SuperHeroesAPI;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.damagesource.ModDamageSources;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.entity.arrow.EntityTrickArrow;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.item.armor.ItemHeroArmor;
import fiskfille.heroes.common.time.Tickrate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ASMHooks {
    public static long getMiliSecondsPerTick() {
        return Tickrate.MILISECONDS_PER_TICK;
    }

    public static List selectEntitiesWithinAABB(EntityCreature entity, Class clazz, AxisAlignedBB aabb, IEntitySelector entitySelector) {
        World world = entity.field_70170_p;
        List list = world.func_82733_a(clazz, aabb, entitySelector);
        for (int i = 0; i < list.size(); ++i) {
            EntityPlayer player;
            Hero hero;
            Entity entity1 = (Entity)list.get(i);
            if (!(entity1 instanceof EntityPlayer) || (hero = SHHelper.getHero(player = (EntityPlayer)entity1)) == null || !hero.hasAbility(Ability.invisibility) || !SHData.getBoolean(player, 13) || !(player.func_70032_d((Entity)entity) > 2.0f)) continue;
            list.remove(i);
        }
        return list;
    }

    public static List getAllowedPressureEntitiesWithinAABB(World world, Class clazz, AxisAlignedBB aabb) {
        List list = world.func_72872_a(clazz, aabb);
        List list1 = world.func_72839_b(null, aabb);
        for (Entity entity : list1) {
            if (!(entity instanceof EntityTrickArrow)) continue;
            list.add(entity);
        }
        return list;
    }

    public static EntityPlayer getClosestVulnerablePlayer(Entity entity, double x, double y, double z, double radius) {
        World world = entity.field_70170_p;
        double d = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            Hero hero;
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            if (player.field_71075_bZ.field_75102_a || !player.func_70089_S()) continue;
            double d1 = player.func_70092_e(x, y, z);
            double d2 = radius;
            if (player.func_70093_af()) {
                d2 = radius * (double)0.8f;
            }
            if (player.func_82150_aj()) {
                float f = player.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d2 *= (double)(0.7f * f);
            }
            if ((hero = SHHelper.getHero(player)) != null && hero.hasAbility(Ability.invisibility) && SHData.getBoolean(player, 13) && (player.func_70032_d(entity) > 2.0f || hero.hasAbility(Ability.intangibility) && SHData.getBoolean(player, 12)) || !(radius < 0.0) && !(d1 < d2 * d2) || d != -1.0 && !(d1 < d)) continue;
            d = d1;
            entityplayer = player;
        }
        return entityplayer;
    }

    public static float getDrawbackTime(EntityPlayer player) {
        ItemStack[] aitemstack;
        float f = 20.0f;
        ItemStack helmet = player.func_82169_q(3);
        ItemStack chest = player.func_82169_q(2);
        ItemStack legs = player.func_82169_q(1);
        ItemStack feet = player.func_82169_q(0);
        for (ItemStack itemstack : aitemstack = new ItemStack[]{helmet, chest, legs, feet}) {
            Multimap multimap;
            if (itemstack == helmet && helmet != null && chest != null && helmet.func_77973_b() instanceof ItemHeroArmor && SHHelper.getHeroFromArmor(helmet) != SHHelper.getHeroFromArmor(chest) || itemstack == null || !(itemstack.func_77973_b() instanceof ItemHeroArmor) || (multimap = itemstack.func_111283_C()).isEmpty()) continue;
            for (Object o : multimap.entries()) {
                Map.Entry entry = (Map.Entry)o;
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                String s = (String)entry.getKey();
                double d = attributemodifier.func_111164_d();
                int operation = attributemodifier.func_111169_c();
                if (!SHHelper.isPlayerHero(player) || !s.equals("armor.bowDrawback")) continue;
                if (operation == 0) {
                    f = (float)((double)f - d / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                    continue;
                }
                if (operation != 1) continue;
                f = (float)((double)f - d * 20.0 / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
            }
        }
        return f;
    }

    public static int getBowIconTime2(EntityPlayer player) {
        return (int)(ASMHooks.getDrawbackTime(player) * 0.65f);
    }

    public static int getBowIconTime3(EntityPlayer player) {
        return (int)(ASMHooks.getDrawbackTime(player) * 0.9f);
    }

    public static float getEntityScale(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return SHData.getFloat((EntityPlayer)entity, 6);
        }
        return 1.0f;
    }

    public static float getModifiedEntityScale(Entity entity) {
        if (ASMHooks.getEntityScale(entity) > 1.0f) {
            return ASMHooks.getEntityScale(entity);
        }
        return 1.0f;
    }

    public static boolean shouldProduceSprintParticles(Entity entity) {
        return ASMHooks.getEntityScale(entity) > 0.2f;
    }

    public static String getPotionParticleName(Entity entity, String baseName) {
        return baseName + "_" + ASMHooks.getEntityScale(entity);
    }

    public static float getArmorVisibilityMultiplier(EntityPlayer player) {
        if (SHHelper.isPlayerHero(player) && SHHelper.getHero(player).hasAbility(Ability.invisibility) && SHData.getBoolean(player, 13)) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static int getArmSwingDivide(Entity entity) {
        EntityPlayer player;
        if (entity instanceof EntityPlayer && SHHelper.canRunSuperSpeed(player = (EntityPlayer)entity) && SHData.getBoolean(player, 0) && SHData.getInt(player, 1) >= 0) {
            return 2;
        }
        return 1;
    }

    public static int getHealRate(EntityPlayer player, int rate) {
        Hero hero = SHHelper.getHero(player);
        if (hero != null && hero.hasAbility(Ability.regeneration1)) {
            return rate / 4;
        }
        return rate;
    }

    public static AxisAlignedBB getLiquidBoundingBox(BlockLiquid block, World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        double maxY = 1.0f - BlockLiquid.func_149801_b((int)metadata);
        boolean flag = false;
        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)x + block.func_149704_x()), (double)((double)y + maxY), (double)((double)z + block.func_149706_B()), (double)((double)x + block.func_149753_y()), (double)((double)y + block.func_149669_A() + 0.5), (double)((double)z + block.func_149693_C())))) {
            if (!SHHelper.canPlayerRunOnWater(player)) continue;
            flag = true;
            break;
        }
        if (flag && block == Blocks.field_150355_j && block != Blocks.field_150358_i && world.func_147439_a(x, y + 1, z) != Blocks.field_150355_j && world.func_147439_a(x, y + 1, z) != Blocks.field_150358_i) {
            return AxisAlignedBB.func_72330_a((double)((double)x + block.func_149704_x()), (double)((double)y + maxY), (double)((double)z + block.func_149706_B()), (double)((double)x + block.func_149753_y()), (double)((double)y + maxY), (double)((double)z + block.func_149693_C()));
        }
        return null;
    }

    public static void noClipCollide(Entity entity, double offsetX, double offsetY, double offsetZ) {
        int k;
        double d11;
        double d10;
        double d12;
        int j;
        boolean flag1;
        EntityPlayer player;
        Hero hero;
        boolean flag = false;
        if (entity instanceof EntityPlayer && (hero = SHHelper.getHero(player = (EntityPlayer)entity)) != null && hero.hasAbility(Ability.intangibility) && SHData.getBoolean(player, 12)) {
            flag = true;
        }
        if (!flag) {
            entity.field_70121_D.func_72317_d(offsetX, offsetY, offsetZ);
            entity.field_70165_t = (entity.field_70121_D.field_72340_a + entity.field_70121_D.field_72336_d) / 2.0;
            entity.field_70163_u = entity.field_70121_D.field_72338_b + (double)entity.field_70129_M - (double)entity.field_70139_V;
            entity.field_70161_v = (entity.field_70121_D.field_72339_c + entity.field_70121_D.field_72334_f) / 2.0;
            return;
        }
        Random rand = new Random();
        int nextStepDistance = (Integer)SHReflection.getField(SHReflection.nextStepDistanceField, entity);
        entity.field_70170_p.field_72984_F.func_76320_a("move");
        entity.field_70139_V *= 0.4f;
        double d3 = entity.field_70165_t;
        double d4 = entity.field_70163_u;
        double d5 = entity.field_70161_v;
        double d6 = offsetX;
        double d7 = offsetY;
        double d8 = offsetZ;
        AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72329_c();
        boolean bl = flag1 = entity.field_70122_E && entity.func_70093_af() && entity instanceof EntityPlayer;
        if (flag1) {
            double d9 = 0.05;
            while (offsetX != 0.0 && ASMHooks.getCollidingBoundingBoxes(entity, entity.field_70121_D.func_72325_c(offsetX, -1.0, 0.0)).isEmpty()) {
                offsetX = offsetX < d9 && offsetX >= -d9 ? 0.0 : (offsetX > 0.0 ? (offsetX -= d9) : (offsetX += d9));
                d6 = offsetX;
            }
            while (offsetZ != 0.0 && ASMHooks.getCollidingBoundingBoxes(entity, entity.field_70121_D.func_72325_c(0.0, -1.0, offsetZ)).isEmpty()) {
                offsetZ = offsetZ < d9 && offsetZ >= -d9 ? 0.0 : (offsetZ > 0.0 ? (offsetZ -= d9) : (offsetZ += d9));
                d8 = offsetZ;
            }
            while (offsetX != 0.0 && offsetZ != 0.0 && ASMHooks.getCollidingBoundingBoxes(entity, entity.field_70121_D.func_72325_c(offsetX, -1.0, offsetZ)).isEmpty()) {
                offsetX = offsetX < d9 && offsetX >= -d9 ? 0.0 : (offsetX > 0.0 ? (offsetX -= d9) : (offsetX += d9));
                offsetZ = offsetZ < d9 && offsetZ >= -d9 ? 0.0 : (offsetZ > 0.0 ? (offsetZ -= d9) : (offsetZ += d9));
                d6 = offsetX;
                d8 = offsetZ;
            }
        }
        List list = ASMHooks.getCollidingBoundingBoxes(entity, entity.field_70121_D.func_72321_a(offsetX, offsetY, offsetZ));
        for (Object aList : list) {
            offsetY = ((AxisAlignedBB)aList).func_72323_b(entity.field_70121_D, offsetY);
        }
        entity.field_70121_D.func_72317_d(0.0, offsetY, 0.0);
        if (!entity.field_70135_K && d7 != offsetY) {
            offsetZ = 0.0;
            offsetY = 0.0;
            offsetX = 0.0;
        }
        boolean flag2 = entity.field_70122_E || d7 != offsetY && d7 < 0.0;
        for (j = 0; j < list.size(); ++j) {
            offsetX = ((AxisAlignedBB)list.get(j)).func_72316_a(entity.field_70121_D, offsetX);
        }
        entity.field_70121_D.func_72317_d(offsetX, 0.0, 0.0);
        if (!entity.field_70135_K && d6 != offsetX) {
            offsetZ = 0.0;
            offsetY = 0.0;
            offsetX = 0.0;
        }
        for (j = 0; j < list.size(); ++j) {
            offsetZ = ((AxisAlignedBB)list.get(j)).func_72322_c(entity.field_70121_D, offsetZ);
        }
        entity.field_70121_D.func_72317_d(0.0, 0.0, offsetZ);
        if (!entity.field_70135_K && d8 != offsetZ) {
            offsetZ = 0.0;
            offsetY = 0.0;
            offsetX = 0.0;
        }
        if (entity.field_70138_W > 0.0f && flag2 && (flag1 || entity.field_70139_V < 0.05f) && (d6 != offsetX || d8 != offsetZ)) {
            d12 = offsetX;
            d10 = offsetY;
            d11 = offsetZ;
            offsetX = d6;
            offsetY = entity.field_70138_W;
            offsetZ = d8;
            AxisAlignedBB axisalignedbb1 = entity.field_70121_D.func_72329_c();
            entity.field_70121_D.func_72328_c(axisalignedbb);
            list = ASMHooks.getCollidingBoundingBoxes(entity, entity.field_70121_D.func_72321_a(d6, offsetY, d8));
            for (k = 0; k < list.size(); ++k) {
                offsetY = ((AxisAlignedBB)list.get(k)).func_72323_b(entity.field_70121_D, offsetY);
            }
            entity.field_70121_D.func_72317_d(0.0, offsetY, 0.0);
            if (!entity.field_70135_K && d7 != offsetY) {
                offsetZ = 0.0;
                offsetY = 0.0;
                offsetX = 0.0;
            }
            for (k = 0; k < list.size(); ++k) {
                offsetX = ((AxisAlignedBB)list.get(k)).func_72316_a(entity.field_70121_D, offsetX);
            }
            entity.field_70121_D.func_72317_d(offsetX, 0.0, 0.0);
            if (!entity.field_70135_K && d6 != offsetX) {
                offsetZ = 0.0;
                offsetY = 0.0;
                offsetX = 0.0;
            }
            for (k = 0; k < list.size(); ++k) {
                offsetZ = ((AxisAlignedBB)list.get(k)).func_72322_c(entity.field_70121_D, offsetZ);
            }
            entity.field_70121_D.func_72317_d(0.0, 0.0, offsetZ);
            if (!entity.field_70135_K && d8 != offsetZ) {
                offsetZ = 0.0;
                offsetY = 0.0;
                offsetX = 0.0;
            }
            if (!entity.field_70135_K && d7 != offsetY) {
                offsetZ = 0.0;
                offsetY = 0.0;
                offsetX = 0.0;
            } else {
                offsetY = -entity.field_70138_W;
                for (k = 0; k < list.size(); ++k) {
                    offsetY = ((AxisAlignedBB)list.get(k)).func_72323_b(entity.field_70121_D, offsetY);
                }
                entity.field_70121_D.func_72317_d(0.0, offsetY, 0.0);
            }
            if (d12 * d12 + d11 * d11 >= offsetX * offsetX + offsetZ * offsetZ) {
                offsetX = d12;
                offsetY = d10;
                offsetZ = d11;
                entity.field_70121_D.func_72328_c(axisalignedbb1);
            }
        }
        entity.field_70170_p.field_72984_F.func_76319_b();
        entity.field_70170_p.field_72984_F.func_76320_a("rest");
        entity.field_70165_t = (entity.field_70121_D.field_72340_a + entity.field_70121_D.field_72336_d) / 2.0;
        entity.field_70163_u = entity.field_70121_D.field_72338_b + (double)entity.field_70129_M - (double)entity.field_70139_V;
        entity.field_70161_v = (entity.field_70121_D.field_72339_c + entity.field_70121_D.field_72334_f) / 2.0;
        entity.field_70123_F = d6 != offsetX || d8 != offsetZ;
        entity.field_70124_G = d7 != offsetY;
        entity.field_70122_E = d7 != offsetY && d7 < 0.0;
        boolean bl2 = entity.field_70132_H = entity.field_70123_F || entity.field_70124_G;
        if (d6 != offsetX) {
            entity.field_70159_w = 0.0;
        }
        if (d7 != offsetY) {
            entity.field_70181_x = 0.0;
        }
        if (d8 != offsetZ) {
            entity.field_70179_y = 0.0;
        }
        d12 = entity.field_70165_t - d3;
        d10 = entity.field_70163_u - d4;
        d11 = entity.field_70161_v - d5;
        if (((Boolean)SHReflection.getMethod(SHReflection.canTriggerWalkingMethod, entity, new Object[0])).booleanValue() && !flag1 && entity.field_70154_o == null) {
            int j1 = MathHelper.func_76128_c((double)entity.field_70165_t);
            k = MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f - (double)entity.field_70129_M));
            int l = MathHelper.func_76128_c((double)entity.field_70161_v);
            Block block = entity.field_70170_p.func_147439_a(j1, k, l);
            int i1 = entity.field_70170_p.func_147439_a(j1, k - 1, l).func_149645_b();
            if (i1 == 11 || i1 == 32 || i1 == 21) {
                block = entity.field_70170_p.func_147439_a(j1, k - 1, l);
            }
            if (block != Blocks.field_150468_ap) {
                d10 = 0.0;
            }
            entity.field_70140_Q = (float)((double)entity.field_70140_Q + (double)MathHelper.func_76133_a((double)(d12 * d12 + d11 * d11)) * 0.6);
            entity.field_82151_R = (float)((double)entity.field_82151_R + (double)MathHelper.func_76133_a((double)(d12 * d12 + d10 * d10 + d11 * d11)) * 0.6);
            if (entity.field_82151_R > (float)nextStepDistance && block.func_149688_o() != Material.field_151579_a) {
                nextStepDistance = (int)entity.field_82151_R + 1;
            }
        }
        entity.field_70170_p.field_72984_F.func_76319_b();
        SHReflection.setField(SHReflection.nextStepDistanceField, entity, nextStepDistance);
    }

    public static List getCollidingBoundingBoxes(Entity entity, AxisAlignedBB aabb) {
        World world = entity.field_70170_p;
        ArrayList collidingBoundingBoxes = Lists.newArrayList();
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!world.func_72899_e(k1, 64, l1)) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    Block block = k1 >= -30000000 && k1 < 30000000 && l1 >= -30000000 && l1 < 30000000 ? world.func_147439_a(k1, i2, l1) : Blocks.field_150348_b;
                    if (!SuperHeroesAPI.getUnphasables().contains(block)) continue;
                    block.func_149743_a(world, k1, i2, l1, aabb, (List)collidingBoundingBoxes, entity);
                }
            }
        }
        double d0 = 0.25;
        List list = world.func_72839_b(entity, aabb.func_72314_b(d0, d0, d0));
        for (Object aList : list) {
            AxisAlignedBB axisalignedbb1 = ((Entity)aList).func_70046_E();
            if (axisalignedbb1 != null && axisalignedbb1.func_72326_a(aabb)) {
                collidingBoundingBoxes.add(axisalignedbb1);
            }
            if ((axisalignedbb1 = entity.func_70114_g((Entity)aList)) == null || !axisalignedbb1.func_72326_a(aabb)) continue;
            collidingBoundingBoxes.add(axisalignedbb1);
        }
        return collidingBoundingBoxes;
    }

    public static boolean moveEntityWithHeading(EntityLivingBase entity, float strafe, float forward) {
        if (entity instanceof EntityPlayer) {
            boolean flight;
            EntityPlayer player = (EntityPlayer)entity;
            Hero hero = SHHelper.getHero(player);
            boolean bl = flight = hero != null && hero.hasAbility(Ability.flight3);
            if (player.func_70613_aW() && !player.func_70090_H() && !player.func_70058_J() && SHData.getBoolean(player, 42)) {
                double d10;
                double d3;
                float f5;
                if (player.field_70181_x > -0.5) {
                    player.field_70143_R = 1.0f;
                }
                Vec3 vec3d = player.func_70040_Z();
                float f = player.field_70125_A * 0.01745329f;
                double d6 = Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
                double d8 = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y) * (double)(flight ? 1.0f + forward * 2.0f : 1.0f);
                double d1 = vec3d.func_72433_c();
                float f4 = MathHelper.func_76134_b((float)f);
                f4 = (float)((double)(f4 * f4) * Math.min(1.0, d1 / 0.4));
                player.field_70181_x += -0.08 + (double)f4 * 0.06;
                if (d8 > 2.5) {
                    d8 = 2.5;
                }
                if (player.field_70181_x < 0.0 && d6 > 0.0) {
                    double d2 = player.field_70181_x * -0.1 * (double)f4;
                    player.field_70181_x += d2;
                    player.field_70159_w += vec3d.field_72450_a * d2 / d6;
                    player.field_70179_y += vec3d.field_72449_c * d2 / d6;
                }
                if (f < 0.0f) {
                    double d9 = d8 * (double)(-MathHelper.func_76126_a((float)f)) * 0.04;
                    player.field_70181_x += d9 * 3.2;
                    player.field_70159_w -= vec3d.field_72450_a * d9 / d6;
                    player.field_70179_y -= vec3d.field_72449_c * d9 / d6;
                }
                if (d6 > 0.0) {
                    player.field_70159_w += (vec3d.field_72450_a / d6 * d8 - player.field_70159_w) * 0.1;
                    player.field_70179_y += (vec3d.field_72449_c / d6 * d8 - player.field_70179_y) * 0.1;
                }
                player.field_70159_w *= (double)0.99f;
                player.field_70181_x *= (double)0.98f;
                player.field_70179_y *= (double)0.99f;
                player.func_70091_d(player.field_70159_w, player.field_70181_x, player.field_70179_y);
                if (player.field_70123_F && !player.field_70170_p.field_72995_K && (f5 = (float)((d3 = d8 - (d10 = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70181_x * player.field_70181_x + player.field_70179_y * player.field_70179_y))) * 10.0 - 3.0)) > 0.0f) {
                    player.func_85030_a((int)f5 > 4 ? "game.player.hurt.fall.big" : "game.player.hurt.fall.small", 1.0f, 1.0f);
                    player.func_70097_a(ModDamageSources.flyIntoWall, f5);
                }
                if (SHHelper.getHero(player) != null && SHHelper.getHero(player).hasAbility(Ability.flight3)) {
                    AxisAlignedBB aabb = player.field_70121_D.func_72329_c().func_72314_b(1.0, 0.0, 1.0);
                    List list = player.field_70170_p.func_82733_a(EntityLivingBase.class, aabb, IEntitySelector.field_94557_a);
                    if (!player.field_70170_p.field_72995_K) {
                        for (EntityLivingBase entity1 : list) {
                            double d102;
                            float f52;
                            if (entity1 == player || !((f52 = (float)((d102 = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70181_x * player.field_70181_x + player.field_70179_y * player.field_70179_y)) * 10.0)) > 2.0f)) continue;
                            entity1.func_70097_a(ModDamageSources.causeCollisionDamage((Entity)player), f52 - 4.0f);
                        }
                    }
                }
                player.field_70722_aY = player.field_70721_aZ;
                double d9 = player.field_70165_t - player.field_70169_q;
                double d103 = player.field_70161_v - player.field_70166_s;
                float f6 = MathHelper.func_76133_a((double)(d9 * d9 + d103 * d103)) * 4.0f;
                if (f6 > 1.0f) {
                    f6 = 1.0f;
                }
                player.field_70721_aZ += (f6 - player.field_70721_aZ) * 0.4f;
                player.field_70754_ba += player.field_70721_aZ;
                return true;
            }
        }
        return false;
    }

    public static double getScaledSneakOffset(Entity entity, double d) {
        return d * (double)ASMHooks.getEntityScale(entity);
    }
}

