/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.heroes.SuperHeroesAPI;
import fiskfille.heroes.client.gui.GuiHeroList;
import fiskfille.heroes.common.container.ContainerSuitFabricator;
import fiskfille.heroes.common.helper.FabricatorHelper;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.network.PacketSetSelectedHero;
import fiskfille.heroes.common.network.SHNetworkManager;
import fiskfille.heroes.common.tileentity.TileEntitySuitFabricator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSuitFabricator
extends GuiContainer {
    private static final ResourceLocation guiTextures = new ResourceLocation("fiskheroes", "textures/gui/container/suit_fabricator.png");
    private TileEntitySuitFabricator tile;
    private GuiHeroList heroList;
    private List<Hero> heroes;

    public GuiSuitFabricator(InventoryPlayer inventoryPlayer, TileEntitySuitFabricator tileentity) {
        super((Container)new ContainerSuitFabricator(inventoryPlayer, tileentity));
        this.tile = tileentity;
        this.field_147000_g = 210;
        this.heroes = new ArrayList<Hero>(SuperHeroesAPI.getHeroes());
        Collections.sort(this.heroes, new Comparator<Hero>(){

            @Override
            public int compare(Hero arg0, Hero arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int listWidth = 0;
        for (Hero hero : this.heroes) {
            listWidth = Math.max(listWidth, this.getFontRenderer().func_78256_a(SHHelper.formatHero(hero)) + 10);
        }
        listWidth = Math.min(listWidth, 150);
        this.heroList = new GuiHeroList(this, this.heroes, this.field_146999_f, this.field_147000_g, 106);
        this.heroList.registerScrollButtons(this.field_146292_n, 7, 8);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void selectHero(int index) {
        Hero prevHero = this.tile.hero;
        this.tile.hero = index >= 0 && index <= this.heroes.size() ? this.heroes.get(index) : null;
        if (prevHero != this.tile.hero && this.tile.func_145831_w().field_72995_K) {
            SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSetSelectedHero(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, this.tile.hero));
        }
    }

    public boolean heroSelected(int index) {
        return this.heroes.get(index) == this.tile.hero;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int cost;
        String s = this.tile.func_145818_k_() ? this.tile.func_145825_b() : I18n.func_135052_a((String)this.tile.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 94, 0x404040);
        Hero hero = this.tile.hero;
        int energy = FabricatorHelper.getTotalEnergy(this.tile);
        if (hero != null && (cost = FabricatorHelper.getMaterialCost(hero)) > 0) {
            int k = 8453920;
            String s1 = I18n.func_135052_a((String)"gui.suit_fabricator.cost", (Object[])new Object[]{SHHelper.formatNumber(cost)});
            if (energy < cost) {
                k = 0xFF6060;
            }
            int color = 0xFF000000 | (k & 0xFCFCFC) >> 2 | k & 0xFF000000;
            int x = this.field_146999_f - 8 - this.field_146289_q.func_78256_a(s1);
            int y = this.field_147000_g - 94;
            if (this.field_146289_q.func_82883_a()) {
                GuiSuitFabricator.func_73734_a((int)(x - 3), (int)(y - 2), (int)(this.field_146999_f - 7), (int)(y + 10), (int)-16777216);
                GuiSuitFabricator.func_73734_a((int)(x - 2), (int)(y - 1), (int)(this.field_146999_f - 8), (int)(y + 9), (int)-12895429);
            } else {
                this.field_146289_q.func_78276_b(s1, x, y + 1, color);
                this.field_146289_q.func_78276_b(s1, x + 1, y, color);
                this.field_146289_q.func_78276_b(s1, x + 1, y + 1, color);
            }
            this.field_146289_q.func_78276_b(s1, x, y, k);
        }
        boolean unicode = this.field_146289_q.func_82883_a();
        String s1 = SHHelper.formatNumber(energy);
        this.field_146289_q.func_78264_a(true);
        this.field_146289_q.func_78276_b(s1, this.field_146999_f - 8 - this.field_146289_q.func_78256_a(s1), this.field_147000_g - 104, 0x404040);
        this.field_146289_q.func_78264_a(unicode);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        this.heroList.drawScreen(mouseX, mouseY, partialTicks);
    }
}

