/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.heroes.client.gui.book.Book;
import fiskfille.heroes.client.gui.book.Books;
import fiskfille.heroes.client.gui.book.Clickable;
import fiskfille.heroes.client.gui.book.Page;
import fiskfille.heroes.client.gui.book.PageCharacter;
import fiskfille.heroes.client.gui.book.PageSummary;
import fiskfille.heroes.client.gui.book.PageTOC;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.helper.SHRenderHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.proxy.ClientProxy;
import fiskfille.heroes.common.weakness.Weakness;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSuperheroesBook
extends GuiScreen {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("fiskheroes", "textures/gui/metahuman_log.png");
    private final EntityPlayer player;
    private final Book book;
    private int updateCount;
    private int bookImageWidth = 278;
    private int bookImageHeight = 180;
    private int currPage;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GuiButton buttonDone;

    public GuiSuperheroesBook(EntityPlayer player, Book book) {
        this.player = player;
        Books.register();
        this.book = book;
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int i = (this.field_146294_l - this.bookImageWidth) / 2;
        int j = 3;
        this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 19 + this.bookImageHeight, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        this.buttonNextPage = new NextPageButton(1, i + this.bookImageWidth - 46, j + 153, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, i + 22, j + 153, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currPage < this.book.getTotalPagePairs() - 1;
        this.buttonPreviousPage.field_146125_m = this.currPage > 0;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a(null);
            } else if (button.field_146127_k == 1) {
                if (this.currPage < this.book.getTotalPagePairs() - 1) {
                    ++this.currPage;
                }
            } else if (button.field_146127_k == 2 && this.currPage > 0) {
                --this.currPage;
            }
            this.updateButtons();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        int currPage1 = (this.currPage + 1) * 2 - 1;
        int currPage2 = (this.currPage + 1) * 2;
        for (Page page : this.book.pages) {
            if (page.pageNumber != currPage1 && page.pageNumber != currPage2 || page.clickables == null || button != 0) continue;
            for (Clickable clickable : page.clickables) {
                boolean flag = false;
                for (Rectangle rect : clickable.bounds) {
                    if (mouseX < rect.x || mouseX >= rect.x + rect.width || mouseY < rect.y || mouseY >= rect.y + rect.height) continue;
                    flag = true;
                }
                if (!flag) continue;
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                clickable.execute(button);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
        int x = (this.field_146294_l - this.bookImageWidth) / 2;
        int y = 3;
        int currPage1 = (this.currPage + 1) * 2 - 1;
        int currPage2 = (this.currPage + 1) * 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.bookImageWidth, this.bookImageHeight, 512, 512);
        this.field_146289_q.func_78276_b(currPage1 + "", x + 16, y + 10, 0);
        this.field_146289_q.func_78276_b(currPage2 + "", x - 16 + this.bookImageWidth - this.field_146289_q.func_78256_a(currPage2 + ""), y + 10, 0);
        for (Page page : this.book.pages) {
            page.clickables.clear();
            if (page.pageNumber == currPage1 || page.pageNumber == currPage2) {
                int cap;
                String s = page.getTranslatedHeader();
                String s1 = page.getTranslatedContent().replace("\\n", "\n").replaceAll("\\\\#", "\\\\u00A7").replaceAll("\\#", "\u00a7").replaceAll("\\\\u00A7", "\\#");
                String name = "";
                if (page instanceof PageCharacter && page.pageNumber == currPage1 && s != null && s.contains("/")) {
                    name = s.substring(s.indexOf("/") + 1);
                    s = s.substring(0, s.indexOf("/"));
                }
                boolean isChapter = this.book.chapters.contains(page);
                float chapterTextScale = 1.5f;
                int j = (page.pageNumber == currPage1 ? x + 16 : x + 146) + (isChapter ? 15 : 0);
                int k = isChapter ? y + 45 : y + 25;
                int n = cap = isChapter ? (int)(116.0f / chapterTextScale) - 20 : 116;
                if (!StringUtils.func_151246_b((String)s)) {
                    s = s.replaceAll("\\\\#", "\\\\u00A7").replaceAll("\\#", "\u00a7").replaceAll("\\\\u00A7", "\\#");
                    this.field_146289_q.func_78276_b(EnumChatFormatting.BOLD + s, j + 58 - this.field_146289_q.func_78256_a(EnumChatFormatting.BOLD + s) / 2, k, 0);
                    k += page instanceof PageCharacter ? 20 : 15;
                }
                if (!isChapter) {
                    this.field_146289_q.func_78279_b(s1, j, k, cap, 0);
                    if (page instanceof PageTOC) {
                        PageTOC toc = (PageTOC)page;
                        for (int i = 0; i < toc.parentChapters.size(); ++i) {
                            final Page page1 = toc.parentChapters.get(i);
                            String s2 = page1.getTranslatedContent();
                            String s3 = "" + page1.pageNumber;
                            while (this.field_146289_q.func_78256_a(s2 + s3) < cap - this.field_146289_q.func_78256_a(".") / 2) {
                                s2 = s2 + ".";
                            }
                            this.field_146289_q.func_78276_b(s2, j, k + this.field_146289_q.field_78288_b * i, 0);
                            this.field_146289_q.func_78276_b(s3, j + cap - this.field_146289_q.func_78256_a(s3), k + this.field_146289_q.field_78288_b * i, 0);
                            toc.clickables.add(new Clickable(){

                                @Override
                                public void execute(int button) {
                                    int newCurrPage1 = (GuiSuperheroesBook.this.currPage + 1) * 2 - 1;
                                    int newCurrPage2 = (GuiSuperheroesBook.this.currPage + 1) * 2;
                                    if (page1.pageNumber % 2 == 0) {
                                        GuiSuperheroesBook.this.currPage = page1.pageNumber / 2 - 1;
                                    } else {
                                        GuiSuperheroesBook.this.currPage = page1.pageNumber / 2;
                                    }
                                    GuiSuperheroesBook.this.updateButtons();
                                }
                            }.setBounds(new Rectangle(j, k + this.field_146289_q.field_78288_b * i, cap, this.field_146289_q.field_78288_b)));
                        }
                    } else if (page instanceof PageCharacter) {
                        PageCharacter character = (PageCharacter)page;
                        Hero hero = character.character;
                        EntityClientPlayerMP entity = ClientProxy.fakePlayer;
                        if (hero != null) {
                            int i;
                            if (page.pageNumber == currPage1) {
                                ItemStack itemstack;
                                if (!StringUtils.func_151246_b((String)name)) {
                                    name = name.replaceAll("\\\\#", "\\\\u00A7").replaceAll("\\#", "\u00a7").replaceAll("\\\\u00A7", "\\#");
                                    this.field_146289_q.func_78276_b(name, j + 58 - this.field_146289_q.func_78256_a(name) / 2, k - 12, 0);
                                }
                                RenderItem itemRenderer = new RenderItem();
                                GL11.glDisable((int)2896);
                                GL11.glEnable((int)32826);
                                GL11.glEnable((int)2903);
                                GL11.glEnable((int)2896);
                                Item[] items = new Item[]{hero.getHelmet(), hero.getChestplate(), hero.getLeggings(), hero.getBoots()};
                                i = 0;
                                for (Item item : items) {
                                    if (item != null) {
                                        itemstack = new ItemStack(item);
                                        itemRenderer.func_82406_b(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), itemstack, j + 9, 50 + i * 18);
                                    }
                                    ++i;
                                }
                                GL11.glEnable((int)3553);
                                GL11.glDisable((int)2896);
                                GL11.glDepthMask((boolean)true);
                                GL11.glEnable((int)2929);
                                if (entity != null) {
                                    i = 0;
                                    for (Item item : items) {
                                        if (item != null) {
                                            itemstack = new ItemStack(item);
                                            entity.func_70062_b(4 - i, itemstack);
                                        } else {
                                            entity.func_70062_b(4 - i, null);
                                        }
                                        ++i;
                                    }
                                    entity.field_71075_bZ.field_75100_b = true;
                                    entity.field_70759_as = 0.0f;
                                    entity.func_82142_c(false);
                                    entity.func_70106_y();
                                    if (entity.field_70153_n == null) {
                                        entity.field_70153_n = new EntityHorse((World)this.field_146297_k.field_71441_e);
                                    }
                                    int l = j + cap / 3 * 2;
                                    int m = k + 185;
                                    float scale = 50.0f;
                                    GL11.glEnable((int)2903);
                                    GL11.glPushMatrix();
                                    GL11.glTranslatef((float)l, (float)m, (float)50.0f);
                                    GL11.glScalef((float)(-scale), (float)scale, (float)scale);
                                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                                    float f2 = entity.field_70761_aq;
                                    float f3 = entity.field_70177_z;
                                    float f4 = entity.field_70125_A;
                                    float f5 = entity.field_70758_at;
                                    float f6 = entity.field_70759_as;
                                    GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                    RenderHelper.func_74519_b();
                                    GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                    GL11.glTranslatef((float)0.0f, (float)entity.field_70129_M, (float)10.0f);
                                    GL11.glRotatef((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                                    GL11.glRotatef((float)(((float)entity.field_70173_aa + partialTicks) * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                                    RenderManager.field_78727_a.field_78735_i = 180.0f;
                                    SHRenderHelper.startGlScissor(j, k - 10, 120, 120);
                                    entity.field_71106_cc = -0.0086f;
                                    RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
                                    SHRenderHelper.endGlScissor();
                                    GL11.glPopMatrix();
                                    RenderHelper.func_74518_a();
                                    GL11.glDisable((int)32826);
                                    OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
                                    GL11.glDisable((int)3553);
                                    OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
                                }
                            } else {
                                ArrayList list = Lists.newArrayList();
                                Item item = hero.getChestplate();
                                if (item != null) {
                                    ItemStack itemstack = new ItemStack(item);
                                    Ability[] abilities = hero.getAbilities();
                                    Weakness[] weaknesses = hero.getWeaknesses();
                                    list.add(StatCollector.func_74837_a((String)"tooltip.tier", (Object[])new Object[]{hero.getTier()}));
                                    if (abilities.length > 0 || weaknesses.length > 0) {
                                        list.add("");
                                    }
                                    for (Ability ability : abilities) {
                                        list.add("ability* " + ability.getNameTranslated());
                                    }
                                    for (Weakness weakness : weaknesses) {
                                        list.add("weakness* " + weakness.getNameTranslated());
                                    }
                                    Multimap multimap = item.getAttributeModifiers(itemstack);
                                    if (!multimap.isEmpty()) {
                                        list.add("");
                                        for (Object o : multimap.entries()) {
                                            Map.Entry entry = (Map.Entry)o;
                                            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                                            double d0 = attributemodifier.func_111164_d();
                                            double d1 = attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2 ? d0 : d0 * 100.0;
                                            if (d0 > 0.0) {
                                                list.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)("attribute.modifier.plus." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
                                                continue;
                                            }
                                            if (!(d0 < 0.0)) continue;
                                            list.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)("attribute.modifier.take." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), StatCollector.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
                                        }
                                    }
                                }
                                for (i = 0; i < list.size(); ++i) {
                                    String s2 = (String)list.get(i);
                                    int type = 0;
                                    if (s2.startsWith("ability* ")) {
                                        s2 = EnumChatFormatting.DARK_GREEN + s2.substring("ability".length());
                                        type = 1;
                                    } else if (s2.startsWith("weakness* ")) {
                                        s2 = EnumChatFormatting.GOLD + s2.substring("weakness".length());
                                        type = 2;
                                    }
                                    this.field_146289_q.func_78276_b(s2, j, k + i * this.field_146289_q.field_78288_b, 0);
                                    if (type <= 0) continue;
                                    final String s3 = s2;
                                    page.clickables.add(new Clickable(){

                                        @Override
                                        public void execute(int button) {
                                            Page page1 = null;
                                            for (Page page2 : ((GuiSuperheroesBook)GuiSuperheroesBook.this).book.pages) {
                                                if (!s3.substring(4).equals(page2.getTranslatedHeader())) continue;
                                                page1 = page2;
                                            }
                                            if (page1 != null) {
                                                int newCurrPage1 = (GuiSuperheroesBook.this.currPage + 1) * 2 - 1;
                                                int newCurrPage2 = (GuiSuperheroesBook.this.currPage + 1) * 2;
                                                if (page1.pageNumber % 2 == 0) {
                                                    GuiSuperheroesBook.this.currPage = page1.pageNumber / 2 - 1;
                                                } else {
                                                    GuiSuperheroesBook.this.currPage = page1.pageNumber / 2;
                                                }
                                                GuiSuperheroesBook.this.updateButtons();
                                            }
                                        }
                                    }.setBounds(new Rectangle(j + this.field_146289_q.func_78256_a("* "), k + i * this.field_146289_q.field_78288_b, this.field_146289_q.func_78256_a(s2) - this.field_146289_q.func_78256_a("* "), this.field_146289_q.field_78288_b)));
                                }
                            }
                        }
                    } else if (page instanceof PageSummary) {
                        PageSummary summary = (PageSummary)page;
                        List<Page> pages = summary.pages;
                        for (int i = 0; i < pages.size(); ++i) {
                            final Page page1 = pages.get(i);
                            String s2 = "* " + page1.getTranslatedHeader();
                            this.field_146289_q.func_78276_b(s2, j, k + this.field_146289_q.field_78288_b * i, 0);
                            page.clickables.add(new Clickable(){

                                @Override
                                public void execute(int button) {
                                    int newCurrPage1 = (GuiSuperheroesBook.this.currPage + 1) * 2 - 1;
                                    int newCurrPage2 = (GuiSuperheroesBook.this.currPage + 1) * 2;
                                    if (page1.pageNumber % 2 == 0) {
                                        GuiSuperheroesBook.this.currPage = page1.pageNumber / 2 - 1;
                                    } else {
                                        GuiSuperheroesBook.this.currPage = page1.pageNumber / 2;
                                    }
                                    GuiSuperheroesBook.this.updateButtons();
                                }
                            }.setBounds(new Rectangle(j + this.field_146289_q.func_78256_a("* "), k + i * this.field_146289_q.field_78288_b, this.field_146289_q.func_78256_a(s2) - this.field_146289_q.func_78256_a("* "), this.field_146289_q.field_78288_b)));
                        }
                    }
                } else {
                    String s2 = EnumChatFormatting.BOLD + StatCollector.func_74837_a((String)"book.metahumanLog.chapter", (Object[])new Object[]{this.book.chapters.indexOf(page) + 1});
                    this.field_146289_q.func_78276_b(s2, j, k, 0);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)j, (float)(k + 20), (float)0.0f);
                    GL11.glScalef((float)chapterTextScale, (float)chapterTextScale, (float)chapterTextScale);
                    this.field_146289_q.func_78279_b(EnumChatFormatting.BOLD + s1, 0, 0, cap, 0);
                    GL11.glPopMatrix();
                }
            }
            GL11.glDisable((int)3553);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (Clickable clickable : page.clickables) {
                for (Rectangle rect : clickable.bounds) {
                    if (mouseX < rect.x || mouseX >= rect.x + rect.width || mouseY < rect.y || mouseY >= rect.y + rect.height) continue;
                    this.func_73729_b(rect.x, rect.y + rect.height - 1, 0, 0, rect.width, 1);
                }
            }
            GL11.glEnable((int)3553);
        }
        this.field_146289_q.func_78264_a(unicode);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int texWidth, int texHeight) {
        float f = 1.0f / (float)texWidth;
        float f1 = 1.0f / (float)texHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), (double)this.field_73735_i, (double)((float)u * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)y, (double)this.field_73735_i, (double)((float)(u + width) * f), (double)((float)v * f1));
        tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, (double)((float)u * f), (double)((float)v * f1));
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean field_146151_o;

        public NextPageButton(int p_i1079_1_, int p_i1079_2_, int p_i1079_3_, boolean p_i1079_4_) {
            super(p_i1079_1_, p_i1079_2_, p_i1079_3_, 23, 13, "");
            this.field_146151_o = p_i1079_4_;
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                boolean flag = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                p_146112_1_.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 0;
                int l = 192;
                if (flag) {
                    k += 23;
                }
                if (!this.field_146151_o) {
                    l += 13;
                }
                this.drawTexturedModalRect(this.field_146128_h, this.field_146129_i, k, l, 23, 13, 512, 512);
            }
        }

        public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int texWidth, int texHeight) {
            float f = 1.0f / (float)texWidth;
            float f1 = 1.0f / (float)texHeight;
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)(y + height), (double)this.field_73735_i, (double)((float)u * f), (double)((float)(v + height) * f1));
            tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
            tessellator.func_78374_a((double)(x + width), (double)y, (double)this.field_73735_i, (double)((float)(u + width) * f), (double)((float)v * f1));
            tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, (double)((float)u * f), (double)((float)v * f1));
            tessellator.func_78381_a();
        }
    }
}

