/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.render;

import com.google.common.collect.Lists;
import fiskfille.heroes.common.helper.SHHelper;
import java.util.List;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Lightning {
    public List<Lightning> children = Lists.newArrayList();
    public Lightning parent;
    public float length;
    public float scale;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public Vec3 lightningColor;

    public Lightning(float f) {
        this(f, Vec3.func_72443_a((double)1.0, (double)1.0, (double)1.0));
    }

    public Lightning(float f, Vec3 color) {
        this.length = f;
        this.lightningColor = color;
    }

    public void onUpdate(World world) {
        if (this.parent == null) {
            Lightning lightning = SHHelper.createLightning(this.lightningColor, 0L, this.length).setScale(this.scale);
            this.children.clear();
            this.children.addAll(lightning.children);
            this.scale = lightning.scale;
            this.rotateAngleX = lightning.rotateAngleX;
            this.rotateAngleY = lightning.rotateAngleY;
            this.rotateAngleZ = lightning.rotateAngleZ;
        }
    }

    public Lightning addChild(Lightning child) {
        child.parent = this;
        child.lightningColor = this.lightningColor;
        this.children.add(child);
        return this;
    }

    public Lightning setRotation(float rotX, float rotY, float rotZ) {
        this.rotateAngleX = rotX;
        this.rotateAngleY = rotY;
        this.rotateAngleZ = rotZ;
        return this;
    }

    public Lightning setScale(float f) {
        this.scale = f;
        return this;
    }
}

