/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.trail;

import fiskfille.heroes.client.trail.SpeedTrailRenderer;
import fiskfille.heroes.client.trail.TrailRenderHandler;
import fiskfille.heroes.client.trail.TrailType;
import fiskfille.heroes.common.config.SHConfig;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.entity.EntitySpeedMirage;
import fiskfille.heroes.common.event.ClientEventHandler;
import fiskfille.heroes.common.helper.SHRenderHelper;
import fiskfille.heroes.common.helper.VectorHelper;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class SpeedTrailRendererLightnings
extends SpeedTrailRenderer {
    public static int lineWidth = 5;
    public static int innerLineWidth = 1;

    @Override
    public void renderTrail(EntityLivingBase entity, TrailType type) {
        if (entity instanceof EntityPlayer) {
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && (entity == Minecraft.func_71410_x().field_71439_g || entity instanceof EntitySpeedMirage && ((EntitySpeedMirage)entity).acquired == Minecraft.func_71410_x().field_71439_g)) {
                return;
            }
            if (SHConfig.vibrantLightningColors) {
                GL11.glBlendFunc((int)770, (int)32772);
            } else {
                GL11.glBlendFunc((int)770, (int)771);
            }
            GL11.glPushMatrix();
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GL11.glDepthMask((boolean)false);
            SHRenderHelper.setLighting(61680);
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            float partialTicks = ClientEventHandler.renderTick;
            double x = -SHRenderHelper.median(entity.field_70165_t, entity.field_70169_q) - (SHRenderHelper.median(player.field_70165_t, player.field_70169_q) - SHRenderHelper.median(entity.field_70165_t, entity.field_70169_q));
            double y = -SHRenderHelper.median(entity.field_70163_u, entity.field_70167_r) - (SHRenderHelper.median(player.field_70163_u, player.field_70167_r) - SHRenderHelper.median(entity.field_70163_u, entity.field_70167_r));
            double z = -SHRenderHelper.median(entity.field_70161_v, entity.field_70166_s) - (SHRenderHelper.median(player.field_70161_v, player.field_70166_s) - SHRenderHelper.median(entity.field_70161_v, entity.field_70166_s));
            GL11.glTranslatef((float)((float)x), (float)((float)y + (entity != player ? 1.62f : 0.0f)), (float)((float)z));
            int amountOfLightnings = 6;
            float lightningSpace = entity.field_70131_O / (float)amountOfLightnings;
            LinkedList<EntitySpeedMirage> list = TrailRenderHandler.getSpeedMiragesFromPlayer((EntityPlayer)entity);
            for (int j = 0; j < amountOfLightnings; ++j) {
                Vec3 add = Vec3.func_72443_a((double)0.0, (double)((float)j * lightningSpace), (double)0.0);
                float differ = 0.435f * (entity.field_70131_O / 1.8f);
                if (list.size() <= 0) continue;
                Vec3 firstStart = VectorHelper.add(list.getLast().getLightningPosVector(j).func_72444_a(list.getLast().func_70666_h(partialTicks)), entity.func_70666_h(partialTicks).func_72441_c(0.0, (double)(-1.62f * (player.field_70131_O / 1.8f)), 0.0));
                Vec3 firstEnd = list.getLast().getLightningPosVector(j);
                float alpha = 1.0f - ((float)list.getLast().progress + ClientEventHandler.renderTick) / 10.0f;
                this.drawLine(VectorHelper.add(firstStart, add.func_72441_c(0.0, (double)(list.getFirst().lightningFactor[j] * differ), 0.0)), VectorHelper.add(firstEnd, add.func_72441_c(0.0, (double)(list.getLast().lightningFactor[j] * differ), 0.0)), lineWidth, innerLineWidth, type, alpha, list.getLast().acquired, list.getLast(), j);
                for (int i = 0; i < list.size(); ++i) {
                    if (i >= list.size() - 1) continue;
                    EntitySpeedMirage speedMirage = list.get(i);
                    EntitySpeedMirage speedMirage2 = list.get(i + 1);
                    Vec3 start = speedMirage.getLightningPosVector(j);
                    Vec3 end = speedMirage2.getLightningPosVector(j);
                    float progress = 1.0f - ((float)speedMirage.progress + ClientEventHandler.renderTick) / 10.0f;
                    this.drawLine(VectorHelper.add(start, add.func_72441_c(0.0, (double)(speedMirage.lightningFactor[j] * differ), 0.0)), VectorHelper.add(end, add.func_72441_c(0.0, (double)(speedMirage2.lightningFactor[j] * differ), 0.0)), 5.0f, 1.0f, type, progress, speedMirage.acquired, speedMirage, j);
                }
            }
            SHRenderHelper.resetLighting();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glPopMatrix();
            if (SHConfig.vibrantLightningColors) {
                GL11.glBlendFunc((int)770, (int)771);
            }
        }
    }

    @Override
    public void preRenderSpeedMirage(EntitySpeedMirage entity, TrailType type) {
    }

    @Override
    public boolean shouldRenderSpeedMirage(EntitySpeedMirage entity, TrailType type) {
        return false;
    }

    public TrailType getTrailType(EntityPlayer player, EntitySpeedMirage entity, TrailType origType, int index) {
        if (SHData.getInt(player, 31) > 0) {
            return TrailType.lightnings_blue;
        }
        return origType;
    }

    public void drawLine(Vec3 start, Vec3 end, float lineWidth, float innerLineWidth, TrailType type, float alpha, EntityPlayer player, EntitySpeedMirage mirage, int lightningNumber) {
        if (start == null || end == null) {
            return;
        }
        if (player != null) {
            type = this.getTrailType(player, mirage, type, lightningNumber);
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        if (lineWidth > 0.0f) {
            GL11.glLineWidth((float)lineWidth);
            tessellator.func_78371_b(3);
            tessellator.func_78369_a((float)type.getTrailColor().field_72450_a, (float)type.getTrailColor().field_72448_b, (float)type.getTrailColor().field_72449_c, alpha);
            tessellator.func_78377_a(start.field_72450_a, start.field_72448_b, start.field_72449_c);
            tessellator.func_78377_a(end.field_72450_a, end.field_72448_b, end.field_72449_c);
            tessellator.func_78381_a();
        }
        if (innerLineWidth > 0.0f) {
            GL11.glLineWidth((float)innerLineWidth);
            tessellator.func_78371_b(3);
            tessellator.func_78369_a(1.0f, 1.0f, 1.0f, MathHelper.func_76131_a((float)(alpha - 0.2f), (float)0.0f, (float)1.0f));
            tessellator.func_78377_a(start.field_72450_a, start.field_72448_b, start.field_72449_c);
            tessellator.func_78377_a(end.field_72450_a, end.field_72448_b, end.field_72449_c);
            tessellator.func_78381_a();
        }
    }
}

