/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.trail;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import fiskfille.heroes.client.trail.SpeedTrailRenderer;
import fiskfille.heroes.client.trail.TrailType;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.entity.EntitySpeedMirage;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.helper.SpeedsterHelper;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

public class TrailRenderHandler {
    public static HashMap<EntityPlayer, Float> traveledBlocksMap = new HashMap();
    public static HashMap<EntityPlayer, Vec3> lastPosMap = new HashMap();
    public static HashMap<EntityPlayer, LinkedList<EntitySpeedMirage>> trailDataMap = new HashMap();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START && SHHelper.canRunSuperSpeed(event.player) && SHData.getBoolean(event.player, 0) && SHData.getInt(event.player, 1) >= 0) {
            if (TrailRenderHandler.isPlayerMovingClientSide(event.player)) {
                EntityPlayer player = event.player;
                if (!traveledBlocksMap.containsKey(player)) {
                    traveledBlocksMap.put(player, Float.valueOf(0.0f));
                }
                if (!lastPosMap.containsKey(player)) {
                    lastPosMap.put(player, player.func_70666_h(1.0f));
                }
                if (!trailDataMap.containsKey(player)) {
                    trailDataMap.put(player, new LinkedList());
                }
                Vec3 lastPos = lastPosMap.get(player);
                float distancedWalked = traveledBlocksMap.get(player).floatValue() + (float)player.func_70011_f(lastPos.field_72450_a, lastPos.field_72448_b, lastPos.field_72449_c);
                if (distancedWalked >= player.field_70130_N + player.field_70130_N / 10.0f) {
                    EntitySpeedMirage esm = new EntitySpeedMirage(player.field_70170_p, player);
                    player.field_70170_p.func_72838_d((Entity)esm);
                    this.addSpeedMirageToList(player, esm);
                    distancedWalked = 0.0f;
                }
                traveledBlocksMap.put(player, Float.valueOf(distancedWalked));
            }
            lastPosMap.put(event.player, event.player.func_70666_h(1.0f));
        }
    }

    public static boolean isPlayerMovingClientSide(EntityPlayer player) {
        return TrailRenderHandler.areVec3Equal(player.func_70666_h(1.0f), lastPosMap.get(player));
    }

    public static boolean areVec3Equal(Vec3 vec1, Vec3 vec2) {
        if (vec1 == null || vec2 == null) {
            return false;
        }
        return vec1.field_72450_a != vec2.field_72450_a || vec1.field_72448_b != vec2.field_72448_b || vec1.field_72449_c != vec2.field_72449_c;
    }

    public void addSpeedMirageToList(EntityPlayer player, EntitySpeedMirage e) {
        LinkedList<EntitySpeedMirage> list = trailDataMap.get(player);
        if (list.size() >= 10) {
            list.remove(0);
            list.add(e);
        } else {
            list.add(e);
        }
        trailDataMap.put(player, list);
    }

    public static LinkedList<EntitySpeedMirage> getSpeedMiragesFromPlayer(EntityPlayer player) {
        if (trailDataMap.get(player) == null) {
            trailDataMap.put(player, new LinkedList());
        }
        return trailDataMap.get(player);
    }

    @SubscribeEvent
    public void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.entityPlayer;
        if (SHHelper.canRunSuperSpeed(player) && SHData.getBoolean(player, 0) && SHData.getInt(player, 1) >= 0) {
            TrailType trail = SpeedsterHelper.getTrailType(player);
            GL11.glPushMatrix();
            trail.getSpeedTrailRenderer().renderTrail((EntityLivingBase)player, trail);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void renderEntity(RenderLivingEvent.Pre event) {
        if (event.entity instanceof EntitySpeedMirage) {
            EntitySpeedMirage entity = (EntitySpeedMirage)event.entity;
            SpeedTrailRenderer renderer = entity.trail.getSpeedTrailRenderer();
            if (!renderer.shouldRenderSpeedMirage(entity, entity.trail)) {
                event.setCanceled(true);
                return;
            }
            renderer.preRenderSpeedMirage(entity, entity.trail);
        }
    }
}

