/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.block;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.network.PacketTreadmill;
import fiskfille.heroes.common.network.SHNetworkManager;
import fiskfille.heroes.common.tileentity.TileEntityTreadmill;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTreadmill
extends BlockDirectional
implements ITileEntityProvider {
    public static final int[][] directions = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};

    public BlockTreadmill() {
        super(Material.field_151573_f);
        this.setHarvestLevel(null, 0);
        this.func_149672_a(field_149777_j);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149716_u() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.setBounds(world.func_72805_g(x, y, z));
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.setBounds(world.func_72805_g(x, y, z));
    }

    public void setBounds(int metadata) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.32f, 1.0f);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int metadata = world.func_72805_g(x, y, z);
        int direction = BlockTreadmill.func_149895_l((int)metadata);
        if (BlockTreadmill.isBlockFrontOfTreadmill(metadata)) {
            if (world.func_147439_a(x - directions[direction][0], y, z - directions[direction][1]) != this) {
                world.func_147468_f(x, y, z);
            }
        } else if (world.func_147439_a(x + directions[direction][0], y, z + directions[direction][1]) != this) {
            world.func_147468_f(x, y, z);
            if (!world.field_72995_K) {
                this.func_149697_b(world, x, y, z, metadata, 0);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityTreadmill tile;
        int metadata = world.func_72805_g(x, y, z);
        int direction = BlockTreadmill.func_149895_l((int)metadata);
        if (BlockTreadmill.isBlockFrontOfTreadmill(metadata)) {
            x -= directions[direction][0];
            z -= directions[direction][1];
        }
        if ((tile = (TileEntityTreadmill)world.func_147438_o(x, y, z)) != null && SHHelper.getHero(player) != null && SHHelper.getHero(player).hasAbility(Ability.superSpeed) && tile.playerId == -1) {
            SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketTreadmill(player, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 0));
            return true;
        }
        return false;
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        return BlockTreadmill.isBlockFrontOfTreadmill(metadata) ? Item.func_150899_d((int)0) : super.func_149650_a(metadata, rand, fortune);
    }

    public static boolean isBlockFrontOfTreadmill(int metadata) {
        return (metadata & 8) != 0;
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float dropChance, int fortune) {
        if (!BlockTreadmill.isBlockFrontOfTreadmill(metadata)) {
            super.func_149690_a(world, x, y, z, metadata, dropChance, 0);
        }
    }

    public int func_149656_h() {
        return 1;
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        int i1;
        if (player.field_71075_bZ.field_75098_d && BlockTreadmill.isBlockFrontOfTreadmill(metadata) && world.func_147439_a(x -= directions[i1 = BlockTreadmill.func_149895_l((int)metadata)][0], y, z -= directions[i1][1]) == this) {
            world.func_147468_f(x, y, z);
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityTreadmill();
    }

    public void func_149651_a(IIconRegister par1IIconRegister) {
        this.field_149761_L = par1IIconRegister.func_94245_a("iron_block");
    }
}

