/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.config;

import fiskfille.heroes.SuperHeroesAPI;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;

public class SHConfig {
    public static final String CATEGORY_SERVER = "Server";
    public static final String CATEGORY_CLIENT = "Client";
    public static boolean clientDurabilityScaledProtection;
    public static boolean clientHeatGunFire;
    public static boolean clientGeomancerExplosions;
    public static String[] clientUnphasableBlocks;
    public static boolean clientHeatVisionGriefing;
    public static boolean clientCanaryCryGriefing;
    public static boolean durabilityScaledProtection;
    public static boolean heatGunFire;
    public static boolean geomancerExplosions;
    public static String[] unphasableBlocks;
    public static boolean heatVisionGriefing;
    public static boolean canaryCryGriefing;
    public static boolean alternateLightningRendering;
    public static boolean vibrantLightningColors;
    public static boolean hudAlignLeft;
    public static boolean hudAlignTop;
    public static boolean quiverHotbarAlignLeft;
    public static boolean useMiles;
    public static Configuration configFile;

    public static void load(Configuration config) {
        configFile = config;
        clientDurabilityScaledProtection = configFile.getBoolean("Durability-Scaled Protection", CATEGORY_SERVER, false, "Whether the protection superhero armors provide will decrease as durability goes down.");
        clientHeatGunFire = configFile.getBoolean("Heat Gun Fire", CATEGORY_SERVER, true, "If disabled, the Heat Gun will not set blocks on fire.");
        clientGeomancerExplosions = configFile.getBoolean("Geomancer Terrain Damage", CATEGORY_SERVER, true, "If disabled, Geomancer's eruption ability will not cause any terrain damage.");
        clientUnphasableBlocks = configFile.getStringList("Unphasable Blocks", CATEGORY_SERVER, new String[]{"minecraft:bedrock", "fiskheroes:subatomic_particle_shell", "fiskheroes:subatomic_particle_core"}, "Array of blocks that can't be phased through. (Format: modid:blockid OR modid:blockid@metadata)");
        clientHeatVisionGriefing = configFile.getBoolean("Heat Vision Griefing", CATEGORY_SERVER, true, "If disabled, Heat Vision will not smelt block and i.e. turn sand to glass.");
        clientCanaryCryGriefing = configFile.getBoolean("Canary Cry Griefing", CATEGORY_SERVER, true, "If disabled, Canary Cry will not shatter glass.");
        vibrantLightningColors = configFile.getBoolean("Vibrant Lightning Colors", CATEGORY_CLIENT, true, "If enabled, speedster lightning will be rendered with more vibrant colors. May result in worse color blending in daylight.");
        hudAlignLeft = configFile.getBoolean("HUD Align Left", CATEGORY_CLIENT, false, "If enabled, the Heads Up Display will be aligned to the left of your screen.");
        hudAlignTop = configFile.getBoolean("HUD Align Top", CATEGORY_CLIENT, true, "If enabled, the Heads Up Display will be aligned to the top of your screen.");
        quiverHotbarAlignLeft = configFile.getBoolean("Quiver Hotbar Align Left", CATEGORY_CLIENT, false, "If enabled, the quiver hotbar will be aligned to the left of your screen.");
        useMiles = configFile.getBoolean("Use Miles", CATEGORY_CLIENT, false, "If enabled, speed will be displayed using miles per hour rather than kilometers per hour.");
        SHConfig.syncServerOptions();
    }

    public static void syncServerOptions() {
        durabilityScaledProtection = clientDurabilityScaledProtection;
        heatGunFire = clientHeatGunFire;
        geomancerExplosions = clientGeomancerExplosions;
        unphasableBlocks = clientUnphasableBlocks;
        heatVisionGriefing = clientHeatVisionGriefing;
        canaryCryGriefing = clientCanaryCryGriefing;
        SuperHeroesAPI.getUnphasables().clear();
        for (String s : unphasableBlocks) {
            Block block = Block.func_149684_b((String)s);
            if (block == null) continue;
            SuperHeroesAPI.registerUnphasable(block);
        }
    }
}

