/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.data;

import com.google.common.collect.Lists;
import fiskfille.heroes.common.data.ArrowInEntityData;
import fiskfille.heroes.common.entity.arrow.EntityTrickArrow;
import fiskfille.heroes.common.helper.TemperatureHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class SHEntityData
implements IExtendedEntityProperties {
    public static final String IDENTIFIER = "FiskHeroesEntity";
    public List<ArrowInEntityData> arrowsInEntity = Lists.newArrayList();
    public float temperature = 36.0f;
    private EntityLivingBase living;

    public static SHEntityData getData(EntityLivingBase entity) {
        return (SHEntityData)entity.getExtendedProperties(IDENTIFIER);
    }

    public void onUpdate() {
        TemperatureHelper.updateTemperature(this.living);
        for (int i = 0; i < this.arrowsInEntity.size(); ++i) {
            EntityTrickArrow arrow;
            ArrowInEntityData data = this.arrowsInEntity.get(i);
            if (data == null || (arrow = data.arrowEntity) == null) continue;
            arrow.field_70165_t = arrow.field_70169_q = this.living.field_70165_t;
            arrow.field_70163_u = arrow.field_70167_r = this.living.field_70163_u;
            arrow.field_70161_v = arrow.field_70166_s = this.living.field_70161_v;
            arrow.inEntityUpdate(this.living);
            if (arrow.func_70089_S()) continue;
            this.arrowsInEntity.remove(data);
        }
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74757_a("Saved", true);
        nbttagcompound.func_74776_a("Temperature", this.temperature);
        if (!this.arrowsInEntity.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (ArrowInEntityData data : this.arrowsInEntity) {
                if (data == null) continue;
                nbttaglist.func_74742_a((NBTBase)data.writeToNBT(new NBTTagCompound()));
            }
            nbttagcompound.func_74782_a("ArrowsInEntity", (NBTBase)nbttaglist);
        }
        nbt.func_74782_a(IDENTIFIER, (NBTBase)nbttagcompound);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound = nbt.func_74775_l(IDENTIFIER);
        if (nbttagcompound.func_74767_n("Saved")) {
            this.temperature = nbttagcompound.func_74760_g("Temperature");
            if (nbt.func_150297_b("ArrowsInEntity", 9)) {
                NBTTagList nbttaglist = nbt.func_150295_c("ArrowsInEntity", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                    ArrowInEntityData data = new ArrowInEntityData(null);
                    data.readFromNBT(nbttagcompound1);
                }
            }
        }
    }

    public void init(Entity entity, World world) {
        if (entity instanceof EntityLivingBase) {
            this.living = (EntityLivingBase)entity;
        }
    }
}

