/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.entity;

import fiskfille.heroes.common.damagesource.ModDamageSources;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.hero.HeroManager;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityCactus
extends EntityGolem {
    public IEntitySelector enemySelector = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            if (entity instanceof EntityPlayer) {
                return SHHelper.getHero((EntityPlayer)entity) != HeroManager.heroSenorCactus;
            }
            return entity instanceof IMob || !(entity instanceof EntityAnimal) && !(entity instanceof EntityGolem);
        }
    };
    public int idlingTick = 0;

    public EntityCactus(World world) {
        super(world);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, this.enemySelector));
        this.setCactusSize(1 + this.field_70146_Z.nextInt(3));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected void func_82167_n(Entity entity) {
        if (this.enemySelector.func_82704_a(entity) && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        super.func_82167_n(entity);
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected float getAttackStrength() {
        return Math.min(this.getCactusSize(), 3) * 2;
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        Block block;
        super.func_70636_d();
        float range = 0.3f;
        this.func_70105_a(1.0f, this.getCactusSize());
        if (this.func_70026_G() && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 5 == 0) {
            this.func_70691_i(1.0f);
        }
        for (EntityLivingBase entity : this.field_70170_p.func_82733_a(EntityLivingBase.class, this.func_70046_E().func_72314_b((double)range, (double)range, (double)range), this.enemySelector)) {
            entity.func_70097_a(ModDamageSources.causeSpikeDamage((Entity)this), this.getAttackStrength());
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (block = this.field_70170_p.func_147439_a(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), k = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
            this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g(i, j, k), this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.field_70121_D.field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
        if (this.func_70777_m() == null) {
            if (++this.idlingTick > 600 && !this.field_70170_p.field_72995_K) {
                int z;
                int y;
                int x = MathHelper.func_76128_c((double)this.field_70165_t);
                if (Blocks.field_150434_aF.func_149718_j(this.field_70170_p, x, y = MathHelper.func_76128_c((double)this.field_70163_u), z = MathHelper.func_76128_c((double)this.field_70161_v))) {
                    for (int i2 = 0; i2 < this.getCactusSize(); ++i2) {
                        this.field_70170_p.func_147449_b(x, y + i2, z, Blocks.field_150434_aF);
                    }
                    this.func_70106_y();
                } else {
                    this.func_70606_j(0.0f);
                }
            }
        } else {
            this.idlingTick = 0;
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("Size", this.getCactusSize());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setCactusSize(nbttagcompound.func_74762_e("Size"));
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return null;
    }

    protected String func_70673_aS() {
        return null;
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.irongolem.walk", 1.0f, 1.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.getCactusSize() == 1) {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150434_aF), this.getCactusSize());
        } else if (this.getCactusSize() > 3) {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150434_aF), this.getCactusSize() - 3);
        }
    }

    public void func_70106_y() {
        int i = this.getCactusSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            for (int j = 0; j < Math.min(i, 3); ++j) {
                float f = (float)(j % 2) - 0.5f;
                float f1 = (float)(j / 2) - 0.5f;
                EntityCactus entity = new EntityCactus(this.field_70170_p);
                entity.setCactusSize(1);
                entity.setDonatorSummoned(this.isDonatorSummoned());
                entity.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entity);
            }
        }
        super.func_70106_y();
    }

    public boolean func_70601_bi() {
        return false;
    }

    public int getCactusSize() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void setCactusSize(int size) {
        this.field_70180_af.func_75692_b(16, (Object)size);
        this.func_70105_a(1.0f, size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(Math.min(size, 3) * 5));
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = Math.min(size, 3);
    }

    public boolean isDonatorSummoned() {
        return this.field_70180_af.func_75683_a(17) != 0;
    }

    public void setDonatorSummoned(boolean flag) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)(flag ? 1 : 0)));
    }
}

