/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.entity.arrow;

import fiskfille.heroes.common.entity.EntityGrapplingHookCable;
import fiskfille.heroes.common.entity.arrow.EntityTrickArrow;
import fiskfille.heroes.common.item.ModItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityGrapplingHookArrow
extends EntityTrickArrow {
    public EntityGrapplingHookArrow(World world) {
        super(world);
        this.field_70158_ak = true;
        this.field_70155_l = 10.0;
    }

    public EntityGrapplingHookArrow(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.field_70158_ak = true;
        this.field_70155_l = 10.0;
    }

    public EntityGrapplingHookArrow(World world, EntityLivingBase shooter, float velocity) {
        super(world, shooter, velocity);
        this.field_70158_ak = true;
        this.field_70155_l = 10.0;
    }

    @Override
    public float getVelocityFactor() {
        return 1.5f;
    }

    @Override
    protected float getGravityVelocity() {
        return 0.05f;
    }

    @Override
    protected void onImpactEntity(MovingObjectPosition mop) {
        if (mop.field_72308_g != null && mop.field_72308_g != this.getShooter()) {
            this.field_70250_c = this.getShooter();
            if (this.func_70027_ad() && this.canTargetEntity(mop.field_72308_g)) {
                mop.field_72308_g.func_70015_d(5);
            }
            if (mop.field_72308_g instanceof EntityLivingBase && !(mop.field_72308_g instanceof EntityEnderman)) {
                this.handlePostDamageEffects((EntityLivingBase)mop.field_72308_g);
                if (this.field_70250_c instanceof EntityPlayerMP && mop.field_72308_g != this.field_70250_c && mop.field_72308_g instanceof EntityPlayer) {
                    ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                }
            }
            this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.canTargetEntity(mop.field_72308_g)) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public void inEntityUpdate(EntityLivingBase living) {
        super.inEntityUpdate(living);
        if (this.getShooter() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.getShooter();
            if (!this.getIsCableCut()) {
                if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() != ModItems.compoundBow || player.func_70694_bm() == null || player.field_70733_aJ > 0.0f) {
                    this.setIsCableCut(true);
                    player.field_70170_p.func_72956_a((Entity)player, "mob.sheep.shear", 1.0f, 0.8f);
                }
                if (this.field_70169_q == this.field_70165_t && this.field_70167_r == this.field_70163_u && this.field_70166_s == this.field_70161_v) {
                    player.field_70143_R = 0.0f;
                    player.field_70159_w += (this.field_70165_t - player.field_70165_t) / 60.0;
                    player.field_70181_x += (this.field_70163_u - player.field_70163_u) / 60.0;
                    player.field_70179_y += (this.field_70161_v - player.field_70161_v) / 60.0;
                    if (player.func_70032_d((Entity)living) > 10.0f) {
                        living.field_70143_R = 0.0f;
                        living.field_70159_w += (player.field_70165_t - this.field_70165_t) / 100.0;
                        living.field_70181_x += (player.field_70163_u - this.field_70163_u) / 100.0;
                        living.field_70179_y += (player.field_70161_v - this.field_70161_v) / 100.0;
                    }
                }
                this.field_70170_p.func_72838_d((Entity)new EntityGrapplingHookCable(this.field_70170_p, living, player));
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    public boolean getIsCableCut() {
        return this.field_70180_af.func_75683_a(19) > 0;
    }

    public void setIsCableCut(boolean b) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)(b ? 1 : 0)));
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setIsCableCut(compound.func_74767_n("IsCableCut"));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("IsCableCut", this.getIsCableCut());
    }
}

