/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.entity.batgadget;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.heroes.client.particle.SHParticleType;
import fiskfille.heroes.client.particle.SHParticles;
import fiskfille.heroes.common.block.ModBlocks;
import fiskfille.heroes.common.damagesource.ModDamageSources;
import fiskfille.heroes.common.helper.TemperatureHelper;
import fiskfille.heroes.common.tileentity.TileEntityIceLayer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityFreezeGrenade
extends EntityThrowable {
    public EntityFreezeGrenade(World world) {
        super(world);
        this.field_70145_X = false;
    }

    public EntityFreezeGrenade(World world, EntityLivingBase entity) {
        super(world, entity);
        this.field_70145_X = false;
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected float func_70182_d() {
        return 1.25f;
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            double d7;
            double d6;
            double d5;
            int z;
            int y;
            int x;
            float explosionSize;
            ArrayList affectedBlockPositions = Lists.newArrayList();
            float f = explosionSize = 3.0f;
            HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
            int max = 16;
            for (x = 0; x < max; ++x) {
                for (y = 0; y < max; ++y) {
                    for (z = 0; z < max; ++z) {
                        if (x != 0 && x != max - 1 && y != 0 && y != max - 1 && z != 0 && z != max - 1) continue;
                        double d0 = (float)x / ((float)max - 1.0f) * 2.0f - 1.0f;
                        double d1 = (float)y / ((float)max - 1.0f) * 2.0f - 1.0f;
                        double d2 = (float)z / ((float)max - 1.0f) * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        d5 = this.field_70165_t;
                        d6 = this.field_70163_u;
                        d7 = this.field_70161_v;
                        float f2 = 0.3f;
                        for (float f1 = explosionSize * (0.7f + this.field_70146_Z.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                            int l1;
                            int k1;
                            int j1 = MathHelper.func_76128_c((double)d5);
                            Block block = this.field_70170_p.func_147439_a(j1, k1 = MathHelper.func_76128_c((double)d6), l1 = MathHelper.func_76128_c((double)d7));
                            if (block.func_149688_o() != Material.field_151579_a && !block.isReplaceable((IBlockAccess)this.field_70170_p, j1, k1, l1) && block.func_149662_c() && block != ModBlocks.iceLayer) {
                                f1 = 0.0f;
                            }
                            if (f1 > 0.0f) {
                                hashset.add(new ChunkPosition(j1, k1, l1));
                            }
                            d5 += d0 * (double)f2;
                            d6 += d1 * (double)f2;
                            d7 += d2 * (double)f2;
                        }
                    }
                }
            }
            affectedBlockPositions.addAll(hashset);
            x = MathHelper.func_76128_c((double)(this.field_70165_t - (double)(explosionSize *= 2.0f) - 1.0));
            y = MathHelper.func_76128_c((double)(this.field_70165_t + (double)explosionSize + 1.0));
            z = MathHelper.func_76128_c((double)(this.field_70163_u - (double)explosionSize - 1.0));
            int i2 = MathHelper.func_76128_c((double)(this.field_70163_u + (double)explosionSize + 1.0));
            int l = MathHelper.func_76128_c((double)(this.field_70161_v - (double)explosionSize - 1.0));
            int j2 = MathHelper.func_76128_c((double)(this.field_70161_v + (double)explosionSize + 1.0));
            List list = this.field_70170_p.func_72839_b((Entity)this.func_85052_h(), AxisAlignedBB.func_72330_a((double)x, (double)z, (double)l, (double)y, (double)i2, (double)j2));
            Vec3 vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            for (ChunkPosition pos : affectedBlockPositions) {
                int x1 = pos.field_151329_a;
                int y1 = pos.field_151327_b;
                int z1 = pos.field_151328_c;
                this.tryPlaceIce(x1, y1 + 1, z1, 0);
                this.tryPlaceIce(x1, y1 - 1, z1, 1);
                this.tryPlaceIce(x1, y1, z1 + 1, 2);
                this.tryPlaceIce(x1, y1, z1 - 1, 3);
                this.tryPlaceIce(x1 + 1, y1, z1, 4);
                this.tryPlaceIce(x1 - 1, y1, z1, 5);
            }
            for (int i1 = 0; i1 < list.size(); ++i1) {
                double d9;
                Entity entity = (Entity)list.get(i1);
                double d4 = entity.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) / (double)explosionSize;
                if (!(d4 <= 1.0) || (d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.field_70165_t) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - this.field_70163_u) * d6 + (d7 = entity.field_70161_v - this.field_70161_v) * d7))) == 0.0) continue;
                d5 /= d9;
                d6 /= d9;
                d7 /= d9;
                double d10 = this.field_70170_p.func_72842_a(vec3, entity.field_70121_D);
                double d11 = (1.0 - d4) * d10;
                if (!(entity instanceof EntityHanging)) {
                    entity.func_70097_a(ModDamageSources.causeFreezeDamage((Entity)this.func_85052_h()), (float)((int)((d11 * d11 + d11) / 2.0 * 8.0 * (double)explosionSize + 1.0)));
                }
                if (entity instanceof EntityLivingBase) {
                    float f1 = (float)((int)((d11 * d11 + d11) / 2.0 * 8.0 * (double)explosionSize + 1.0)) * 10.0f;
                    TemperatureHelper.setTemperatureWithoutNotify((EntityLivingBase)entity, TemperatureHelper.getTemperature((EntityLivingBase)entity) - f1);
                }
                double d8 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d11);
                entity.field_70159_w += d5 * d8;
                entity.field_70181_x += d6 * d8;
                entity.field_70179_y += d7 * d8;
            }
            this.func_85030_a("fiskheroes:ice_charge", 1.5f, 0.9f + this.field_70146_Z.nextFloat() * 0.3f);
            this.func_85030_a("random.explode", 2.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            explosionSize = f;
            Iterator iterator = affectedBlockPositions.iterator();
            if (this.field_70170_p.field_72995_K) {
                while (iterator.hasNext()) {
                    ChunkPosition pos = (ChunkPosition)iterator.next();
                    x = pos.field_151329_a;
                    y = pos.field_151327_b;
                    z = pos.field_151328_c;
                    Block block = this.field_70170_p.func_147439_a(x, y, z);
                    double d0 = (float)x + this.field_70146_Z.nextFloat();
                    double d1 = (float)y + this.field_70146_Z.nextFloat();
                    double d2 = (float)z + this.field_70146_Z.nextFloat();
                    double motX = d0 - this.field_70165_t;
                    double motY = d1 - this.field_70163_u;
                    double motZ = d2 - this.field_70161_v;
                    double vel = MathHelper.func_76133_a((double)(motX * motX + motY * motY + motZ * motZ));
                    motX /= vel;
                    motY /= vel;
                    motZ /= vel;
                    double motionMultiplier = 0.5 / (vel / (double)explosionSize + 0.1);
                    this.spawnParticle((d0 + this.field_70165_t) / 2.0, (d1 + this.field_70163_u) / 2.0, (d2 + this.field_70161_v) / 2.0, (motX *= (motionMultiplier *= (double)(this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat() * 1.0f + 0.3f))) * 2.0, (motY *= motionMultiplier) * 2.0, (motZ *= motionMultiplier) * 2.0);
                }
            }
            this.func_70106_y();
        }
    }

    public void tryPlaceIce(int x, int y, int z, int metadata) {
        int x1 = x;
        int y1 = y;
        int z1 = z;
        if (metadata == 0) {
            --y1;
        } else if (metadata == 1) {
            ++y1;
        } else if (metadata == 2) {
            --z1;
        } else if (metadata == 3) {
            ++z1;
        } else if (metadata == 4) {
            --x1;
        } else if (metadata == 5) {
            ++x1;
        }
        if (!this.field_70170_p.field_72995_K) {
            Block block = this.field_70170_p.func_147439_a(x, y, z);
            Block block1 = this.field_70170_p.func_147439_a(x1, y1, z1);
            boolean canPlaceLayer = true;
            List list = this.field_70170_p.func_72839_b(null, AxisAlignedBB.func_72330_a((double)x1, (double)y1, (double)z1, (double)(x1 + 1), (double)(y1 + 1), (double)(z1 + 1)));
            for (Entity entity : list) {
                if (!(entity instanceof EntityHanging)) continue;
                canPlaceLayer = false;
                break;
            }
            if (canPlaceLayer) {
                TileEntityIceLayer tile;
                if (block1 == Blocks.field_150355_j || block1 == Blocks.field_150358_i) {
                    this.field_70170_p.func_147449_b(x1, y1, z1, Blocks.field_150432_aD);
                } else if (block1 == Blocks.field_150353_l || block1 == Blocks.field_150356_k) {
                    this.field_70170_p.func_147449_b(x1, y1, z1, Blocks.field_150343_Z);
                } else if (block1 == ModBlocks.iceLayer) {
                    tile = (TileEntityIceLayer)this.field_70170_p.func_147438_o(x1, y1, z1);
                    if (tile != null) {
                        tile.setThickness(MathHelper.func_76125_a((int)(tile.thickness + this.field_70146_Z.nextInt(8)), (int)1, (int)64));
                    }
                } else if (!this.field_70170_p.func_147437_c(x, y, z) && block != ModBlocks.iceLayer && block1.isReplaceable((IBlockAccess)this.field_70170_p, x1, y1, z1) && block.func_149688_o().func_76230_c()) {
                    this.field_70170_p.func_147465_d(x1, y1, z1, ModBlocks.iceLayer, metadata, 2);
                    tile = (TileEntityIceLayer)this.field_70170_p.func_147438_o(x1, y1, z1);
                    if (tile != null) {
                        tile.thickness = Math.max(this.field_70146_Z.nextInt(8), 1);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(double x, double y, double z, double motionX, double motionY, double motionZ) {
        SHParticles.spawnParticle(SHParticleType.FREEZE_SMOKE, x, y, z, motionX, motionY, motionZ);
    }
}

