/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.event;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.heroes.SHReflection;
import fiskfille.heroes.SuperHeroes;
import fiskfille.heroes.asm.ASMHooks;
import fiskfille.heroes.client.particle.SHParticleType;
import fiskfille.heroes.client.particle.SHParticles;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.achievement.SHAchievements;
import fiskfille.heroes.common.block.ModBlocks;
import fiskfille.heroes.common.config.SHConfig;
import fiskfille.heroes.common.damagesource.ModDamageSources;
import fiskfille.heroes.common.data.DataManager;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.data.SHEntityData;
import fiskfille.heroes.common.data.SHPlayerData;
import fiskfille.heroes.common.entity.EntityCanaryCry;
import fiskfille.heroes.common.entity.EntityHeatVision;
import fiskfille.heroes.common.entity.arrow.EntityGrapplingHookArrow;
import fiskfille.heroes.common.entity.arrow.EntityTrickArrow;
import fiskfille.heroes.common.entity.attribute.SHAttributes;
import fiskfille.heroes.common.entity.batgadget.EntityBatarang;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.helper.SpeedsterHelper;
import fiskfille.heroes.common.helper.TemperatureHelper;
import fiskfille.heroes.common.helper.VectorHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.hero.HeroCaptainAmerica;
import fiskfille.heroes.common.hero.HeroDeadpool;
import fiskfille.heroes.common.hero.ISizeManipulation;
import fiskfille.heroes.common.item.IDualItem;
import fiskfille.heroes.common.item.IPunchWeapon;
import fiskfille.heroes.common.item.ModItems;
import fiskfille.heroes.common.item.armor.ItemHeroArmor;
import fiskfille.heroes.common.motion.FlightManager;
import fiskfille.heroes.common.network.PacketBroadcastState;
import fiskfille.heroes.common.network.PacketSyncHasItem;
import fiskfille.heroes.common.network.SHNetworkManager;
import fiskfille.heroes.common.time.TimeHelper;
import fiskfille.heroes.common.weakness.Weakness;
import fiskfille.heroes.common.world.ModDimensions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;

public class CommonEventHandler {
    private List<EntityPlayer> playersToSync = new ArrayList<EntityPlayer>();
    private List<EntityPlayer> prevHasShield = new LinkedList<EntityPlayer>();
    private List<EntityPlayer> prevHasDeadpoolSwords = new LinkedList<EntityPlayer>();

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        World world = entity.field_70170_p;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!world.field_72995_K) {
                this.playersToSync.add(player);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!player.field_70170_p.field_72995_K && this.playersToSync.size() > 0 && this.playersToSync.contains(player)) {
                DataManager.updatePlayerWithServerInfo(player);
                this.playersToSync.remove(player);
            }
        }
        if (entity.field_71093_bK == ModDimensions.QUANTUM_REALM_ID) {
            if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75100_b) {
                entity.field_70181_x += (double)0.075f;
            }
            if (entity.field_70163_u <= 0.0) {
                entity.field_70163_u = 255.0;
            }
            if (entity.field_70163_u >= 256.0) {
                entity.field_70163_u = 1.0;
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        for (Entity entity : world.field_72996_f) {
            if (event.phase != TickEvent.Phase.START || entity.field_71093_bK != ModDimensions.QUANTUM_REALM_ID) continue;
            if (entity.field_70163_u <= 0.0) {
                entity.field_70163_u = 256.0;
                continue;
            }
            if (!(entity.field_70163_u >= 256.0)) continue;
            entity.field_70163_u = 1.0;
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.entity instanceof EntityPlayer) {
            ItemStack[] aitemstack;
            EntityPlayer player = (EntityPlayer)event.entity;
            float height = 0.0f;
            ItemStack helmet = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack legs = player.func_82169_q(1);
            ItemStack feet = player.func_82169_q(0);
            for (ItemStack itemstack : aitemstack = new ItemStack[]{helmet, chest, legs, feet}) {
                Multimap multimap;
                if (itemstack == helmet && helmet != null && chest != null && helmet.func_77973_b() instanceof ItemHeroArmor && SHHelper.getHeroFromArmor(helmet) != SHHelper.getHeroFromArmor(chest) || itemstack == null || !(itemstack.func_77973_b() instanceof ItemHeroArmor) || (multimap = itemstack.func_111283_C()).isEmpty()) continue;
                for (Object o : multimap.entries()) {
                    Map.Entry entry = (Map.Entry)o;
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    String s = (String)entry.getKey();
                    double d = attributemodifier.func_111164_d();
                    int operation = attributemodifier.func_111169_c();
                    if (!SHHelper.isPlayerHero(player) || !s.equals("armor.jumpHeight")) continue;
                    height = (float)((double)height + d / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                }
            }
            player.field_70181_x += 0.145 * (double)height;
            player.field_70181_x += 0.185 * (double)(ASMHooks.getModifiedEntityScale((Entity)player) - 1.0f);
            Hero hero = SHHelper.getHero(player);
            if (hero != null && hero.hasAbility(Ability.leaping) && player.func_70051_ag()) {
                player.func_70060_a(player.field_70702_br, player.field_70701_bs, 1.5f * ASMHooks.getModifiedEntityScale((Entity)player));
                player.field_70181_x += (double)0.2f;
            }
        }
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking event) {
        EntityPlayer player = event.entityPlayer;
        if (player != null && !player.field_70170_p.field_72995_K && event.target instanceof EntityPlayer) {
            EntityPlayer beingTracked = (EntityPlayer)event.target;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            EntityPlayerMP beingTrackedMP = (EntityPlayerMP)beingTracked;
            SHNetworkManager.networkWrapper.sendTo((IMessage)new PacketBroadcastState(player), beingTrackedMP);
            SHNetworkManager.networkWrapper.sendTo((IMessage)new PacketBroadcastState(beingTracked), playerMP);
        }
    }

    @SubscribeEvent
    public void onEntityConstruct(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase) {
            event.entity.registerExtendedProperties("FiskHeroesEntity", (IExtendedEntityProperties)new SHEntityData());
        }
        if (event.entity instanceof EntityPlayer) {
            event.entity.registerExtendedProperties("FiskHeroesPlayer", (IExtendedEntityProperties)new SHPlayerData());
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            Hero hero = SHHelper.getHero(player);
            if ((event.source == DamageSource.field_76379_h || event.source == ModDamageSources.flyIntoWall) && SHData.getInt(player, 54) < 10) {
                player.func_71029_a((StatBase)SHAchievements.glideFaceplant);
            }
            if (event.source.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer attacker = (EntityPlayer)event.source.func_76346_g();
                if (hero instanceof HeroDeadpool && SHHelper.getHero(attacker) instanceof HeroCaptainAmerica) {
                    attacker.func_71029_a((StatBase)SHAchievements.language);
                }
            }
            SHData.setWithoutNotify(player, 22, 0);
            SHData.setWithoutNotify(player, 6, Float.valueOf(1.0f));
            SHData.setWithoutNotify(player, 15, false);
            SHData.setWithoutNotify(player, 14, false);
            SHData.setWithoutNotify(player, 31, 0);
            SHData.setWithoutNotify(player, 32, 0);
            SHData.setWithoutNotify(player, 35, Float.valueOf(0.0f));
            SHData.setWithoutNotify(player, 9, null);
            SHData.setWithoutNotify(player, 42, false);
            if (!player.field_70170_p.field_72995_K) {
                NBTTagCompound playerData = new NBTTagCompound();
                SHPlayerData.getData(player).saveNBTData(playerData);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer && event.world.field_72995_K && SuperHeroes.isTransformersModLoaded && !SuperHeroes.isTransformersModUpToDate) {
            ChatComponentText chatComponent = new ChatComponentText("[Fisk's Superheroes] ");
            ChatComponentText chatComponent1 = new ChatComponentText("You're using an out-of-date version of the Transformers Mod that will not function properly with this version. ");
            ChatComponentText chatComponent2 = new ChatComponentText("Please use Transformers Mod version 0.5.12 or higher!");
            chatComponent.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
            chatComponent1.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED).func_150217_b(Boolean.valueOf(true)));
            chatComponent2.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED).func_150217_b(Boolean.valueOf(true)).func_150228_d(Boolean.valueOf(true)));
            ((EntityPlayer)event.entity).func_146105_b(chatComponent.func_150257_a((IChatComponent)chatComponent1).func_150257_a((IChatComponent)chatComponent2));
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        SHPlayerData.getData(event.entityPlayer).copy(SHPlayerData.getData(event.original));
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        SHEntityData.getData(entity).onUpdate();
        if (entity instanceof EntityPlayer) {
            SHPlayerData.getData((EntityPlayer)entity).onUpdate();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (player != null) {
            Hero hero;
            EntityPlayerMP entityplayermp;
            ItemStack[] aitemstack;
            boolean flag = player.field_71071_by.func_146028_b(ModItems.captainAmericasShield);
            if (this.prevHasShield.contains(player) != flag) {
                SHNetworkManager.networkWrapper.sendToAll((IMessage)new PacketSyncHasItem((Entity)event.player, flag, 2));
                if (flag) {
                    this.prevHasShield.add(player);
                } else {
                    this.prevHasShield.remove(player);
                }
            }
            flag = player.field_71071_by.func_146028_b(ModItems.deadpoolsSwords);
            if (this.prevHasDeadpoolSwords.contains(player) != flag) {
                SHNetworkManager.networkWrapper.sendToAll((IMessage)new PacketSyncHasItem((Entity)event.player, flag, 3));
                if (flag) {
                    this.prevHasDeadpoolSwords.add(player);
                } else {
                    this.prevHasDeadpoolSwords.remove(player);
                }
            }
            SHData.setWithoutNotify(player, 34, Float.valueOf(SHData.getFloat(player, 6)));
            SHData.setWithoutNotify(player, 27, Float.valueOf(SHData.getFloat(player, 28)));
            SHData.setWithoutNotify(player, 39, Float.valueOf(SHData.getFloat(player, 38)));
            SHData.setWithoutNotify(player, 43, SHData.getBoolean(player, 42));
            SHData.setWithoutNotify(player, 47, Float.valueOf(SHData.getFloat(player, 46)));
            double kmphUnit = 0.0049467960817423;
            IAttributeInstance speedAttribute = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            IAttributeInstance maxHealthAttribute = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            IAttributeInstance stepHeightAttribute = player.func_110148_a(SHAttributes.stepHeight);
            UUID maxHealthModifierUUID = UUID.fromString("C2FB1DE4-8176-4B96-A448-460FE6FDC687");
            AttributeModifier maxHealthModifier = new AttributeModifier(maxHealthModifierUUID, "Health boost", 20.0 * (double)(SHData.getFloat(player, 6) - 1.0f), 0).func_111168_a(true);
            if (maxHealthAttribute.func_111127_a(maxHealthModifierUUID) != null) {
                maxHealthAttribute.func_111124_b(maxHealthModifier);
                player.field_70138_W = 0.5f;
            }
            if (SHData.getFloat(player, 6) > 1.0f) {
                maxHealthAttribute.func_111121_a(maxHealthModifier);
                player.field_70138_W = SHData.getFloat(player, 6) * 0.5f;
            }
            UUID speedBoostModifierUUID = UUID.fromString("B2FB1DE4-8176-4B96-A448-460FE6FDC687");
            AttributeModifier speedBoostModifier = new AttributeModifier(speedBoostModifierUUID, "Super-Speed boost", SHData.getInt(player, 1) < 0 ? 0.0 : 0.0049467960817423 * (double)(SpeedsterHelper.getPlayerTopSpeed(player) - 20.0f), 0).func_111168_a(false);
            if (speedAttribute.func_111127_a(speedBoostModifierUUID) != null) {
                speedAttribute.func_111124_b(speedBoostModifier);
                player.field_70138_W = 0.5f;
            }
            if (SHData.getBoolean(player, 0) && SHHelper.canRunSuperSpeed(player)) {
                speedAttribute.func_111121_a(speedBoostModifier);
                player.field_70138_W = 1.0f;
            }
            UUID treadmillModifierUUID = UUID.fromString("B2FB1DE4-8276-4B86-A448-460FA6FDC689");
            AttributeModifier treadmillModifier = new AttributeModifier(treadmillModifierUUID, "Treadmill speed boost", -1.0, 1).func_111168_a(false);
            if (speedAttribute.func_111127_a(treadmillModifierUUID) != null) {
                speedAttribute.func_111124_b(treadmillModifier);
            }
            if (SHHelper.isOnTreadmill(player)) {
                speedAttribute.func_111121_a(treadmillModifier);
            }
            float sprintSpeedBoost = 0.0f;
            int sprintSpeedOperation = 0;
            float stepHeight = 0.0f;
            int stepHeightOperation = 0;
            ItemStack helmet = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack legs = player.func_82169_q(1);
            ItemStack feet = player.func_82169_q(0);
            for (ItemStack itemstack : aitemstack = new ItemStack[]{helmet, chest, legs, feet}) {
                Multimap multimap;
                if (itemstack == helmet && helmet != null && chest != null && helmet.func_77973_b() instanceof ItemHeroArmor && SHHelper.getHeroFromArmor(helmet) != SHHelper.getHeroFromArmor(chest) || itemstack == null || !(itemstack.func_77973_b() instanceof ItemHeroArmor) || (multimap = itemstack.func_111283_C()).isEmpty()) continue;
                for (Object o : multimap.entries()) {
                    Map.Entry entry = (Map.Entry)o;
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    String s = (String)entry.getKey();
                    double d = attributemodifier.func_111164_d();
                    int operation = attributemodifier.func_111169_c();
                    if (!SHHelper.isPlayerHero(player)) continue;
                    if (s.equals("armor.sprintSpeed")) {
                        sprintSpeedBoost = (float)((double)sprintSpeedBoost + d / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                        sprintSpeedOperation = operation;
                        continue;
                    }
                    if (!s.equals("armor.stepHeight")) continue;
                    stepHeight = (float)((double)stepHeight + d / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                    stepHeightOperation = operation;
                }
            }
            UUID sprintingSpeedBoostModifierUUID = UUID.fromString("37B2D85F-0CA2-4C6B-9BB1-A5F82DD85BBC");
            AttributeModifier sprintingSpeedBoostModifier = new AttributeModifier(sprintingSpeedBoostModifierUUID, "Sprinting speed boost", (double)sprintSpeedBoost, sprintSpeedOperation).func_111168_a(false);
            if (speedAttribute.func_111127_a(sprintingSpeedBoostModifierUUID) != null) {
                speedAttribute.func_111124_b(sprintingSpeedBoostModifier);
            }
            if (player.func_70051_ag()) {
                speedAttribute.func_111121_a(sprintingSpeedBoostModifier);
            }
            UUID speedScaledModifierUUID = UUID.fromString("37B2D85F-3CA2-7C6B-9BB1-A5F82DD85BBC");
            AttributeModifier speedScaledModifier = new AttributeModifier(speedScaledModifierUUID, "Scaled speed boost", (double)(SHData.getFloat(player, 6) - 1.0f), 1).func_111168_a(false);
            if (speedAttribute.func_111127_a(speedScaledModifierUUID) != null) {
                speedAttribute.func_111124_b(speedScaledModifier);
            }
            if (SHData.getFloat(player, 6) > 1.0f) {
                speedAttribute.func_111121_a(speedScaledModifier);
            }
            UUID stepHeightModifierUUID = UUID.fromString("37B2D83F-3CA2-7C6B-9AA1-A5F82DB85BBC");
            AttributeModifier stepHeightModifier = new AttributeModifier(stepHeightModifierUUID, "Step height", 0.0, 0).func_111168_a(false);
            if (stepHeightAttribute.func_111127_a(stepHeightModifierUUID) != null) {
                stepHeightAttribute.func_111124_b(stepHeightModifier);
                player.field_70138_W = 0.5f;
            }
            if (stepHeight != 0.0f) {
                stepHeightAttribute.func_111121_a(stepHeightModifier);
                player.field_70138_W = stepHeightOperation == 1 ? (player.field_70138_W *= 1.0f + stepHeight) : (player.field_70138_W += stepHeight);
            }
            if (SHHelper.areAllPlayersSlowMotion(player.field_70170_p)) {
                TimeHelper.updateServerTickrate(4.0f);
            } else {
                TimeHelper.updateServerTickrate(20.0f);
            }
            DataManager.updateVelocity(player);
            if (player.field_71093_bK == ModDimensions.QUANTUM_REALM_ID) {
                player.field_70143_R = 0.0f;
                if (player instanceof EntityPlayerMP) {
                    entityplayermp = (EntityPlayerMP)player;
                    if (player.field_70163_u <= 30.0) {
                        entityplayermp.field_71135_a.func_147364_a(entityplayermp.field_70165_t, 240.0, entityplayermp.field_70161_v, entityplayermp.field_70177_z, entityplayermp.field_70125_A);
                    }
                    if (player.field_70163_u >= 250.0) {
                        entityplayermp.field_71135_a.func_147364_a(entityplayermp.field_70165_t, 40.0, entityplayermp.field_70161_v, entityplayermp.field_70177_z, entityplayermp.field_70125_A);
                    }
                }
                if (SHHelper.getHeroFromArmor(player, 3) == null || !SHHelper.getHeroFromArmor(player, 3).canBreatheInSpace(player)) {
                    player.func_70097_a(ModDamageSources.suffocate, 2.0f);
                }
            }
            if (SHHelper.getHeroFromArmor(player, 3) != null && SHHelper.getHeroFromArmor(player, 3).canBreatheUnderwater(player)) {
                player.func_70050_g(300);
            }
            if (player instanceof EntityPlayerMP) {
                entityplayermp = (EntityPlayerMP)player;
                if (SHHelper.shouldOverrideReachDistance(player)) {
                    float originalDistance = player.field_71075_bZ.field_75098_d ? 5.0f : 4.5f;
                    entityplayermp.field_71134_c.setBlockReachDistance((double)(originalDistance + ASMHooks.getModifiedEntityScale((Entity)player) - 1.0f));
                }
            }
            if (event.phase == TickEvent.Phase.END) {
                int face;
                Hero hero2;
                DataManager.updateVelocity(player);
                SHData.incrWithoutNotify(player, 4, 1);
                this.updateArmSwingProgress(player);
                if (SHData.getInt(player, 31) > 0) {
                    SHData.incrWithoutNotify(player, 31, -1);
                    if (SHData.getInt(player, 31) == 0 && !SHHelper.isPlayerSpeedster(player)) {
                        SHData.setWithoutNotify(player, 0, false);
                    } else if (!SHHelper.isPlayerSpeedster(player)) {
                        SHData.setWithoutNotify(player, 0, true);
                    }
                    if (SHData.getInt(player, 1) < SpeedsterHelper.getMaxSpeedSetting(player)) {
                        SHData.setWithoutNotify(player, 1, SpeedsterHelper.getMaxSpeedSetting(player));
                    }
                }
                if (SHData.getBoolean(player, 42)) {
                    SHData.incrWithoutNotify(player, 44, 1);
                } else {
                    SHData.setWithoutNotify(player, 44, 0);
                }
                ItemStack itemstack = SHHelper.getEquippedTachyonDevice(player);
                if (SHHelper.hasTachyonDevice(player)) {
                    if (itemstack != null && itemstack.func_77960_j() < itemstack.func_77958_k() && SHHelper.getTachyonCharge(player) == 0.0f) {
                        if (SHData.getFloat(player, 38) < 1.0f) {
                            SHData.incrWithoutNotify(player, 38, Float.valueOf(0.1f));
                        }
                    } else if (SHData.getFloat(player, 38) > 0.0f) {
                        SHData.incrWithoutNotify(player, 38, Float.valueOf(-0.1f));
                    }
                } else {
                    SHData.setWithoutNotify(player, 38, Float.valueOf(0.0f));
                }
                float scale = SHData.getFloat(player, 6);
                for (Entity entity : player.field_70170_p.field_72996_f) {
                    EntityGrapplingHookArrow arrow;
                    if (!(entity instanceof EntityGrapplingHookArrow) || (arrow = (EntityGrapplingHookArrow)entity).getShooter() != player || arrow.getIsCableCut()) continue;
                    if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() != ModItems.compoundBow || player.func_70694_bm() == null || player.field_70733_aJ > 0.0f) {
                        arrow.setIsCableCut(true);
                        player.field_70170_p.func_72956_a((Entity)player, "mob.sheep.shear", 1.0f, 0.8f);
                    }
                    if (arrow.field_70169_q != arrow.field_70165_t || arrow.field_70167_r != arrow.field_70163_u || arrow.field_70166_s != arrow.field_70161_v) continue;
                    player.field_70143_R = 0.0f;
                    double x = (arrow.field_70165_t - player.field_70165_t) / 40.0;
                    double y = (arrow.field_70163_u - player.field_70163_u) / 40.0;
                    double z = (arrow.field_70161_v - player.field_70161_v) / 40.0;
                    double cap = 0.2f;
                    double d = 0.95;
                    player.field_70159_w += x;
                    player.field_70181_x += y;
                    player.field_70179_y += z;
                }
                if (SHHelper.canRunSuperSpeed(player)) {
                    if (SHData.getInt(player, 1) > SpeedsterHelper.getMaxSpeedSetting(player)) {
                        SHData.setWithoutNotify(player, 1, SpeedsterHelper.getMaxSpeedSetting(player));
                    }
                    if (SHData.getBoolean(player, 0) && SHData.getInt(player, 1) > 0 && SHHelper.canRunSuperSpeed(player)) {
                        hero2 = SHHelper.getHero(player);
                        float f = SHHelper.getTachyonCharge(player);
                        if (player.field_70173_aa % 40 == 0) {
                            if (f > 0.0f) {
                                for (int i = 0; i < 4; ++i) {
                                    int j;
                                    ItemStack itemstack1 = player.func_82169_q(i);
                                    if (SHHelper.getHeroFromArmor(itemstack1) != hero2 || (j = itemstack1.func_77978_p().func_74762_e("TachyonCharge")) <= 0) continue;
                                    itemstack1.func_77978_p().func_74768_a("TachyonCharge", --j);
                                }
                            } else if (SHHelper.getEquippedTachyonDevice(player) != null) {
                                ItemStack itemstack1 = SHHelper.getEquippedTachyonDevice(player);
                                if (SHData.getFloat(player, 38) >= 1.0f) {
                                    itemstack1.func_96631_a(1, new Random());
                                }
                            }
                        }
                    }
                    if (SpeedsterHelper.getMaxSpeedSetting(player) >= 19) {
                        player.func_71029_a((StatBase)SHAchievements.kmph1000);
                    }
                }
                if ((hero2 = SHHelper.getHero(player)) != null) {
                    String nextDisguise;
                    int maskOpenTimer = SHData.getInt(player, 8);
                    boolean isMaskOpen = SHData.getBoolean(player, 7);
                    if (maskOpenTimer < 5 && isMaskOpen) {
                        SHData.incrWithoutNotify(player, 8, 1);
                    } else if (maskOpenTimer > 0 && !isMaskOpen) {
                        SHData.incrWithoutNotify(player, 8, -1);
                    }
                    float shapeShiftTimer = SHData.getFloat(player, 10);
                    boolean isShapeShifting = SHData.getBoolean(player, 11);
                    if (shapeShiftTimer < 1.0f && isShapeShifting) {
                        SHData.incrWithoutNotify(player, 10, Float.valueOf(0.02f));
                    } else if (shapeShiftTimer > 0.0f && !isShapeShifting) {
                        SHData.incrWithoutNotify(player, 10, Float.valueOf(-0.02f));
                    }
                    if (shapeShiftTimer < 0.0f) {
                        SHData.setWithoutNotify(player, 10, Float.valueOf(0.0f));
                    }
                    if (shapeShiftTimer > 1.0f) {
                        SHData.setWithoutNotify(player, 10, Float.valueOf(1.0f));
                    }
                    if (!((shapeShiftTimer = (float)((int)(shapeShiftTimer * 100.0f)) / 100.0f) != 0.5f || (nextDisguise = SHData.getString(player, 24)) != null && nextDisguise.isEmpty())) {
                        SHData.setWithoutNotify(player, 9, nextDisguise);
                    }
                    if (SHData.getString(player, 9) != null && SHData.getString(player, 9).isEmpty()) {
                        SHData.setWithoutNotify(player, 9, null);
                    }
                    int suitOpenTimer = SHData.getInt(player, 41);
                    boolean isSuitOpen = SHData.getBoolean(player, 40);
                    if (maskOpenTimer == 0) {
                        if (suitOpenTimer < 5 && isSuitOpen) {
                            SHData.incrWithoutNotify(player, 41, 1);
                        } else if (suitOpenTimer > 0 && !isSuitOpen) {
                            SHData.incrWithoutNotify(player, 41, -1);
                        }
                    } else if (isSuitOpen) {
                        SHData.setWithoutNotify(player, 7, false);
                    }
                    if (hero2.hasAbility(Ability.repulsorBlast)) {
                        if (SHData.getBoolean(player, 5) && !SHData.getBoolean(player, 52)) {
                            player.func_85030_a("fiskheroes:repulsor_charge", 1.0f, 1.0f);
                        } else if (!SHData.getBoolean(player, 5) && SHData.getBoolean(player, 52)) {
                            player.func_85030_a("fiskheroes:repulsor_power_down", 0.5f, 1.0f);
                        }
                    }
                    SHData.setWithoutNotify(player, 52, SHData.getBoolean(player, 5));
                    if (hero2.hasAbility(Ability.regeneration1)) {
                        if (player.func_82165_m(Potion.field_76431_k.field_76415_H)) {
                            player.func_82170_o(Potion.field_76431_k.field_76415_H);
                        }
                        if (player.func_82165_m(Potion.field_76436_u.field_76415_H)) {
                            player.func_82170_o(Potion.field_76436_u.field_76415_H);
                        }
                        if (player.func_82165_m(Potion.field_82731_v.field_76415_H)) {
                            player.func_82170_o(Potion.field_82731_v.field_76415_H);
                        }
                    }
                    if (hero2.hasAbility(Ability.regeneration2)) {
                        if (player.func_110143_aJ() < player.func_110138_aP() && SHData.getInt(player, 4) > 80) {
                            player.func_70691_i(1.0f);
                        }
                        if (player.func_82165_m(Potion.field_76436_u.field_76415_H)) {
                            player.func_82170_o(Potion.field_76436_u.field_76415_H);
                        }
                        if (player.func_82165_m(Potion.field_82731_v.field_76415_H)) {
                            player.func_82170_o(Potion.field_82731_v.field_76415_H);
                        }
                    }
                    if (hero2.hasAbility(Ability.sizeManipulation)) {
                        float increment;
                        ISizeManipulation sizeManipulation = (ISizeManipulation)((Object)hero2);
                        float min = sizeManipulation.getMinSize(player);
                        float max = sizeManipulation.getMaxSize(player);
                        float f = sizeManipulation.isInstant(player) ? 0.1f : (increment = SHData.getBoolean(player, 15) ? 0.02f : 0.04f);
                        if (player.field_71093_bK != ModDimensions.QUANTUM_REALM_ID) {
                            if (SHData.getBoolean(player, 15)) {
                                if (sizeManipulation.isInstant(player) && scale <= min) {
                                    player.func_85030_a("fiskheroes:grow", 1.0f, 1.0f);
                                }
                                if (scale < max) {
                                    SHData.incrWithoutNotify(player, 6, Float.valueOf(increment));
                                }
                            } else if (SHData.getBoolean(player, 14)) {
                                if (sizeManipulation.isInstant(player) && scale >= max) {
                                    player.func_85030_a("fiskheroes:shrink", 1.0f, 1.0f);
                                }
                                if (scale > min) {
                                    SHData.incrWithoutNotify(player, 6, Float.valueOf(-increment));
                                }
                            }
                        }
                        SHData.capWithoutNotify(player, 6, Float.valueOf(min), Float.valueOf(max));
                        if (player.field_71093_bK != ModDimensions.QUANTUM_REALM_ID) {
                            if (scale < 1.0f) {
                                if (SHData.getInt(player, 22) < 1200) {
                                    SHData.incrWithoutNotify(player, 22, 1);
                                }
                            } else if (SHData.getInt(player, 22) > 0) {
                                SHData.incrWithoutNotify(player, 22, -1);
                            }
                        }
                    }
                    if (hero2.hasAbility(Ability.intangibility)) {
                        if (SHData.getBoolean(player, 12)) {
                            player.field_70145_X = true;
                        }
                    } else {
                        SHData.setWithoutNotify(player, 12, false);
                    }
                    if (hero2.hasAbility(Ability.invisibility) && SHData.getBoolean(player, 13)) {
                        player.func_82142_c(true);
                    }
                    if (hero2.hasAbility(Ability.flight1) || hero2.hasAbility(Ability.flight2)) {
                        player.field_70143_R = 0.0f;
                    }
                    if (hero2.hasAbility(Ability.flight3) || hero2.hasAbility(Ability.gliding)) {
                        SuperHeroes.proxy.updateGliding(player);
                        if (player.field_70122_E || player.field_70132_H || player.field_71075_bZ.field_75100_b || player.func_70090_H()) {
                            SHData.set(player, 42, false);
                        }
                        float increment = 0.15f;
                        if (SHData.getBoolean(player, 42)) {
                            if (SHData.getFloat(player, 46) < 1.0f) {
                                SHData.incrWithoutNotify(player, 46, Float.valueOf(increment));
                            }
                        } else if (SHData.getFloat(player, 46) > 0.0f) {
                            SHData.incrWithoutNotify(player, 46, Float.valueOf(-increment));
                        }
                        SHData.capWithoutNotify(player, 46, Float.valueOf(0.0f), Float.valueOf(1.0f));
                    } else {
                        SHData.setWithoutNotify(player, 42, false);
                    }
                    if (hero2.hasAbility(Ability.pyrokinesis) && SHData.getBoolean(player, 5)) {
                        World world = player.field_70170_p;
                        Random rand = new Random();
                        double range = 10.0;
                        double frontOffset = 0.6;
                        double sideOffset = -0.375;
                        Vec3 src = VectorHelper.getOffsetCoords(player, sideOffset, -0.4f, frontOffset);
                        Vec3 dest = VectorHelper.getOffsetCoords(player, sideOffset, 0.0, frontOffset + range);
                        MovingObjectPosition rayTrace = world.func_72933_a(VectorHelper.copy(src), VectorHelper.copy(dest));
                        Vec3 hitVec = null;
                        hitVec = rayTrace == null ? dest : rayTrace.field_72307_f;
                        double distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                        for (double point = 0.0; point < distance; point += 0.15) {
                            Vec3 particleVec = VectorHelper.getOffsetCoords(player, sideOffset, -0.4f, frontOffset + point);
                            for (EntityLivingBase entity : VectorHelper.getEntitiesNear(world, particleVec.field_72450_a, particleVec.field_72448_b, particleVec.field_72449_c, 0.5)) {
                                if (entity == null || entity == player) continue;
                                hitVec.field_72450_a = entity.field_70165_t;
                                hitVec.field_72448_b = entity.field_70163_u;
                                hitVec.field_72449_c = entity.field_70161_v;
                                rayTrace = new MovingObjectPosition((Entity)entity, hitVec);
                                distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                                break;
                            }
                            if (!world.field_72995_K) continue;
                            float spread = 0.4f;
                            float spread1 = 0.05f;
                            SHParticles.spawnParticle(SHParticleType.SHORT_FLAME, particleVec.field_72450_a + (double)((rand.nextFloat() - 0.5f) * spread), particleVec.field_72448_b + (double)((rand.nextFloat() - 0.5f) * spread), particleVec.field_72449_c + (double)((rand.nextFloat() - 0.5f) * spread), (rand.nextFloat() - 0.5f) * spread1, (rand.nextFloat() - 0.5f) * spread1, (rand.nextFloat() - 0.5f) * spread1);
                        }
                        if (rayTrace != null && rayTrace.field_72308_g != null) {
                            double d1 = player.field_70165_t - rayTrace.field_72308_g.field_70165_t;
                            double d0 = player.field_70161_v - rayTrace.field_72308_g.field_70161_v;
                            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                                d1 = (Math.random() - Math.random()) * 0.01;
                                d0 = (Math.random() - Math.random()) * 0.01;
                            }
                            float damage = 5.0f;
                            rayTrace.field_72308_g.func_70015_d(5);
                            rayTrace.field_72308_g.func_70097_a(ModDamageSources.causeBurnDamage((Entity)player), damage);
                            ((EntityLivingBase)rayTrace.field_72308_g).func_70653_a(rayTrace.field_72308_g, damage, d1 * 50.0, d0 * 50.0);
                        }
                    }
                    if (hero2.hasAbility(Ability.cryokinesis)) {
                        float cryoCharge = SHData.getFloat(player, 35);
                        if (SHData.getBoolean(player, 36) && cryoCharge < 1.0f) {
                            SHData.incrWithoutNotify(player, 35, Float.valueOf(0.05f));
                        }
                        SHData.capWithoutNotify(player, 35, Float.valueOf(0.0f), Float.valueOf(1.0f));
                    }
                    if (hero2.hasAbility(Ability.heatResistance)) {
                        player.field_70174_ab = 60;
                    }
                    if (hero2.hasAbility(Ability.heatVision) && SHData.getBoolean(player, 16)) {
                        MovingObjectPosition mop;
                        World world = player.field_70170_p;
                        if (world.field_72995_K) {
                            world.func_72838_d((Entity)new EntityHeatVision(world, player));
                        }
                        if ((mop = SHHelper.getHeatVisionMOP(player, 1.0f)) != null) {
                            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !world.field_72995_K && SHConfig.heatVisionGriefing) {
                                int x = mop.field_72311_b;
                                int y = mop.field_72312_c;
                                int z = mop.field_72309_d;
                                int metadata = world.func_72805_g(x, y, z);
                                Block block = world.func_147439_a(x, y, z);
                                if (SHHelper.getHeatVisionResult(block, metadata) != null) {
                                    world.func_147449_b(x, y, z, SHHelper.getHeatVisionResult(block, metadata));
                                }
                            }
                            if (mop.field_72308_g != null) {
                                float damage = 10.0f;
                                mop.field_72308_g.func_70097_a(ModDamageSources.causeBurnDamage((Entity)player), damage);
                            }
                        }
                    }
                    if (hero2.hasAbility(Ability.canaryCry) && SHData.getBoolean(player, 16)) {
                        World world = player.field_70170_p;
                        if (!world.field_72995_K) {
                            world.func_72838_d((Entity)new EntityCanaryCry(world, (EntityLivingBase)player));
                        }
                    }
                    if (hero2.hasWeakness(Weakness.fire)) {
                        flag = player.func_70027_ad();
                        int radius = 3;
                        for (int i = -radius; i < radius; ++i) {
                            block8: for (int j = -radius; j < radius; ++j) {
                                for (int k = -radius; k < radius; ++k) {
                                    int z;
                                    int y;
                                    int x = MathHelper.func_76128_c((double)player.field_70165_t) + i;
                                    if (player.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)player.field_70163_u) + j, z = MathHelper.func_76128_c((double)player.field_70161_v) + k) != Blocks.field_150480_ab && player.field_70170_p.func_147439_a(x, y, z) != Blocks.field_150353_l) continue;
                                    flag = true;
                                    continue block8;
                                }
                            }
                        }
                        if (!flag) {
                            int x = MathHelper.func_76128_c((double)player.field_70165_t);
                            int y = MathHelper.func_76128_c((double)player.field_70163_u);
                            int z = MathHelper.func_76128_c((double)player.field_70161_v);
                            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)radius, (double)radius, (double)radius);
                            for (Entity entity : player.field_70170_p.func_82733_a(Entity.class, aabb, IEntitySelector.field_94557_a)) {
                                if (!entity.func_70027_ad()) continue;
                                flag = true;
                                break;
                            }
                        }
                        if (flag) {
                            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 0));
                            player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 3));
                            player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 100, 2));
                        }
                    }
                } else {
                    SHData.setWithoutNotify(player, 7, false);
                    SHData.setWithoutNotify(player, 8, 0);
                    SHData.setWithoutNotify(player, 11, false);
                    SHData.setWithoutNotify(player, 10, Float.valueOf(0.0f));
                    SHData.setWithoutNotify(player, 12, false);
                    SHData.setWithoutNotify(player, 13, false);
                    SHData.setWithoutNotify(player, 9, null);
                    SHData.setWithoutNotify(player, 14, false);
                    SHData.setWithoutNotify(player, 15, false);
                    SHData.setWithoutNotify(player, 35, Float.valueOf(0.0f));
                    SHData.setWithoutNotify(player, 40, false);
                    SHData.setWithoutNotify(player, 41, 0);
                    SHData.setWithoutNotify(player, 42, false);
                    SHData.setWithoutNotify(player, 46, Float.valueOf(0.0f));
                }
                if (hero2 == null || !hero2.hasAbility(Ability.sizeManipulation)) {
                    if (player.field_71093_bK != ModDimensions.QUANTUM_REALM_ID && SHData.getInt(player, 22) > 0) {
                        SHData.incrWithoutNotify(player, 22, -1);
                    }
                    SHData.setWithoutNotify(player, 6, Float.valueOf(SHHelper.getDefaultScale(player)));
                }
                if (hero2 == null || !hero2.hasAbility(Ability.hover) || player.field_71075_bZ.field_75100_b || player.field_70122_E) {
                    SHData.setWithoutNotify(player, 53, false);
                }
                if (player.field_71093_bK != ModDimensions.QUANTUM_REALM_ID && SHData.getInt(player, 22) >= 1200) {
                    SHHelper.setInQuantumRealm(player);
                }
                if (SHHelper.shouldOverrideScale(player, scale = SHData.getFloat(player, 6))) {
                    float widthScale = scale;
                    float heightScale = scale;
                    if (SHHelper.getHero(player) == null && SHData.get(player, 33) != null || !SHData.getBoolean(player, 42) && SHData.getBoolean(player, 43)) {
                        heightScale = 1.0f;
                        widthScale = 1.0f;
                    }
                    if (SHData.getBoolean(player, 42)) {
                        float f = MathHelper.func_76131_a((float)((float)SHData.getInt(player, 44) + SuperHeroes.proxy.getRenderTick()), (float)0.0f, (float)4.0f) / 4.0f;
                        heightScale *= 0.33333334f * f + (1.0f - f);
                    }
                    SHReflection.setSize((Entity)player, 0.6f * widthScale, 1.8f * heightScale);
                    player.eyeHeight = (heightScale - 1.0f) * 1.62f + player.getDefaultEyeHeight() * heightScale - player.getDefaultEyeHeight() * (heightScale - 1.0f);
                }
                if ((face = SHHelper.getSideStandingOn(player)) != 1) {
                    player.field_70181_x = 0.0;
                    if (face == 2) {
                        // empty if block
                    }
                    float scale1 = 0.0925926f;
                    SHReflection.setSize((Entity)player, 0.6f * scale1, 1.8f * scale1);
                    player.eyeHeight = (scale1 - 1.0f) * 1.62f + player.getDefaultEyeHeight() * scale1 - player.getDefaultEyeHeight() * (scale1 - 1.0f);
                }
            } else {
                hero = SHHelper.getHero(player);
                if (hero != null && hero.hasAbility(Ability.flight1) && player.field_70170_p.field_72995_K) {
                    FlightManager.tick(player);
                }
            }
            hero = SHHelper.getHero(player);
            if (hero != null) {
                hero.onUpdate(player, event.phase);
            }
            if (player.func_110143_aJ() > player.func_110138_aP()) {
                player.func_70606_j(player.func_110138_aP());
            }
            if (!SHData.getBoolean(player, 42)) {
                SHData.incrWithoutNotify(player, 54, 1);
            } else {
                SHData.setWithoutNotify(player, 54, 0);
            }
            if (event.phase == TickEvent.Phase.END) {
                SHData.setWithoutNotify(player, 33, SHHelper.getHero(player));
            }
            if (SHData.get(player, 33) != hero) {
                this.onSwitchArmor(player, (Hero)SHData.get(player, 33), hero);
            }
        }
    }

    protected void onSwitchArmor(EntityPlayer player, Hero from, Hero to) {
        player.field_70174_ab = 1;
        if (to != null && to.hasAbility(Ability.superSpeed)) {
            SHData.setWithoutNotify(player, 1, SpeedsterHelper.getMaxSpeedSetting(player));
        }
    }

    protected void updateArmSwingProgress(EntityPlayer player) {
        int i = (Integer)SHReflection.getMethod(SHReflection.getArmSwingAnimationEndMethod, player, new Object[0]);
        if (SHData.getBoolean(player, 25)) {
            SHData.incrWithoutNotify(player, 26, 1);
            if (SHData.getInt(player, 26) >= i) {
                SHData.setWithoutNotify(player, 26, 0);
                SHData.setWithoutNotify(player, 25, false);
            }
        } else {
            SHData.setWithoutNotify(player, 26, 0);
        }
        SHData.setWithoutNotify(player, 28, Float.valueOf((float)SHData.getInt(player, 26) / (float)i));
        if (player.field_110158_av == 1 && player.field_110158_av == SHData.getInt(player, 26)) {
            double radius = 1.5;
            AxisAlignedBB aabb = player.field_70121_D.func_72314_b(radius, 0.0, radius);
            List list = player.field_70170_p.func_72839_b((Entity)player, aabb);
            for (Entity entity : list) {
                if (!(entity instanceof EntityLivingBase) || !player.func_70685_l(entity)) continue;
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 1.0f);
                SHHelper.knockbackWithoutNotify((EntityLivingBase)entity, (Entity)player, 0.5f);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Hero hero;
        EntityPlayer player;
        if (event.entity instanceof EntityPlayer) {
            player = (EntityPlayer)event.entity;
            hero = SHHelper.getHero(player);
            float originalAmount = event.ammount;
            if (!(event.source.func_76346_g() instanceof EntityPlayer) && !event.source.func_76363_c()) {
                event.ammount *= 1.0f - SHHelper.getArmorProtection(player);
            }
            if (hero != null) {
                if (hero.hasAbility(Ability.heatResistance) && event.source.func_76347_k() && !event.source.func_76363_c()) {
                    event.ammount /= 2.0f;
                }
                if (hero.hasAbility(Ability.coldResistance) && event.source.field_76373_n.equals("freeze") && !event.source.func_76363_c()) {
                    event.ammount /= 2.0f;
                }
                if (!(!hero.hasAbility(Ability.cactusPhysiology) || event.source.func_76352_a() || event.source.func_94541_c() || event.source.func_76347_k() || event.source.func_82725_o() || !(event.source.func_76346_g() instanceof EntityLivingBase) || event.source.func_76346_g() instanceof EntityPlayer && SHHelper.getHero((EntityPlayer)event.source.func_76346_g()) != null && SHHelper.getHero((EntityPlayer)event.source.func_76346_g()).hasAbility(Ability.cactusPhysiology))) {
                    ((EntityLivingBase)event.source.func_76346_g()).func_70097_a(DamageSource.func_92087_a((Entity)player), Math.max(originalAmount * 0.25f, 1.0f));
                }
                if (hero.hasWeakness(Weakness.fire) && event.source.func_76347_k() && !event.source.func_76363_c()) {
                    event.ammount /= 1.0f - SHHelper.getArmorProtection(player);
                }
                if (hero.hasWeakness(Weakness.heat) && event.source.func_76347_k()) {
                    event.ammount *= 2.0f;
                }
                if (hero.hasWeakness(Weakness.cold) && event.source.field_76373_n.equals("freeze")) {
                    event.ammount *= 2.0f;
                }
            }
            if (!event.isCanceled()) {
                SHData.set(player, 4, 0);
            }
        }
        if (event.source != null && event.source.func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)event.source.func_76346_g();
            hero = SHHelper.getHero(player);
            if (!(!SHHelper.canRunSuperSpeed(player) || event.source.func_76352_a() || event.source.func_94541_c() || event.source.func_76347_k() || event.source.func_82725_o())) {
                event.entityLiving.field_70172_ad = 0;
            }
            if (hero != null) {
                if (!(!hero.hasAbility(Ability.pyrokinesis) || event.source.func_76352_a() || event.source.func_94541_c() || event.source.func_76347_k() || event.source.func_82725_o())) {
                    event.entityLiving.func_70015_d(10);
                }
                if (!(!hero.hasAbility(Ability.cryokinesis) || event.source.func_76352_a() || event.source.func_94541_c() || event.source.func_76347_k() || event.source.func_82725_o())) {
                    event.ammount += 3.0f * SHData.getFloat(player, 35);
                    if (TemperatureHelper.getCurrentBodyTemperature(event.entityLiving) > 0.0f) {
                        TemperatureHelper.setTemperature(event.entityLiving, TemperatureHelper.getTemperature(event.entityLiving) - 1.0f);
                    }
                    SHData.incr(player, 35, Float.valueOf(-0.2f));
                }
            }
            ItemStack helmet = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack legs = player.func_82169_q(1);
            ItemStack feet = player.func_82169_q(0);
            ItemStack[] aitemstack = new ItemStack[]{helmet, chest, legs, feet};
            float amount = event.ammount;
            for (ItemStack itemstack : aitemstack) {
                Multimap multimap;
                if (itemstack == helmet && helmet != null && chest != null && helmet.func_77973_b() instanceof ItemHeroArmor && SHHelper.getHeroFromArmor(helmet) != SHHelper.getHeroFromArmor(chest) || itemstack == null || !(itemstack.func_77973_b() instanceof ItemHeroArmor) || (multimap = itemstack.func_111283_C()).isEmpty()) continue;
                for (Object o : multimap.entries()) {
                    boolean isHoldingWeapon;
                    Map.Entry entry = (Map.Entry)o;
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    String s = (String)entry.getKey();
                    double d = attributemodifier.func_111164_d();
                    int operation = attributemodifier.func_111169_c();
                    if (!SHHelper.isPlayerHero(player)) continue;
                    ItemStack heldItem = player.func_70694_bm();
                    boolean bl = isHoldingWeapon = heldItem != null && (heldItem.func_77973_b() instanceof ItemSword || heldItem.func_77973_b() instanceof ItemTool);
                    if (event.source.func_82725_o() || event.source.func_94541_c() || event.source.func_76352_a() || event.source.func_76347_k()) continue;
                    if (s.equals("armor.swordDamage")) {
                        if (!isHoldingWeapon) continue;
                        if (operation == 0) {
                            event.ammount = (float)((double)event.ammount + d / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                            continue;
                        }
                        if (operation != 1) continue;
                        event.ammount = (float)((double)event.ammount + d * (double)amount / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                        continue;
                    }
                    if (s.equals("armor.punchDamage")) {
                        if (isHoldingWeapon) continue;
                        if (operation == 0) {
                            event.ammount = (float)((double)event.ammount + d / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                            continue;
                        }
                        if (operation != 1) continue;
                        event.ammount = (float)((double)event.ammount + d * (double)amount / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                        continue;
                    }
                    if (!s.equals("armor.attackDamage")) continue;
                    if (operation == 0) {
                        event.ammount = (float)((double)event.ammount + d / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                        continue;
                    }
                    if (operation != 1) continue;
                    event.ammount = (float)((double)event.ammount + d * (double)amount / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                }
            }
            if (!(event.source.func_82725_o() || event.source.func_94541_c() || event.source.func_76352_a() || event.source.func_76347_k())) {
                if (SHData.getFloat(player, 6) < 1.0f && hero.hasAbility(Ability.sizeManipulation)) {
                    float min = ((ISizeManipulation)((Object)hero)).getMinSize(player);
                    event.ammount *= 2.0f * (min / SHData.getFloat(player, 6));
                    event.ammount = Math.min(event.ammount, 15.0f);
                } else {
                    event.ammount *= SHData.getFloat(player, 6) / SHHelper.getDefaultScale(player);
                }
            }
            if (event.entity instanceof EntityPlayer && !event.source.func_76363_c()) {
                event.ammount *= 1.0f - SHHelper.getArmorProtection((EntityPlayer)event.entity);
                if (event.ammount < 0.0f) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        Entity attacker = event.source.func_76346_g();
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            Hero hero = SHHelper.getHero(player);
            if (hero != null) {
                if (hero.hasAbility(Ability.enhancedReflexes) && !(event.source.func_76364_f() instanceof EntityBatarang)) {
                    EntityTrickArrow entity;
                    if (event.source.func_76364_f() instanceof EntityTrickArrow) {
                        entity = (EntityTrickArrow)event.source.func_76364_f();
                        if (player.func_70694_bm() == null && SHHelper.isPlayerLookingAt(player, (Entity)entity)) {
                            ItemStack itemstack = entity.getArrowItem().func_77946_l();
                            itemstack.field_77994_a = 1;
                            event.setCanceled(true);
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, itemstack);
                            entity.func_70106_y();
                        }
                    } else if (event.source.func_76364_f() instanceof EntityArrow) {
                        entity = (EntityArrow)event.source.func_76364_f();
                        if (player.func_70694_bm() == null && SHHelper.isPlayerLookingAt(player, (Entity)entity)) {
                            event.setCanceled(true);
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151032_g));
                            entity.func_70106_y();
                        }
                    }
                }
                if (hero.hasAbility(Ability.fireImmunity) && event.source.func_76347_k()) {
                    event.setCanceled(true);
                    player.func_70066_B();
                }
                if (hero.hasAbility(Ability.durability) && event.source.func_76364_f() instanceof EntityArrow) {
                    event.setCanceled(true);
                }
                if (hero.hasAbility(Ability.intangibility) && SHData.getBoolean(player, 12) && event.source == DamageSource.field_76368_d) {
                    event.setCanceled(true);
                }
                if (hero.hasAbility(Ability.sizeManipulation)) {
                    Random rand;
                    ISizeManipulation sizeManipulation = (ISizeManipulation)((Object)hero);
                    if (SHData.getFloat(player, 6) <= sizeManipulation.getMinSize(player) && !(event.source.func_76346_g() instanceof EntityPlayer) && (rand = new Random()).nextInt(3) != 0) {
                        event.setCanceled(true);
                        if (player.field_70172_ad == 0) {
                            player.field_70172_ad = 5;
                        }
                    }
                }
                if (hero.hasAbility(Ability.cactusPhysiology) && event.source == DamageSource.field_76367_g) {
                    event.setCanceled(true);
                }
            }
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.captainAmericasShield && player.func_71039_bw() && (SHHelper.canBlock(player, event.source) || event.source == DamageSource.field_76379_h && player.field_70125_A > 60.0f)) {
                event.setCanceled(true);
                if (player.field_70172_ad == 0) {
                    player.func_70694_bm().func_77972_a(1 + MathHelper.func_76128_c((double)event.ammount), (EntityLivingBase)player);
                    if (!event.source.func_76352_a()) {
                        player.field_70172_ad = 7;
                        if (attacker != null) {
                            SHHelper.knockback((EntityLivingBase)player, attacker, Math.min(event.ammount, 20.0f) / 5.0f);
                        }
                        if (!event.source.func_94541_c()) {
                            Random rand = new Random();
                            player.field_70170_p.func_72956_a((Entity)player, "fiskheroes:shield_hit", 0.6f, 0.8f + 0.1f * rand.nextFloat() - Math.min(event.ammount, 10.0f) / 50.0f);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            ItemStack[] aitemstack;
            EntityPlayer player = (EntityPlayer)event.entity;
            Hero hero = SHHelper.getHero(player);
            float f = event.distance;
            if (hero != null && (hero.hasAbility(Ability.flight1) || hero.hasAbility(Ability.flight2))) {
                event.setCanceled(true);
            }
            ItemStack helmet = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack legs = player.func_82169_q(1);
            ItemStack feet = player.func_82169_q(0);
            for (ItemStack itemstack : aitemstack = new ItemStack[]{helmet, chest, legs, feet}) {
                Multimap multimap;
                if (itemstack == helmet && helmet != null && chest != null && helmet.func_77973_b() instanceof ItemHeroArmor && SHHelper.getHeroFromArmor(helmet) != SHHelper.getHeroFromArmor(chest) || itemstack == null || !(itemstack.func_77973_b() instanceof ItemHeroArmor) || (multimap = itemstack.func_111283_C()).isEmpty()) continue;
                for (Object o : multimap.entries()) {
                    Map.Entry entry = (Map.Entry)o;
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    String s = (String)entry.getKey();
                    double d = attributemodifier.func_111164_d();
                    int operation = attributemodifier.func_111169_c();
                    if (!SHHelper.isPlayerHero(player) || !s.equals("armor.fallResistance")) continue;
                    if (operation == 0) {
                        event.distance = (float)((double)event.distance - d / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                        continue;
                    }
                    if (operation != 1) continue;
                    event.distance = (float)((double)event.distance - d * (double)f / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                }
            }
            if (SHData.getFloat(player, 6) > 1.0f) {
                event.distance /= SHData.getFloat(player, 6);
            }
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        List blocks = event.getAffectedBlocks();
        Explosion explosion = event.explosion;
        Entity entity = explosion.field_77283_e;
        World world = event.world;
        Random rand = new Random();
        for (int i = 0; i < blocks.size(); ++i) {
            ChunkPosition pos = (ChunkPosition)blocks.get(i);
            int x = pos.field_151329_a;
            int y = pos.field_151327_b;
            int z = pos.field_151328_c;
            Block block = world.func_147439_a(x, y, z);
            int metadata = world.func_72805_g(x, y, z);
            if (block != ModBlocks.iceLayer) continue;
            if (metadata == 0) {
                ++y;
            } else if (metadata == 1) {
                --y;
            } else if (metadata == 2) {
                ++z;
            } else if (metadata == 3) {
                --z;
            } else if (metadata == 4) {
                ++x;
            } else if (metadata == 5) {
                --x;
            }
            block = world.func_147439_a(x, y, z);
            if (block == Blocks.field_150350_a || !(block.func_149712_f(world, x, y, z) >= 0.0f)) continue;
            float f = entity.func_145772_a(explosion, world, x, y, z, block);
            blocks.add(new ChunkPosition(x, y, z));
        }
    }

    @SubscribeEvent
    public void onPlayerBreakBlock(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.entityPlayer;
        if (SHHelper.canRunSuperSpeed(player) && SHData.getBoolean(player, 0) && SHData.getInt(player, 1) >= 0) {
            event.newSpeed *= 2.0f;
        }
        event.newSpeed *= SHData.getFloat(player, 6);
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        Hero hero = SHHelper.getHero(player);
        ItemStack itemstack = player.func_70694_bm();
        if (itemstack != null && itemstack.func_77973_b() instanceof IDualItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        ItemStack itemstack = player.func_70694_bm();
        if (player.field_71075_bZ.field_75098_d && itemstack != null && itemstack.func_77973_b() instanceof IPunchWeapon) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        EntityPlayer player = event.player;
        ItemStack itemstack = event.crafting;
        if (itemstack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.suitFabricator)) {
            player.func_71029_a((StatBase)SHAchievements.suitFabricator);
        } else if (itemstack.func_77973_b() == ModItems.tachyonPrototype || itemstack.func_77973_b() == ModItems.tachyonDevice) {
            player.func_71029_a((StatBase)SHAchievements.tachyons);
        }
    }
}

