/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.generator;

import cpw.mods.fml.common.IWorldGenerator;
import fiskfille.heroes.common.block.ModBlocks;
import fiskfille.heroes.common.tileentity.TileEntityParticleCore;
import fiskfille.heroes.common.world.ModDimensions;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGeneratorOres
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int id = world.field_73011_w.field_76574_g;
        switch (id) {
            case 0: {
                this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
        }
        if (id == ModDimensions.QUANTUM_REALM_ID) {
            this.generateQuantumRealm(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    public void generateOverworld(World world, Random random, int chunkX, int chunkZ) {
        this.generateOre(7, ModBlocks.tutridiumOre, 1, 32, world, random, chunkX, chunkZ);
        this.generateOre(3, ModBlocks.vibraniumOre, 6, 16, world, random, chunkX, chunkZ);
    }

    public void generateNether(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateQuantumRealm(World world, Random random, int chunkX, int chunkZ) {
        this.generateParticle(ModBlocks.subatomicParticleShell, ModBlocks.subatomicParticleCore, 3000, 8, 16, world, random, chunkX, chunkZ);
        this.generateParticle(ModBlocks.tachyonicParticleShell, ModBlocks.tachyonicParticleCore, 6000, 4, 8, world, random, chunkX, chunkZ);
        this.generateParticle(Blocks.field_150348_b, ModBlocks.subatomicParticleCore, 3000, 4, 16, world, random, chunkX, chunkZ);
        this.generateParticle(Blocks.field_150343_Z, ModBlocks.subatomicParticleCore, 1200, 4, 8, world, random, chunkX, chunkZ);
        this.generateParticle(Blocks.field_150343_Z, ModBlocks.subatomicParticleCore, 3000, 16, 32, world, random, chunkX, chunkZ);
        this.generateParticle(Blocks.field_150432_aD, ModBlocks.subatomicParticleCore, 600, 4, 8, world, random, chunkX, chunkZ);
        this.generateParticle(Blocks.field_150424_aL, ModBlocks.subatomicParticleCore, 600, 4, 8, world, random, chunkX, chunkZ);
        this.generateParticle(Blocks.field_150368_y, ModBlocks.subatomicParticleCore, 600, 3, 6, world, random, chunkX, chunkZ);
        this.generateParticle((Block)Blocks.field_150399_cn, ModBlocks.subatomicParticleCore, 600, 3, 6, world, random, chunkX, chunkZ);
    }

    public void generateParticle(Block shell, Block core, int rarity, int min, int max, World world, Random random, int chunkX, int chunkZ) {
        for (int chunkY = 3; chunkY < 15; ++chunkY) {
            if (random.nextInt(rarity) != 0) continue;
            int x = chunkX + random.nextInt(16);
            int y = chunkY * 16 + random.nextInt(16);
            int z = chunkZ + random.nextInt(16);
            int range = MathHelper.func_76136_a((Random)random, (int)min, (int)max);
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    for (int k = -range; k <= range; ++k) {
                        Vec3 vec3 = Vec3.func_72443_a((double)((double)(x + i) + 0.5), (double)((double)(y + j) + 0.5), (double)((double)(z + k) + 0.5));
                        Vec3 vec31 = Vec3.func_72443_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
                        try {
                            Block block = shell;
                            Block block1 = shell;
                            if (shell == Blocks.field_150348_b) {
                                Block[] blocks = new Block[]{Blocks.field_150365_q, Blocks.field_150366_p, Blocks.field_150352_o, Blocks.field_150450_ax, Blocks.field_150482_ag, ModBlocks.tutridiumOre, ModBlocks.vibraniumOre};
                                block = blocks[random.nextInt(blocks.length)];
                                if (random.nextFloat() < 0.1f) {
                                    block1 = blocks[random.nextInt(blocks.length)];
                                }
                            } else if (shell == Blocks.field_150432_aD) {
                                if (random.nextFloat() < 0.2f) {
                                    block1 = Blocks.field_150403_cj;
                                }
                                block = Blocks.field_150403_cj;
                            } else if (shell == Blocks.field_150424_aL) {
                                if (random.nextFloat() < 0.2f) {
                                    block1 = Blocks.field_150449_bY;
                                }
                                block = Blocks.field_150426_aN;
                            } else if (shell == Blocks.field_150399_cn) {
                                block = Blocks.field_150371_ca;
                            }
                            if (vec31.func_72438_d(vec3) < (double)range && vec31.func_72438_d(vec3) >= (double)(range - 1)) {
                                world.func_147449_b(x + i, y + j, z + k, block1);
                                continue;
                            }
                            if (vec31.func_72438_d(vec3) < (double)(range / 4)) {
                                if (shell == Blocks.field_150343_Z && range > 8 && vec31.func_72438_d(vec3) < (double)(range / 4 - 1)) {
                                    world.func_147449_b(x + i, y + j, z + k, Blocks.field_150353_l);
                                    continue;
                                }
                                world.func_147449_b(x + i, y + j, z + k, block);
                                continue;
                            }
                            if (!(vec31.func_72438_d(vec3) < (double)range) || shell != Blocks.field_150343_Z || random.nextInt(50) != 0) continue;
                            world.func_147449_b(x + i, y + j, z + k, Blocks.field_150377_bs);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            world.func_147449_b(x, y, z, core);
            if (shell != ModBlocks.subatomicParticleShell && shell != ModBlocks.tachyonicParticleShell) {
                world.func_147449_b(x + 1, y, z, Blocks.field_150357_h);
                world.func_147449_b(x - 1, y, z, Blocks.field_150357_h);
                world.func_147449_b(x, y + 1, z, Blocks.field_150357_h);
                world.func_147449_b(x, y - 1, z, Blocks.field_150357_h);
                world.func_147449_b(x, y, z + 1, Blocks.field_150357_h);
                world.func_147449_b(x, y, z - 1, Blocks.field_150357_h);
            }
            if (!(world.func_147438_o(x, y, z) instanceof TileEntityParticleCore)) continue;
            TileEntityParticleCore tile = (TileEntityParticleCore)world.func_147438_o(x, y, z);
            tile.setRange(range);
        }
    }

    public void generateOre(int veinsPerChunk, Block block, int veinSize, int minY, World world, Random random, int chunkX, int chunkZ) {
        for (int i = 0; i < veinsPerChunk; ++i) {
            int randPosX = chunkX + random.nextInt(16);
            int randPosY = random.nextInt(minY);
            int randPosZ = chunkZ + random.nextInt(16);
            if (veinSize == 1) {
                if (!world.func_147439_a(randPosX, randPosY, randPosZ).isReplaceableOreGen(world, randPosX, randPosY, randPosZ, Blocks.field_150348_b)) continue;
                world.func_147449_b(randPosX, randPosY, randPosZ, block);
                continue;
            }
            new WorldGenMinable(block, veinSize).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }
}

