/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.heroes.SHReflection;
import fiskfille.heroes.asm.ASMHooks;
import fiskfille.heroes.client.render.Lightning;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.achievement.SHAchievements;
import fiskfille.heroes.common.config.SHConfig;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.data.SHPlayerData;
import fiskfille.heroes.common.entity.EntityEarthquake;
import fiskfille.heroes.common.helper.VectorHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.hero.ISizeManipulation;
import fiskfille.heroes.common.hero.speedster.Speedster;
import fiskfille.heroes.common.item.IDualItem;
import fiskfille.heroes.common.item.ItemFlashRing;
import fiskfille.heroes.common.item.ModItems;
import fiskfille.heroes.common.item.armor.ItemHeroArmor;
import fiskfille.heroes.common.network.PacketKnockback;
import fiskfille.heroes.common.network.SHNetworkManager;
import fiskfille.heroes.common.tileentity.TileEntityTreadmill;
import fiskfille.heroes.common.utilitybelt.EnumUtilityBelt;
import fiskfille.heroes.common.world.ModDimensions;
import fiskfille.heroes.common.world.TeleporterQuantumRealm;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;

public class SHHelper {
    public static boolean isPlayerHero(EntityPlayer player) {
        Hero helmet = SHHelper.getHeroFromArmor(player, 3);
        Hero chest = SHHelper.getHeroFromArmor(player, 2);
        Hero legs = SHHelper.getHeroFromArmor(player, 1);
        Hero feet = SHHelper.getHeroFromArmor(player, 0);
        if ((helmet == null || helmet != chest) && chest != null && chest.getHelmet() == null) {
            return player.func_82169_q(3) == null && chest == legs && legs == feet;
        }
        return helmet != null && helmet == chest && chest == legs && legs == feet;
    }

    public static boolean isPlayerHero(ItemStack[] itemstacks) {
        Hero helmet = SHHelper.getHeroFromArmor(itemstacks[0]);
        Hero chest = SHHelper.getHeroFromArmor(itemstacks[1]);
        Hero legs = SHHelper.getHeroFromArmor(itemstacks[2]);
        Hero feet = SHHelper.getHeroFromArmor(itemstacks[3]);
        if ((helmet == null || helmet != chest) && chest != null && chest.getHelmet() == null) {
            return itemstacks[0] == null && chest == legs && legs == feet;
        }
        return helmet != null && helmet == chest && chest == legs && legs == feet;
    }

    public static boolean isPlayerSpeedster(EntityPlayer player) {
        return SHHelper.getHero(player) instanceof Speedster;
    }

    public static boolean isPlayerSpeedster(ItemStack[] itemstacks) {
        return SHHelper.getHero(itemstacks) instanceof Speedster;
    }

    public static Hero getHero(EntityPlayer player) {
        if (player != null && SHHelper.isPlayerHero(player)) {
            return SHHelper.getHeroFromArmor(player, 0);
        }
        return null;
    }

    public static Speedster getSpeedster(EntityPlayer player) {
        return SHHelper.getHero(player) instanceof Speedster ? (Speedster)SHHelper.getHero(player) : null;
    }

    public static Hero getHero(ItemStack[] itemstacks) {
        if (SHHelper.isPlayerHero(itemstacks)) {
            return SHHelper.getHeroFromArmor(itemstacks[1]);
        }
        return null;
    }

    public static Hero getHeroFromArmor(EntityPlayer player, int slot) {
        Item currentArmor;
        ItemStack currentArmorStack = player.func_82169_q(slot);
        if (currentArmorStack != null && (currentArmor = currentArmorStack.func_77973_b()) instanceof ItemHeroArmor) {
            return ((ItemHeroArmor)currentArmor).getHero();
        }
        return null;
    }

    public static Hero getHeroFromArmor(ItemStack itemstack) {
        Item item;
        if (itemstack != null && (item = itemstack.func_77973_b()) instanceof ItemHeroArmor) {
            return ((ItemHeroArmor)item).getHero();
        }
        return null;
    }

    public static boolean canRunSuperSpeed(EntityPlayer player) {
        return SHHelper.getHero(player) != null && SHHelper.getHero(player).hasAbility(Ability.superSpeed) || SHData.getInt(player, 31) > 0;
    }

    public static boolean areAllPlayersSlowMotion(World world) {
        List players = world.field_73010_i;
        for (EntityPlayer player : players) {
            Hero hero = SHHelper.getHero(player);
            if (hero != null && hero.hasAbility(Ability.slowMotion) && SHData.getBoolean(player, 2) && player.func_70089_S()) continue;
            return false;
        }
        return true;
    }

    public static TileEntityTreadmill getTreadmill(EntityPlayer player) {
        for (TileEntity tileentity : player.field_70170_p.field_147482_g) {
            if (!(tileentity instanceof TileEntityTreadmill)) continue;
            TileEntityTreadmill tile = (TileEntityTreadmill)tileentity;
            if (tile.playerId != player.func_145782_y()) continue;
            return tile;
        }
        return null;
    }

    public static boolean isOnTreadmill(EntityPlayer player) {
        return SHHelper.getTreadmill(player) != null;
    }

    public static float getArmorProtection(EntityPlayer player) {
        if (SHHelper.isPlayerHero(player)) {
            ItemStack helmet = player.func_82169_q(3);
            ItemStack chest = player.func_82169_q(2);
            ItemStack legs = player.func_82169_q(1);
            ItemStack feet = player.func_82169_q(0);
            ItemStack[] aitemstack = new ItemStack[]{helmet, chest, legs, feet};
            float amount = 0.0f;
            float durability = 0.0f;
            for (ItemStack itemstack : aitemstack) {
                if (itemstack == helmet && helmet != null && chest != null && helmet.func_77973_b() instanceof ItemHeroArmor && SHHelper.getHeroFromArmor(helmet) != SHHelper.getHeroFromArmor(chest) || itemstack == null || !(itemstack.func_77973_b() instanceof ItemHeroArmor)) continue;
                Multimap multimap = itemstack.func_111283_C();
                if (!multimap.isEmpty()) {
                    for (Object o : multimap.entries()) {
                        Map.Entry entry = (Map.Entry)o;
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        String s = (String)entry.getKey();
                        double d = attributemodifier.func_111164_d();
                        int operation = attributemodifier.func_111169_c();
                        if (!s.equals("armor.damageReduction") || operation != 1) continue;
                        amount = (float)((double)amount + d / (double)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
                    }
                }
                if (SHConfig.durabilityScaledProtection) {
                    durability += (float)(itemstack.func_77958_k() - itemstack.func_77960_j()) / (float)itemstack.func_77958_k();
                    continue;
                }
                durability += 1.0f;
            }
            return amount * (durability / (float)SHHelper.getPiecesToSet(SHHelper.getHero(player)));
        }
        return 0.0f;
    }

    public static int getPiecesToSet(Hero hero) {
        if (hero.getHelmet() == null) {
            return 3;
        }
        return 4;
    }

    public static void doEarthquake(EntityPlayer player, int x, int y, int z) {
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            EntityEarthquake entity = new EntityEarthquake(world, (EntityLivingBase)player);
            entity.field_70165_t = (float)x + 0.5f;
            entity.field_70163_u = (float)y + 0.5f;
            entity.field_70161_v = (float)z + 0.5f;
            world.func_72838_d((Entity)entity);
        }
    }

    public static void doGroundSmash(EntityPlayer player, int x, int y, int z) {
        World world = player.field_70170_p;
        Random rand = new Random();
        ArrayList list = Lists.newArrayList();
        if (!world.field_72995_K) {
            int radius = 3;
            if (SHConfig.geomancerExplosions) {
                for (int i = -radius; i <= radius; ++i) {
                    for (int j = -radius / 2; j <= radius; ++j) {
                        for (int k = -radius; k <= radius; ++k) {
                            Block block = world.func_147439_a(x + i, y + j, z + k);
                            int metadata = world.func_72805_g(x + i, y + j, z + k);
                            if (!(i <= radius - 2 && j <= radius - 2 && k <= radius - 2 || i >= -radius + 2 && j >= -radius + 2 && k >= -radius + 2) && rand.nextInt(3) == 0 || block == Blocks.field_150350_a || !block.func_149747_d((IBlockAccess)world, x + i, y + j, z + k, 0) || !(block.func_149712_f(world, x + i, y + j, z + k) >= 0.0f)) continue;
                            EntityFallingBlock entity = new EntityFallingBlock(world, (double)((float)(x + i) + 0.5f), (double)((float)(y + j) + 0.5f), (double)((float)(z + k) + 0.5f), block, metadata);
                            entity.field_70181_x += 0.5;
                            entity.field_145812_b = -100;
                            entity.field_145813_c = false;
                            NBTTagCompound nbt = new NBTTagCompound();
                            entity.func_70109_d(nbt);
                            nbt.func_74776_a("FallHurtAmount", 100.0f);
                            nbt.func_74768_a("FallHurtMax", 100);
                            entity.func_70020_e(nbt);
                            list.add(entity);
                            world.func_72838_d((Entity)entity);
                            world.func_147449_b(x + i, y + j, z + k, Blocks.field_150350_a);
                        }
                    }
                }
            }
            for (EntityLivingBase entity : world.func_82733_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(x - radius), (double)(y - radius), (double)(z - radius), (double)(x + radius), (double)(y + radius), (double)(z + radius)), IEntitySelector.field_94557_a)) {
                float f = (float)(((double)radius - entity.func_70011_f((double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) / (double)radius);
                entity.func_70097_a(new EntityDamageSource("explosion.player", (Entity)player).func_94540_d(), 15.0f * f);
                SHHelper.knockbackWithoutNotify(entity, (Entity)player, 3.0f * f);
            }
            world.func_72876_a((Entity)player, (double)x, (double)y, (double)z, 2.5f, false);
        }
    }

    public static boolean canBlock(EntityPlayer player, DamageSource source) {
        Entity entity = source.func_76364_f();
        if (!(entity == null || source.func_76347_k() || source.func_82725_o() || source.func_76363_c())) {
            Vec3 vec3 = player.func_70676_i(1.0f).func_72432_b();
            Vec3 vec31 = Vec3.func_72443_a((double)(entity.field_70165_t - player.field_70165_t), (double)(entity.field_70121_D.field_72338_b + (double)(entity.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e())), (double)(entity.field_70161_v - player.field_70161_v));
            double d0 = vec31.func_72433_c();
            double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
            return d1 > 1.0 - 0.75 / d0;
        }
        return false;
    }

    public static boolean isPlayerLookingAt(EntityPlayer player, Entity entity) {
        Vec3 vec3 = player.func_70676_i(1.0f).func_72432_b();
        Vec3 vec31 = Vec3.func_72443_a((double)(entity.field_70165_t - player.field_70165_t), (double)(entity.field_70121_D.field_72338_b + (double)(entity.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e())), (double)(entity.field_70161_v - player.field_70161_v));
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 0.5 / d0 && player.func_70685_l(entity);
    }

    public static void knockbackWithoutNotify(EntityLivingBase entity, Entity attacker, float amount) {
        if (attacker != null) {
            double d1 = attacker.field_70165_t - entity.field_70165_t;
            double d0 = attacker.field_70161_v - entity.field_70161_v;
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            entity.field_70739_aP = (float)(Math.atan2(d0, d1) * 180.0 / Math.PI) - entity.field_70177_z;
            entity.func_70653_a(attacker, 0.0f, d1 * (double)amount, d0 * (double)amount);
            entity.field_70159_w *= (double)amount;
            entity.field_70179_y *= (double)amount;
        }
    }

    public static void knockback(EntityLivingBase entity, Entity attacker, float amount) {
        if (entity.field_70170_p.field_72995_K) {
            SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketKnockback(entity, attacker, amount));
        } else {
            SHNetworkManager.networkWrapper.sendToDimension((IMessage)new PacketKnockback(entity, attacker, amount), entity.field_71093_bK);
        }
        SHHelper.knockbackWithoutNotify(entity, attacker, amount);
    }

    public static float getDefaultScale(EntityPlayer player) {
        Hero hero = SHHelper.getHero(player);
        if (hero != null) {
            float defScale = hero.getDefaultScale(player);
            if (hero.hasAbility(Ability.shapeShifting)) {
                float f = SHData.getFloat(player, 10);
                String disguise = SHData.getString(player, 9);
                String from = SHData.getString(player, 23);
                String to = SHData.getString(player, 24);
                if (StringUtils.func_151246_b((String)from) && StringUtils.func_151246_b((String)to)) {
                    return defScale;
                }
                if (!StringUtils.func_151246_b((String)from) && StringUtils.func_151246_b((String)to)) {
                    f = 1.0f - f;
                }
                if (!StringUtils.func_151246_b((String)from) && !StringUtils.func_151246_b((String)to)) {
                    return 1.0f;
                }
                return 1.0f + (defScale - 1.0f) * f;
            }
            return defScale;
        }
        return 1.0f;
    }

    public static int getItemsInInventory(EntityPlayer player, Item item) {
        int amount = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (itemstack == null || itemstack.func_77973_b() != item) continue;
            ++amount;
        }
        return amount;
    }

    public static String getConventionalName(String s) {
        String s1 = s.replace(" ", "").replace("'", "").replace("/", "").replace("\\", "").replace("_", "").replace("-", "").replace("(", "").replace(")", "");
        return s1.substring(0, 1).toLowerCase() + s1.substring(1);
    }

    public static String getUnconventionalName(String s) {
        s = s.toLowerCase();
        for (int i = 0; i < s.length(); ++i) {
            if (i <= 0 || s.charAt(i - 1) != '_' || i >= s.length()) continue;
            s = s.substring(0, i) + s.substring(i, i + 1).toUpperCase() + s.substring(i + 1);
        }
        s = s.replace(" ", "").replace("'", "").replace("/", "").replace("\\", "").replace("_", "").replace("-", "").replace("(", "").replace(")", "");
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static boolean canPlayerRunOnWater(EntityPlayer player) {
        return SHHelper.canRunSuperSpeed(player) && SHData.getBoolean(player, 0) && SHData.getInt(player, 1) >= 3 && !player.func_70090_H() && player.func_70051_ag();
    }

    public static boolean canPlayerRunUpWall(EntityPlayer player) {
        return SHHelper.canRunSuperSpeed(player) && SHData.getBoolean(player, 0) && SHData.getInt(player, 1) >= 3 && player.func_70051_ag();
    }

    public static Lightning createLightning(Vec3 color, long seed, float length) {
        Random rand = new Random();
        if (seed != 0L) {
            rand.setSeed(seed);
        }
        Lightning lightning = new Lightning(rand.nextFloat() * length, color).setRotation(rand.nextFloat() * 360.0f, rand.nextFloat() * 360.0f, rand.nextFloat() * 360.0f);
        SHHelper.branchLightning(lightning, rand, length, 0);
        return lightning;
    }

    private static void branchLightning(Lightning lightning, Random rand, float length, int branches) {
        Lightning lightning1 = new Lightning(rand.nextFloat() * length).setRotation(rand.nextFloat() * 90.0f, rand.nextFloat() * 90.0f, rand.nextFloat() * 90.0f);
        lightning.addChild(lightning1);
        if (branches < 10 && rand.nextDouble() < 1.0 - (double)branches * 0.1) {
            SHHelper.branchLightning(lightning1, rand, length, ++branches);
        }
        if (rand.nextDouble() < 0.1) {
            SHHelper.branchLightning(lightning, rand, length, 7);
        }
    }

    public static EnumUtilityBelt getUtilityBelt(EntityPlayer player) {
        return EnumUtilityBelt.values()[SHData.getInt(player, 37)];
    }

    public static ItemStack getEquippedTachyonDevice(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        ItemStack itemstack1 = null;
        for (int i = 0; i < inventory.field_70462_a.length; ++i) {
            ItemStack itemstack = inventory.field_70462_a[i];
            if (itemstack == null || itemstack.func_77973_b() != ModItems.tachyonDevice) continue;
            if (itemstack1 == null) {
                itemstack1 = itemstack;
            }
            if (itemstack.func_77960_j() >= itemstack.func_77958_k()) continue;
            return itemstack;
        }
        return itemstack1;
    }

    public static boolean hasTachyonDevice(EntityPlayer player) {
        return player.field_71071_by.func_146028_b(ModItems.tachyonDevice) && (player.func_70694_bm() == null || player.func_70694_bm().func_77973_b() != ModItems.tachyonDevice);
    }

    public static boolean shouldOverrideScale(EntityPlayer player, float scale) {
        float widthScale = scale;
        float heightScale = scale;
        if (SHHelper.getHero(player) == null && SHData.get(player, 33) != null || !SHData.getBoolean(player, 42) && SHData.getBoolean(player, 43)) {
            heightScale = 1.0f;
            widthScale = 1.0f;
            return true;
        }
        if (SHData.getBoolean(player, 42)) {
            heightScale *= 0.33333334f;
        }
        return !player.func_70089_S() || (SHHelper.getHero(player) != null || SHData.get(player, 33) != null || SHData.getBoolean(player, 42) || SHData.getBoolean(player, 43)) && (heightScale != 1.8f / player.field_70131_O || widthScale != 0.6f / player.field_70130_N);
    }

    public static boolean shouldOverrideReachDistance(EntityPlayer player) {
        return ASMHooks.getModifiedEntityScale((Entity)player) > 1.0f;
    }

    public static void swingOffhandItem(EntityPlayer player) {
        Item item;
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() != null && ((IDualItem)(item = stack.func_77973_b())).onEntitySwingOffHand(player, stack)) {
            return;
        }
        if (!SHData.getBoolean(player, 25) || SHData.getInt(player, 26) >= (Integer)SHReflection.getMethod(SHReflection.getArmSwingAnimationEndMethod, player, new Object[0]) / 2 || SHData.getInt(player, 26) < 0) {
            SHData.setWithoutNotify(player, 26, -1);
            SHData.setWithoutNotify(player, 25, true);
        }
    }

    public static float getTachyonCharge(EntityPlayer player) {
        Hero hero = SHHelper.getHero(player);
        float f = 0.0f;
        if (hero == null) {
            return f;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack itemstack1 = player.func_82169_q(i);
            if (itemstack1 == null || SHHelper.getHeroFromArmor(itemstack1) != hero) continue;
            if (!itemstack1.func_77942_o()) {
                itemstack1.func_77982_d(new NBTTagCompound());
            }
            f += (float)itemstack1.func_77978_p().func_74762_e("TachyonCharge");
        }
        f /= (float)SHHelper.getPiecesToSet(hero);
        return f /= 200.0f;
    }

    public static void miniaturizeSuit(EntityPlayer player) {
        ItemStack itemstack = new ItemStack(ModItems.miniATOMSuit);
        itemstack.func_77982_d(new NBTTagCompound());
        ItemFlashRing.setNBTData(player.func_71124_b(4), player.func_71124_b(3), player.func_71124_b(2), player.func_71124_b(1), itemstack);
        for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
            player.func_70062_b(i + 1, null);
        }
        player.func_70062_b(0, itemstack);
    }

    public static String formatNumber(float f) {
        String s = (long)f + "";
        if (!s.contains("E")) {
            String s1 = "";
            for (int i = 0; i < s.length(); ++i) {
                s1 = s1 + s.charAt(i);
                if ((s.length() - i) % 3 != 1) continue;
                s1 = s1 + ",";
            }
            return s1.substring(0, s1.length() - 1);
        }
        return s;
    }

    public static String formatHero(Hero hero) {
        String s = hero.getName();
        if (s.contains("/")) {
            s = String.format("%s (%s)", s.substring(0, s.indexOf("/")), s.substring(s.indexOf("/") + 1));
        }
        return s;
    }

    public static void setInQuantumRealm(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            int dimension = SHData.getInt(player, 48);
            double x = SHData.getDouble(player, 49);
            double y = SHData.getDouble(player, 50);
            double z = SHData.getDouble(player, 51);
            SHData.setWithoutNotify(player, 48, player.field_71093_bK);
            SHData.setWithoutNotify(player, 49, player.field_70165_t);
            SHData.setWithoutNotify(player, 50, player.field_70163_u);
            SHData.setWithoutNotify(player, 51, player.field_70161_v);
            if (player.field_71093_bK != ModDimensions.QUANTUM_REALM_ID) {
                SHData.setWithoutNotify(player, 6, Float.valueOf(SHHelper.getDefaultScale(player)));
                SHData.setWithoutNotify(player, 22, 0);
                playerMP.field_71133_b.func_71203_ab().transferPlayerToDimension(playerMP, ModDimensions.QUANTUM_REALM_ID, (Teleporter)new TeleporterQuantumRealm(playerMP.field_71133_b.func_71218_a(ModDimensions.QUANTUM_REALM_ID)));
                playerMP.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
                player.func_71029_a((StatBase)SHAchievements.quantumRealm);
            } else {
                ISizeManipulation sizeManipulation;
                playerMP.field_71133_b.func_71203_ab().transferPlayerToDimension(playerMP, dimension, (Teleporter)new TeleporterQuantumRealm(playerMP.field_71133_b.func_71218_a(dimension)));
                playerMP.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
                if (SHHelper.getHero(player) instanceof ISizeManipulation && (sizeManipulation = (ISizeManipulation)((Object)SHHelper.getHero(player))).isInstant(player)) {
                    SHData.setWithoutNotify(player, 6, Float.valueOf(sizeManipulation.getMinSize(player)));
                    SHData.setWithoutNotify(player, 34, Float.valueOf(sizeManipulation.getMinSize(player)));
                    SHData.set(player, 15, true);
                    SHData.set(player, 14, false);
                }
            }
        }
    }

    public static int getSideStandingOn(EntityPlayer player) {
        return 1;
    }

    public static float getStepDownHeight(EntityPlayer player) {
        return SHHelper.canRunSuperSpeed(player) && SHData.getBoolean(player, 0) && SHData.getInt(player, 1) >= 0 ? 2.0f : 0.0f;
    }

    public static Vec3 getHeatVisionVec(EntityPlayer player, int side, boolean start, float partialTicks) {
        double range = 32.0;
        float f = 1.62f;
        float scale = SHData.getFloat(player, 6) + (SHData.getFloat(player, 6) - SHData.getFloat(player, 34)) * partialTicks;
        Vec3 src = VectorHelper.getOffsetCoords(player, 0.115f * (float)(side * 2 - 1) * scale, 0.21f * scale, 0.235f * scale, partialTicks).func_72441_c(0.0, (double)(1.4125f * scale - f), 0.0);
        Vec3 src1 = VectorHelper.getOffsetCoords(player, 0.0, 0.21f * scale, 0.235f * scale, partialTicks).func_72441_c(0.0, (double)(1.4125f * scale - f), 0.0);
        Vec3 dst = VectorHelper.getOffsetCoords(player, 0.0, 0.21f * scale, ((double)0.235f + range) * (double)scale, partialTicks).func_72441_c(0.0, (double)(1.4125f * scale - f), 0.0);
        MovingObjectPosition mop = player.field_70170_p.func_72933_a(VectorHelper.copy(src1), VectorHelper.copy(dst));
        Vec3 vec3 = null;
        vec3 = mop == null ? dst : mop.field_72307_f;
        if (start) {
            return src.func_72441_c(0.0, (double)f, 0.0);
        }
        return vec3.func_72441_c(0.0, (double)f, 0.0);
    }

    public static MovingObjectPosition getHeatVisionMOP(EntityPlayer player, float partialTicks) {
        double range = 32.0;
        float f = 1.62f;
        float scale = SHData.getFloat(player, 6) + (SHData.getFloat(player, 6) - SHData.getFloat(player, 34)) * partialTicks;
        Vec3 src = VectorHelper.getOffsetCoords(player, 0.0, 0.21f * scale, 0.235f * scale, partialTicks).func_72441_c(0.0, (double)(1.4125f - f), 0.0);
        Vec3 dst = VectorHelper.getOffsetCoords(player, 0.0, 0.21f * scale, ((double)0.235f + range) * (double)scale, partialTicks).func_72441_c(0.0, (double)(1.4125f - f), 0.0);
        MovingObjectPosition mop = player.field_70170_p.func_72933_a(VectorHelper.copy(src), VectorHelper.copy(dst));
        Vec3 vec3 = null;
        vec3 = mop == null ? dst : mop.field_72307_f;
        double dist = player.func_70011_f(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
        block0: for (double d = 0.0; d < dist; d += 0.15) {
            double progress = MathHelper.func_151237_a((double)d, (double)0.0, (double)dist) / dist;
            Vec3 vec31 = Vec3.func_72443_a((double)SHHelper.getProgress(src.field_72450_a, dst.field_72450_a, progress), (double)SHHelper.getProgress(src.field_72448_b, dst.field_72448_b, progress), (double)SHHelper.getProgress(src.field_72449_c, dst.field_72449_c, progress));
            for (EntityLivingBase entity : VectorHelper.getEntitiesNear(player.field_70170_p, vec31.field_72450_a, vec31.field_72448_b, vec31.field_72449_c, 0.5)) {
                if (entity == null || entity == player) continue;
                vec3.field_72450_a = entity.field_70165_t;
                vec3.field_72448_b = entity.field_70163_u;
                vec3.field_72449_c = entity.field_70161_v;
                mop = new MovingObjectPosition((Entity)entity, vec3);
                dist = player.func_70011_f(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
                continue block0;
            }
        }
        return mop;
    }

    public static double getProgress(double a, double b, double progress) {
        return a + (b - a) * progress;
    }

    public static Block getHeatVisionResult(Block block, int metadata) {
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block, 1, metadata == -1 ? Short.MAX_VALUE : metadata));
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemBlock) {
            return Block.func_149634_a((Item)itemstack.func_77973_b());
        }
        return null;
    }

    public static boolean hasCollectedHero(EntityPlayer player, Hero hero) {
        List<Item> list = SHPlayerData.getData((EntityPlayer)player).suitsCollected;
        if (hero != null) {
            return list.contains(hero.getBoots()) && list.contains(hero.getLeggings()) && list.contains(hero.getChestplate()) && (hero.getHelmet() == null || list.contains(hero.getHelmet()));
        }
        return false;
    }
}

