/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.helper;

import fiskfille.heroes.client.SuperHeroesAPIClient;
import fiskfille.heroes.client.model.ModelBipedMultiLayer;
import fiskfille.heroes.client.particle.EntitySHLightningFX;
import fiskfille.heroes.client.render.Lightning;
import fiskfille.heroes.client.render.hero.HeroRenderer;
import fiskfille.heroes.common.config.SHConfig;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.event.ClientEventHandler;
import fiskfille.heroes.common.helper.IOffhandRender;
import fiskfille.heroes.common.helper.SHEnumHelper;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.helper.SpeedsterHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.item.IDualItem;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class SHRenderHelper {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static float lastBrightnessX;
    private static float lastBrightnessY;

    public static void setLighting(int lighting) {
        SHRenderHelper.storeLighting();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)(lighting % 65536) / 255.0f), (float)((float)(lighting / 65536) / 255.0f));
    }

    public static void storeLighting() {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
    }

    public static void resetLighting() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void setGlColor(Color color, float alpha) {
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)alpha);
    }

    public static void setGlColor(Color color) {
        SHRenderHelper.setGlColor(color, (float)color.getAlpha() / 255.0f);
    }

    public static void setVecColor(Vec3 vec) {
        GL11.glColor4f((float)((float)vec.field_72450_a), (float)((float)vec.field_72448_b), (float)((float)vec.field_72449_c), (float)1.0f);
    }

    public static void applyColorFromItemStack(ItemStack itemstack, int pass) {
        int color = itemstack.func_77973_b().func_82790_a(itemstack, pass);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void setAlpha(float alpha) {
        float[] colors = new float[4];
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)16);
        floatBuffer.rewind();
        GL11.glGetFloat((int)2816, (FloatBuffer)floatBuffer);
        GL11.glColor4f((float)floatBuffer.get(), (float)floatBuffer.get(), (float)floatBuffer.get(), (float)alpha);
    }

    public static Color fade(Color from, Color to, float percentage) {
        percentage = MathHelper.func_76131_a((float)percentage, (float)0.0f, (float)1.0f);
        float f = 1.0f - percentage;
        return new Color((float)from.getRed() * f + (float)to.getRed() * percentage, (float)from.getGreen() * f + (float)to.getGreen() * percentage, (float)from.getBlue() * f + (float)to.getBlue() * percentage);
    }

    public static Color blend(Color c1, Color c2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        Float iRatio = Float.valueOf(1.0f - ratio);
        int i1 = c1.getRGB();
        int i2 = c2.getRGB();
        int a1 = i1 >> 24 & 0xFF;
        int r1 = (i1 & 0xFF0000) >> 16;
        int g1 = (i1 & 0xFF00) >> 8;
        int b1 = i1 & 0xFF;
        int a2 = i2 >> 24 & 0xFF;
        int r2 = (i2 & 0xFF0000) >> 16;
        int g2 = (i2 & 0xFF00) >> 8;
        int b2 = i2 & 0xFF;
        int a = (int)((float)a1 * iRatio.floatValue() + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio.floatValue() + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio.floatValue() + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio.floatValue() + (float)b2 * ratio);
        return new Color(a << 24 | r << 16 | g << 8 | b);
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        ScaledResolution reso = new ScaledResolution(mc, SHRenderHelper.mc.field_71443_c, SHRenderHelper.mc.field_71440_d);
        double scaleW = (double)SHRenderHelper.mc.field_71443_c / reso.func_78327_c();
        double scaleH = (double)SHRenderHelper.mc.field_71440_d / reso.func_78324_d();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)SHRenderHelper.mc.field_71440_d - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)SHRenderHelper.mc.field_71440_d - (double)y * scaleH) - (int)Math.floor((double)SHRenderHelper.mc.field_71440_d - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        GL11.glDisable((int)3089);
    }

    public static void renderFire(Entity entity, float scale, float scaleY) {
        GL11.glPushMatrix();
        SHRenderHelper.setLighting(61680);
        float x = -0.5f;
        float y = 0.0f;
        float z = -0.5f;
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon iicon = Blocks.field_150480_ab.func_149840_c(0);
        IIcon iicon1 = Blocks.field_150480_ab.func_149840_c(1);
        double d0 = iicon.func_94209_e();
        double d1 = iicon.func_94206_g();
        double d2 = iicon.func_94212_f();
        double d3 = iicon.func_94210_h();
        TextureManager textureManager = mc.func_110434_K();
        mc.func_147117_R();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        tessellator.func_78382_b();
        double d4 = (double)x + 0.5 + 0.2;
        double d5 = (double)x + 0.5 - 0.2;
        double d6 = (double)z + 0.5 + 0.2;
        double d7 = (double)z + 0.5 - 0.2;
        double d8 = (double)x + 0.5 - 0.3;
        double d9 = (double)x + 0.5 + 0.3;
        double d10 = (double)z + 0.5 - 0.3;
        double d11 = (double)z + 0.5 + 0.3;
        tessellator.func_78374_a(d8, (double)(y + scaleY), (double)(z + 1.0f), d2, d1);
        tessellator.func_78374_a(d4, (double)(y + 0.0f), (double)(z + 1.0f), d2, d3);
        tessellator.func_78374_a(d4, (double)(y + 0.0f), (double)(z + 0.0f), d0, d3);
        tessellator.func_78374_a(d8, (double)(y + scaleY), (double)(z + 0.0f), d0, d1);
        tessellator.func_78374_a(d9, (double)(y + scaleY), (double)(z + 0.0f), d2, d1);
        tessellator.func_78374_a(d5, (double)(y + 0.0f), (double)(z + 0.0f), d2, d3);
        tessellator.func_78374_a(d5, (double)(y + 0.0f), (double)(z + 1.0f), d0, d3);
        tessellator.func_78374_a(d9, (double)(y + scaleY), (double)(z + 1.0f), d0, d1);
        d0 = iicon1.func_94209_e();
        d1 = iicon1.func_94206_g();
        d2 = iicon1.func_94212_f();
        d3 = iicon1.func_94210_h();
        tessellator.func_78374_a((double)(x + 1.0f), (double)(y + scaleY), d11, d2, d1);
        tessellator.func_78374_a((double)(x + 1.0f), (double)(y + 0.0f), d7, d2, d3);
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), d7, d0, d3);
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + scaleY), d11, d0, d1);
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + scaleY), d10, d2, d1);
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), d6, d2, d3);
        tessellator.func_78374_a((double)(x + 1.0f), (double)(y + 0.0f), d6, d0, d3);
        tessellator.func_78374_a((double)(x + 1.0f), (double)(y + scaleY), d10, d0, d1);
        d4 = (double)x + 0.5 - 0.5;
        d5 = (double)x + 0.5 + 0.5;
        d6 = (double)z + 0.5 - 0.5;
        d7 = (double)z + 0.5 + 0.5;
        d8 = (double)x + 0.5 - 0.4;
        d9 = (double)x + 0.5 + 0.4;
        d10 = (double)z + 0.5 - 0.4;
        d11 = (double)z + 0.5 + 0.4;
        tessellator.func_78374_a(d8, (double)(y + scaleY), (double)(z + 0.0f), d0, d1);
        tessellator.func_78374_a(d4, (double)(y + 0.0f), (double)(z + 0.0f), d0, d3);
        tessellator.func_78374_a(d4, (double)(y + 0.0f), (double)(z + 1.0f), d2, d3);
        tessellator.func_78374_a(d8, (double)(y + scaleY), (double)(z + 1.0f), d2, d1);
        tessellator.func_78374_a(d9, (double)(y + scaleY), (double)(z + 1.0f), d0, d1);
        tessellator.func_78374_a(d5, (double)(y + 0.0f), (double)(z + 1.0f), d0, d3);
        tessellator.func_78374_a(d5, (double)(y + 0.0f), (double)(z + 0.0f), d2, d3);
        tessellator.func_78374_a(d9, (double)(y + scaleY), (double)(z + 0.0f), d2, d1);
        d0 = iicon.func_94209_e();
        d1 = iicon.func_94206_g();
        d2 = iicon.func_94212_f();
        d3 = iicon.func_94210_h();
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + scaleY), d11, d0, d1);
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), d7, d0, d3);
        tessellator.func_78374_a((double)(x + 1.0f), (double)(y + 0.0f), d7, d2, d3);
        tessellator.func_78374_a((double)(x + 1.0f), (double)(y + scaleY), d11, d2, d1);
        tessellator.func_78374_a((double)(x + 1.0f), (double)(y + scaleY), d10, d0, d1);
        tessellator.func_78374_a((double)(x + 1.0f), (double)(y + 0.0f), d6, d0, d3);
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), d6, d2, d3);
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + scaleY), d10, d2, d1);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        tessellator.func_78381_a();
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        SHRenderHelper.resetLighting();
        GL11.glPopMatrix();
    }

    public static void renderSpike(float scale, int tip, int length) {
        float ftip = scale * (float)tip;
        float flength = scale * (float)length;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)(-scale / 2.0f), 0.0, (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), 0.0, (double)(scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), 0.0, (double)(scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), 0.0, (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), (double)(-flength), (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), (double)(-flength), (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), 0.0, (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), 0.0, (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), 0.0, (double)(scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), (double)(-flength), (double)(scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), (double)(-flength), (double)(scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), 0.0, (double)(scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), 0.0, (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), (double)(-flength), (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), (double)(-flength), (double)(scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), 0.0, (double)(scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), (double)(-flength), (double)(scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), (double)(-flength), (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), 0.0, (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), 0.0, (double)(scale / 2.0f));
        tessellator.func_78377_a(0.0, (double)(-ftip - flength), 0.0);
        tessellator.func_78377_a(0.0, (double)(-ftip - flength), 0.0);
        tessellator.func_78377_a((double)(-scale / 2.0f), (double)(-flength), (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), (double)(-flength), (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), (double)(-flength), (double)(scale / 2.0f));
        tessellator.func_78377_a(0.0, (double)(-ftip - flength), 0.0);
        tessellator.func_78377_a(0.0, (double)(-ftip - flength), 0.0);
        tessellator.func_78377_a((double)(scale / 2.0f), (double)(-flength), (double)(scale / 2.0f));
        tessellator.func_78377_a((double)(-scale / 2.0f), (double)(-flength), (double)(-scale / 2.0f));
        tessellator.func_78377_a(0.0, (double)(-ftip - flength), 0.0);
        tessellator.func_78377_a(0.0, (double)(-ftip - flength), 0.0);
        tessellator.func_78377_a((double)(-scale / 2.0f), (double)(-flength), (double)(scale / 2.0f));
        tessellator.func_78377_a(0.0, (double)(-ftip - flength), 0.0);
        tessellator.func_78377_a(0.0, (double)(-ftip - flength), 0.0);
        tessellator.func_78377_a((double)(scale / 2.0f), (double)(-flength), (double)(-scale / 2.0f));
        tessellator.func_78377_a((double)(scale / 2.0f), (double)(-flength), (double)(scale / 2.0f));
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawTip(float size, float tip) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a(0.0, (double)(-tip), 0.0);
        tessellator.func_78377_a(0.0, (double)(-tip), 0.0);
        tessellator.func_78377_a((double)(-size / 2.0f), 0.0, (double)(-size / 2.0f));
        tessellator.func_78377_a((double)(size / 2.0f), 0.0, (double)(-size / 2.0f));
        tessellator.func_78377_a((double)(-size / 2.0f), 0.0, (double)(size / 2.0f));
        tessellator.func_78377_a(0.0, (double)(-tip), 0.0);
        tessellator.func_78377_a(0.0, (double)(-tip), 0.0);
        tessellator.func_78377_a((double)(size / 2.0f), 0.0, (double)(size / 2.0f));
        tessellator.func_78377_a((double)(-size / 2.0f), 0.0, (double)(-size / 2.0f));
        tessellator.func_78377_a(0.0, (double)(-tip), 0.0);
        tessellator.func_78377_a(0.0, (double)(-tip), 0.0);
        tessellator.func_78377_a((double)(-size / 2.0f), 0.0, (double)(size / 2.0f));
        tessellator.func_78377_a(0.0, (double)(-tip), 0.0);
        tessellator.func_78377_a(0.0, (double)(-tip), 0.0);
        tessellator.func_78377_a((double)(size / 2.0f), 0.0, (double)(-size / 2.0f));
        tessellator.func_78377_a((double)(size / 2.0f), 0.0, (double)(size / 2.0f));
        tessellator.func_78381_a();
    }

    public static void renderItemInFirstPerson(ItemRenderer itemRenderer, float partialTicks) {
        EntityClientPlayerMP player = SHRenderHelper.mc.field_71439_g;
        IOffhandRender offhandRender = (IOffhandRender)itemRenderer;
        ItemStack itemstack = player.func_70694_bm();
        if (itemstack != null && itemstack.func_77973_b() instanceof IDualItem) {
            float swingProgress = ((IDualItem)itemstack.func_77973_b()).getSwingProgress((EntityPlayer)player, partialTicks);
            float progress = offhandRender.getPrevEquippedProgressSH() + (offhandRender.getEquippedProgressSH() - offhandRender.getPrevEquippedProgressSH()) * partialTicks;
            float rotation = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
            float f = player.field_71164_i + (player.field_71155_g - player.field_71164_i) * partialTicks;
            float f1 = player.field_71163_h + (player.field_71154_f - player.field_71163_h) * partialTicks;
            int i = SHRenderHelper.mc.field_71441_e.func_72802_i(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v), 0);
            int i1 = i % 65536;
            int i2 = i / 65536;
            GL11.glPushMatrix();
            GL11.glRotatef((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(player.field_70126_B + (player.field_70177_z - player.field_70126_B) * partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GL11.glPopMatrix();
            GL11.glRotatef((float)((player.field_70125_A - f) * 0.1f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)((player.field_70177_z - f1) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)i1 / 1.0f), (float)((float)i2 / 1.0f));
            if (itemstack != null) {
                SHRenderHelper.applyColorFromItemStack(itemstack, 0);
            }
            f1 = 0.8f;
            if (itemstack != null) {
                float f4;
                float f5;
                float f2;
                float f3;
                EnumAction action;
                GL11.glPushMatrix();
                if (player.func_71052_bv() > 0) {
                    action = itemstack.func_77975_n();
                    if (action == EnumAction.eat || action == EnumAction.drink) {
                        f3 = (float)player.func_71052_bv() - partialTicks + 1.0f;
                        f2 = 1.0f - f3 / (float)itemstack.func_77988_m();
                        f5 = 1.0f - f2;
                        f5 = f5 * f5 * f5;
                        f5 = f5 * f5 * f5;
                        f5 = f5 * f5 * f5;
                        float f6 = 1.0f - f5;
                        GL11.glTranslatef((float)0.0f, (float)(MathHelper.func_76135_e((float)(MathHelper.func_76134_b((float)(f3 / 4.0f * (float)Math.PI)) * 0.1f)) * (float)((double)f2 > 0.2 ? 1 : 0)), (float)0.0f);
                        GL11.glTranslatef((float)(f6 * 0.6f), (float)(-f6 * 0.5f), (float)0.0f);
                        GL11.glRotatef((float)(f6 * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)(f6 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)(f6 * 30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                } else {
                    f4 = swingProgress;
                    f3 = MathHelper.func_76126_a((float)(f4 * (float)Math.PI));
                    f2 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f4) * (float)Math.PI));
                    GL11.glTranslatef((float)(f2 * 0.4f), (float)(MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f4) * (float)Math.PI * 2.0f)) * 0.2f), (float)(-f3 * 0.2f));
                }
                GL11.glTranslatef((float)(-0.7f * f1), (float)(-0.65f * f1 - (1.0f - progress) * 0.6f), (float)(-0.9f * f1));
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glEnable((int)32826);
                f4 = swingProgress;
                f3 = MathHelper.func_76126_a((float)(f4 * f4 * (float)Math.PI));
                f2 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f4) * (float)Math.PI));
                GL11.glRotatef((float)(-f3 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(f2 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-f2 * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                f5 = 0.4f;
                GL11.glScalef((float)f5, (float)f5, (float)f5);
                if (player.func_71052_bv() > 0) {
                    action = itemstack.func_77975_n();
                    if (action == EnumAction.block) {
                        GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
                        GL11.glRotatef((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    } else if (action == EnumAction.bow) {
                        GL11.glRotatef((float)-18.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)-12.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)-8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)-0.9f, (float)0.2f, (float)0.0f);
                        float f7 = (float)itemstack.func_77988_m() - ((float)player.func_71052_bv() - partialTicks + 1.0f);
                        float f8 = f7 / 20.0f;
                        f8 = (f8 * f8 + f8 * 2.0f) / 3.0f;
                        if (f8 > 1.0f) {
                            f8 = 1.0f;
                        }
                        if (f8 > 0.1f) {
                            GL11.glTranslatef((float)0.0f, (float)(MathHelper.func_76126_a((float)((f7 - 0.1f) * 1.3f)) * 0.01f * (f8 - 0.1f)), (float)0.0f);
                        }
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(f8 * 0.1f));
                        GL11.glRotatef((float)-335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
                        float f9 = 1.0f + f8 * 0.2f;
                        GL11.glScalef((float)1.0f, (float)1.0f, (float)f9);
                        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
                        GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                }
                if (itemstack.func_77973_b().func_77629_n_()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                itemRenderer.renderItem((EntityLivingBase)player, itemstack, 0, SHEnumHelper.EQUIPPED_FIRST_PERSON_OFFHAND);
                if (itemstack.func_77973_b().func_77623_v()) {
                    for (int j = 1; j < itemstack.func_77973_b().getRenderPasses(itemstack.func_77960_j()); ++j) {
                        SHRenderHelper.applyColorFromItemStack(itemstack, j);
                        itemRenderer.renderItem((EntityLivingBase)player, itemstack, j, SHEnumHelper.EQUIPPED_FIRST_PERSON_OFFHAND);
                    }
                }
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
        }
    }

    public static void renderItemIn3rdPerson(EntityPlayer player, ModelBiped model, float partialTicks) {
        ItemStack itemstack = player.func_70694_bm();
        if (itemstack != null && itemstack.func_77973_b() instanceof IDualItem) {
            IItemRenderer customRenderer;
            boolean is3D;
            RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)player);
            GL11.glPushMatrix();
            model.field_78113_g.func_78794_c(0.0625f);
            GL11.glTranslatef((float)0.0625f, (float)0.4375f, (float)0.0625f);
            if (player.field_71104_cf != null) {
                itemstack = new ItemStack(Items.field_151055_y);
            }
            EnumAction enumAction = null;
            if (player.func_71052_bv() > 0) {
                enumAction = itemstack.func_77975_n();
            }
            boolean bl = is3D = (customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED)) != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.EQUIPPED, itemstack, IItemRenderer.ItemRendererHelper.BLOCK_3D);
            if (itemstack.func_77973_b() instanceof ItemBlock && (is3D || RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)itemstack.func_77973_b()).func_149645_b()))) {
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                float f = 0.375f;
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(-f), (float)(-f), (float)f);
            } else if (itemstack.func_77973_b().func_77662_d()) {
                float f = 0.625f;
                if (itemstack.func_77973_b().func_77629_n_()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                if (player.func_71052_bv() > 0 && enumAction == EnumAction.block) {
                    GL11.glTranslatef((float)-0.05f, (float)0.0f, (float)-0.1f);
                    GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)f, (float)(-f), (float)f);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                float f = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)f, (float)f, (float)f);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            SHRenderHelper.renderItemAllPasses((EntityLivingBase)player, itemstack, SHEnumHelper.EQUIPPED_OFFHAND);
            GL11.glPopMatrix();
        }
    }

    public static void renderItemAllPasses(EntityLivingBase entity, ItemStack itemstack, IItemRenderer.ItemRenderType type) {
        if (itemstack.func_77973_b().func_77623_v()) {
            for (int i = 0; i < itemstack.func_77973_b().getRenderPasses(itemstack.func_77960_j()); ++i) {
                SHRenderHelper.applyColorFromItemStack(itemstack, i);
                RenderManager.field_78727_a.field_78721_f.renderItem(entity, itemstack, i, IItemRenderer.ItemRenderType.EQUIPPED);
            }
        } else {
            SHRenderHelper.applyColorFromItemStack(itemstack, 0);
            RenderManager.field_78727_a.field_78721_f.renderItem(entity, itemstack, 0, SHEnumHelper.EQUIPPED_OFFHAND);
        }
    }

    public static void renderCape(ModelBipedMultiLayer model, Entity entity) {
        SHRenderHelper.renderCape(model, entity, 24);
    }

    public static void renderCape(ModelBipedMultiLayer model, Entity entity, int capeLength) {
        if (model.armorSlot != 1) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            Hero hero = SHHelper.getHeroFromArmor(player, 2);
            HeroRenderer heroRenderer = SuperHeroesAPIClient.getRendererForHero(hero);
            mc.func_110434_K().func_110577_a(heroRenderer.getCapeTexture());
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glPushMatrix();
            GL11.glEnable((int)2884);
            model.field_78115_e.func_78794_c(0.0625f);
            int texWidth = 14;
            float quality = 1.0f;
            float segments = 200.0f * quality;
            float width = (float)texWidth * 0.0625f;
            float length = (float)capeLength * 0.0625f / segments;
            float partialTicks = ClientEventHandler.renderTick;
            GL11.glTranslatef((float)0.0f, (float)-0.02f, (float)0.1575f);
            double d3 = player.field_71091_bM + (player.field_71094_bP - player.field_71091_bM) * (double)partialTicks - (player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks);
            double d4 = player.field_71096_bN + (player.field_71095_bQ - player.field_71096_bN) * (double)partialTicks - (player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks);
            double d0 = player.field_71097_bO + (player.field_71085_bR - player.field_71097_bO) * (double)partialTicks - (player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks);
            float f6 = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
            double d1 = MathHelper.func_76126_a((float)(f6 * (float)Math.PI / 180.0f));
            double d2 = -MathHelper.func_76134_b((float)(f6 * (float)Math.PI / 180.0f));
            float f7 = (float)d4 * 10.0f;
            if (f7 < -6.0f) {
                f7 = -6.0f;
            }
            if (f7 > 32.0f) {
                f7 = 32.0f;
            }
            float f8 = (float)(d3 * d1 + d0 * d2) * 100.0f;
            float f9 = (float)(d3 * d2 - d0 * d1) * 100.0f;
            if (f8 < 0.0f) {
                f8 = 0.0f;
            }
            float f10 = player.field_71107_bF + (player.field_71109_bG - player.field_71107_bF) * f7;
            f7 += MathHelper.func_76126_a((float)((player.field_70141_P + (player.field_70140_Q - player.field_70141_P) * f7) * 6.0f)) * 32.0f * f10;
            float f11 = MathHelper.func_76131_a((float)(f8 / 2.0f + f7), (float)0.0f, (float)110.0f);
            if (player.field_71106_cc == -0.0085f || player.field_71106_cc == -0.0086f) {
                f11 = 0.0f;
            }
            float f12 = f11 / 100.0f;
            float f13 = (float)capeLength / 32.0f;
            float f14 = (float)texWidth / 64.0f;
            float f = SHRenderHelper.median(SHData.getFloat(player, 46), SHData.getFloat(player, 47));
            float f1 = 1.0f - f * f * 0.8f;
            float f2 = -0.261799f;
            float f3 = 1.0f;
            float f4 = 1.0f - Math.min(f * 2.0f, 1.0f);
            float f5 = MathHelper.func_76131_a((float)((f - 0.5f) * 2.0f), (float)0.0f, (float)1.0f);
            if (player.field_70181_x < 0.0) {
                Vec3 vec3d = Vec3.func_72443_a((double)player.field_70159_w, (double)player.field_70181_x, (double)player.field_70179_y).func_72432_b();
                f3 = 1.0f - (float)Math.pow(-vec3d.field_72448_b, 1.5);
            }
            f2 = f3 * -1.570796f + (1.0f - f3) * f2;
            GL11.glRotatef((float)((6.0f + f11) * f4 + 6.0f * f5), (float)1.0f, (float)0.0f, (float)0.0f);
            for (int i = 0; i < 2; ++i) {
                GL11.glPushMatrix();
                if (f4 > 0.0f) {
                    int j = 0;
                    while ((float)j < segments) {
                        GL11.glRotatef((float)((float)Math.cos(f12 * 1.5f) * f12 / quality * f4), (float)1.0f, (float)0.0f, (float)0.0f);
                        tessellator.func_78382_b();
                        if (i == 0) {
                            tessellator.func_78374_a((double)(width / 2.0f), 0.0, 0.0, 0.0, (double)(f13 / segments * (float)j));
                            tessellator.func_78374_a((double)(width / 2.0f), (double)length, 0.0, 0.0, (double)(f13 / segments * (float)(j + 1)));
                            tessellator.func_78374_a((double)(-width / 2.0f), (double)length, 0.0, (double)f14, (double)(f13 / segments * (float)(j + 1)));
                            tessellator.func_78374_a((double)(-width / 2.0f), 0.0, 0.0, (double)f14, (double)(f13 / segments * (float)j));
                        } else {
                            tessellator.func_78374_a((double)(-width / 2.0f), (double)length, 0.0, (double)f14, (double)(f13 / segments * (float)(j + 1)));
                            tessellator.func_78374_a((double)(width / 2.0f), (double)length, 0.0, (double)(f14 * 2.0f), (double)(f13 / segments * (float)(j + 1)));
                            tessellator.func_78374_a((double)(width / 2.0f), 0.0, 0.0, (double)(f14 * 2.0f), (double)(f13 / segments * (float)j));
                            tessellator.func_78374_a((double)(-width / 2.0f), 0.0, 0.0, (double)f14, (double)(f13 / segments * (float)j));
                        }
                        tessellator.func_78381_a();
                        GL11.glTranslatef((float)0.0f, (float)length, (float)0.0f);
                        ++j;
                    }
                } else {
                    float fn = 1.0f - f5;
                    float fm = 1.0f - fn;
                    tessellator.func_78382_b();
                    if (i == 0) {
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 2.75f * fm), (double)(-0.4f * fm), 0.0, 0.0, 0.0);
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 2.25f * fm), (double)((float)capeLength * 0.3f * 0.0625f), 0.0, 0.0, (double)(f13 * 0.3f));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * 0.3f));
                        tessellator.func_78374_a(0.0, 0.0, 0.0, (double)(f14 / 2.0f), 0.0);
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 2.25f * fm), (double)((float)capeLength * 0.3f * 0.0625f), 0.0, 0.0, (double)(f13 * 0.3f));
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 0.9f * fm), (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, 0.0, (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * 0.3f));
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 0.9f * fm), (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, 0.0, (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 0.25f * fm), (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, 0.0, (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 0.25f * fm), (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, 0.0, (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a((double)(width / 2.0f * fn), (double)((float)capeLength * (1.0f + 0.4f * fm) * 0.0625f), 0.0, 0.0, (double)f13);
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f + 0.4f * fm) * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)f13);
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * 0.3f));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 2.25f * fm), (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)f14, (double)(f13 * 0.3f));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 2.75f * fm), (double)(-0.4f * fm), 0.0, (double)f14, 0.0);
                        tessellator.func_78374_a(0.0, 0.0, 0.0, (double)(f14 / 2.0f), 0.0);
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 0.9f * fm), (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)f14, (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 2.25f * fm), (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)f14, (double)(f13 * 0.3f));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * 0.3f));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 0.25f * fm), (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)f14, (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 0.9f * fm), (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)f14, (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f + 0.4f * fm) * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)f13);
                        tessellator.func_78374_a((double)(-width / 2.0f * fn), (double)((float)capeLength * (1.0f + 0.4f * fm) * 0.0625f), 0.0, (double)f14, (double)f13);
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 0.25f * fm), (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)f14, (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 / 2.0f), (double)(f13 * (1.0f - 0.1f * fm)));
                    } else {
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * 0.3f));
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 2.25f * fm), (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)f14, (double)(f13 * 0.3f));
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 2.75f * fm), (double)(-0.4f * fm), 0.0, (double)f14, 0.0);
                        tessellator.func_78374_a(0.0, 0.0, 0.0, (double)(f14 + f14 / 2.0f), 0.0);
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 0.9f * fm), (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + 0.0f), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 2.25f * fm), (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 + 0.0f), (double)(f13 * 0.3f));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * 0.3f));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 0.25f * fm), (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 + 0.0f), (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 0.9f * fm), (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + 0.0f), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f + 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)f13);
                        tessellator.func_78374_a((double)(width / 2.0f * fn), (double)((float)capeLength * (1.0f + 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + 0.0f), (double)f13);
                        tessellator.func_78374_a((double)(width / 2.0f * fn + width * 0.25f * fm), (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 + 0.0f), (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 2.75f * fm), (double)(-0.4f * fm), 0.0, (double)(f14 + f14), 0.0);
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 2.25f * fm), (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 + f14), (double)(f13 * 0.3f));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * 0.3f));
                        tessellator.func_78374_a(0.0, 0.0, 0.0, (double)(f14 + f14 / 2.0f), 0.0);
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 2.25f * fm), (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 + f14), (double)(f13 * 0.3f));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 0.9f * fm), (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + f14), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * 0.3f * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * 0.3f));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 0.9f * fm), (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + f14), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 0.25f * fm), (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 + f14), (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * (1.0f - 0.4f * fm)));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn - width * 0.25f * fm), (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 + f14), (double)(f13 * (1.0f - 0.1f * fm)));
                        tessellator.func_78374_a((double)(-width / 2.0f * fn), (double)((float)capeLength * (1.0f + 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + f14), (double)f13);
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f + 0.4f * fm) * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)f13);
                        tessellator.func_78374_a(0.0, (double)((float)capeLength * (1.0f - 0.1f * fm) * 0.0625f), 0.0, (double)(f14 + f14 / 2.0f), (double)(f13 * (1.0f - 0.1f * fm)));
                    }
                    tessellator.func_78381_a();
                }
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)2884);
            GL11.glPopMatrix();
        }
    }

    public static void renderLightning(Lightning lightning, float opacity, Tessellator tessellator) {
        if (SHConfig.vibrantLightningColors) {
            GL11.glBlendFunc((int)770, (int)32772);
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
        float prevWidth = GL11.glGetFloat((int)2849);
        SHRenderHelper.setLighting(61680);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        GL11.glAlphaFunc((int)516, (float)0.99f);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glPushMatrix();
        GL11.glLineWidth((float)4.0f);
        SHRenderHelper.renderLightningPart(lightning, 0, opacity, tessellator);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)10.0f);
        SHRenderHelper.renderLightningPart(lightning, 0, opacity * 0.5f, tessellator);
        GL11.glPopMatrix();
        GL11.glEnable((int)3008);
        GL11.glDepthMask((boolean)true);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPushMatrix();
        GL11.glLineWidth((float)1.0f);
        SHRenderHelper.renderLightningPart(lightning, 1, opacity, tessellator);
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glLineWidth((float)prevWidth);
        SHRenderHelper.resetLighting();
        if (SHConfig.vibrantLightningColors) {
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    public static void renderLightningPart(Lightning lightning, int layer, float opacity, Tessellator tessellator) {
        Vec3 color = lightning.lightningColor;
        if (layer == 1) {
            color = Vec3.func_72443_a((double)1.0, (double)1.0, (double)1.0);
        }
        if (lightning.rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (lightning.rotateAngleY != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleY, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (lightning.rotateAngleX != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleX, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        tessellator.func_78371_b(3);
        tessellator.func_78369_a((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, opacity);
        tessellator.func_78377_a(0.0, 0.0, 0.0);
        tessellator.func_78377_a(0.0, (double)lightning.length, 0.0);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.0f, (float)lightning.length, (float)0.0f);
        for (Lightning lightning1 : lightning.children) {
            GL11.glPushMatrix();
            SHRenderHelper.renderLightningPart(lightning1, layer, opacity, tessellator);
            GL11.glPopMatrix();
        }
    }

    public static void doLightningAura(EntityPlayer player) {
        Random rand = new Random();
        if (player == SHRenderHelper.mc.field_71439_g && SHRenderHelper.mc.field_71474_y.field_74320_O == 0) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            double maxRenderDistance;
            double d5;
            double diffZ;
            double d4;
            double diffY;
            double d3;
            double diffX;
            double d2;
            double d1;
            double d0 = rand.nextFloat() * 2.0f - 1.0f;
            if (!(d0 * d0 + (d1 = (double)(rand.nextFloat() * 2.0f - 1.0f)) * d1 + (d2 = (double)(rand.nextFloat() * 2.0f - 1.0f)) * d2 <= 1.0) || !((diffX = SHRenderHelper.mc.field_71451_h.field_70165_t - (d3 = player.field_70165_t + d0 * (double)player.field_70130_N / 4.0)) * diffX + (diffY = SHRenderHelper.mc.field_71451_h.field_70163_u - (d4 = player.field_70121_D.field_72338_b + (double)player.field_70131_O * (double)rand.nextFloat())) * diffY + (diffZ = SHRenderHelper.mc.field_71451_h.field_70161_v - (d5 = player.field_70161_v + d2 * (double)player.field_70130_N / 4.0)) * diffZ <= (maxRenderDistance = 64.0) * maxRenderDistance)) continue;
            float length = 0.1f;
            Lightning lightning = SHHelper.createLightning(SpeedsterHelper.getTrailType(player).getTrailColor(), 0L, length).setScale(SHRenderHelper.getScale(player));
            SHRenderHelper.mc.field_71452_i.func_78873_a((EntityFX)new EntitySHLightningFX(player.field_70170_p, lightning, d3, d4, d5));
        }
    }

    public static float getScale(EntityPlayer player) {
        return SHRenderHelper.median(SHData.getFloat(player, 6), SHData.getFloat(player, 34));
    }

    public static boolean shouldOverrideView(EntityPlayer player) {
        return SHRenderHelper.getScale(player) != 1.0f || SHHelper.getSideStandingOn(player) != 1 || SHData.getBoolean(player, 42);
    }

    public static boolean shouldOverrideThirdPersonDistance(EntityPlayer player) {
        float scale = SHRenderHelper.getScale(player);
        return SHHelper.getHero(player) != null || SHData.get(player, 33) != null;
    }

    public static float median(double curr, double prev) {
        return (float)(prev + (curr - prev) * (double)ClientEventHandler.renderTick);
    }
}

